/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language.bm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.codec.Resources;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.NameType;
import org.apache.commons.codec.language.bm.Rule;
import org.apache.commons.codec.language.bm.RuleType;

/*
 * Exception performing whole class analysis ignored.
 */
public class Rule {
    public static final RPattern ALL_STRINGS_RMATCHER = new /* Unavailable Anonymous Inner Class!! */;
    public static final String ALL = "ALL";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String HASH_INCLUDE = "#include";
    private static final Map<NameType, Map<RuleType, Map<String, Map<String, List<Rule>>>>> RULES = new EnumMap(NameType.class);
    private final RPattern lContext;
    private final String pattern;
    private final PhonemeExpr phoneme;
    private final RPattern rContext;

    private static boolean contains(CharSequence chars, char input) {
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.charAt(i) != input) continue;
            return true;
        }
        return false;
    }

    private static String createResourceName(NameType nameType, RuleType rt, String lang) {
        return String.format("org/apache/commons/codec/language/bm/%s_%s_%s.txt", nameType.getName(), rt.getName(), lang);
    }

    private static Scanner createScanner(NameType nameType, RuleType rt, String lang) {
        String resName = Rule.createResourceName((NameType)nameType, (RuleType)rt, (String)lang);
        return new Scanner(Resources.getInputStream((String)resName), "UTF-8");
    }

    private static Scanner createScanner(String lang) {
        String resName = String.format("org/apache/commons/codec/language/bm/%s.txt", lang);
        return new Scanner(Resources.getInputStream((String)resName), "UTF-8");
    }

    private static boolean endsWith(CharSequence input, CharSequence suffix) {
        if (suffix.length() > input.length()) {
            return false;
        }
        int i = input.length() - 1;
        for (int j = suffix.length() - 1; j >= 0; --j) {
            if (input.charAt(i) != suffix.charAt(j)) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static List<Rule> getInstance(NameType nameType, RuleType rt, Languages.LanguageSet langs) {
        Map ruleMap = Rule.getInstanceMap((NameType)nameType, (RuleType)rt, (Languages.LanguageSet)langs);
        ArrayList<Rule> allRules = new ArrayList<Rule>();
        for (List rules : ruleMap.values()) {
            allRules.addAll(rules);
        }
        return allRules;
    }

    public static List<Rule> getInstance(NameType nameType, RuleType rt, String lang) {
        return Rule.getInstance((NameType)nameType, (RuleType)rt, (Languages.LanguageSet)Languages.LanguageSet.from(new HashSet<String>(Arrays.asList(lang))));
    }

    public static Map<String, List<Rule>> getInstanceMap(NameType nameType, RuleType rt, Languages.LanguageSet langs) {
        return langs.isSingleton() ? Rule.getInstanceMap((NameType)nameType, (RuleType)rt, (String)langs.getAny()) : Rule.getInstanceMap((NameType)nameType, (RuleType)rt, (String)"any");
    }

    public static Map<String, List<Rule>> getInstanceMap(NameType nameType, RuleType rt, String lang) {
        Map rules = (Map)((Map)((Map)RULES.get(nameType)).get(rt)).get(lang);
        if (rules == null) {
            throw new IllegalArgumentException(String.format("No rules found for %s, %s, %s.", nameType.getName(), rt.getName(), lang));
        }
        return rules;
    }

    private static Phoneme parsePhoneme(String ph) {
        int open = ph.indexOf("[");
        if (open >= 0) {
            if (!ph.endsWith("]")) {
                throw new IllegalArgumentException("Phoneme expression contains a '[' but does not end in ']'");
            }
            String before = ph.substring(0, open);
            String in = ph.substring(open + 1, ph.length() - 1);
            HashSet<String> langs = new HashSet<String>(Arrays.asList(in.split("[+]")));
            return new Phoneme((CharSequence)before, Languages.LanguageSet.from(langs));
        }
        return new Phoneme((CharSequence)ph, Languages.ANY_LANGUAGE);
    }

    private static PhonemeExpr parsePhonemeExpr(String ph) {
        if (ph.startsWith("(")) {
            if (!ph.endsWith(")")) {
                throw new IllegalArgumentException("Phoneme starts with '(' so must end with ')'");
            }
            ArrayList<Phoneme> phs = new ArrayList<Phoneme>();
            String body = ph.substring(1, ph.length() - 1);
            for (String part : body.split("[|]")) {
                phs.add(Rule.parsePhoneme((String)part));
            }
            if (body.startsWith("|") || body.endsWith("|")) {
                phs.add(new Phoneme((CharSequence)"", Languages.ANY_LANGUAGE));
            }
            return new PhonemeList(phs);
        }
        return Rule.parsePhoneme((String)ph);
    }

    private static Map<String, List<Rule>> parseRules(Scanner scanner, String location) {
        HashMap<String, List<Rule>> lines = new HashMap<String, List<Rule>>();
        int currentLine = 0;
        boolean inMultilineComment = false;
        while (scanner.hasNextLine()) {
            String rawLine;
            ++currentLine;
            String line = rawLine = scanner.nextLine();
            if (inMultilineComment) {
                if (!line.endsWith("*/")) continue;
                inMultilineComment = false;
                continue;
            }
            if (line.startsWith("/*")) {
                inMultilineComment = true;
                continue;
            }
            int cmtI = line.indexOf("//");
            if (cmtI >= 0) {
                line = line.substring(0, cmtI);
            }
            if ((line = line.trim()).length() == 0) continue;
            if (line.startsWith("#include")) {
                String incl = line.substring("#include".length()).trim();
                if (incl.contains(" ")) {
                    throw new IllegalArgumentException("Malformed import statement '" + rawLine + "' in " + location);
                }
                Scanner hashIncludeScanner = Rule.createScanner((String)incl);
                Throwable throwable = null;
                try {
                    lines.putAll(Rule.parseRules((Scanner)hashIncludeScanner, (String)(location + "->" + incl)));
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (hashIncludeScanner == null) continue;
                    if (throwable != null) {
                        try {
                            hashIncludeScanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    hashIncludeScanner.close();
                    continue;
                }
            }
            String[] parts = line.split("\\s+");
            if (parts.length != 4) {
                throw new IllegalArgumentException("Malformed rule statement split into " + parts.length + " parts: " + rawLine + " in " + location);
            }
            try {
                String pat = Rule.stripQuotes((String)parts[0]);
                String lCon = Rule.stripQuotes((String)parts[1]);
                String rCon = Rule.stripQuotes((String)parts[2]);
                PhonemeExpr ph = Rule.parsePhonemeExpr((String)Rule.stripQuotes((String)parts[3]));
                int cLine = currentLine;
                2 r = new /* Unavailable Anonymous Inner Class!! */;
                String patternKey = r.pattern.substring(0, 1);
                ArrayList<2> rules = (ArrayList<2>)lines.get(patternKey);
                if (rules == null) {
                    rules = new ArrayList<2>();
                    lines.put(patternKey, rules);
                }
                rules.add(r);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Problem parsing line '" + currentLine + "' in " + location, e);
            }
        }
        return lines;
    }

    private static RPattern pattern(String regex) {
        boolean endsWith;
        boolean startsWith = regex.startsWith("^");
        String content = regex.substring(startsWith ? 1 : 0, (endsWith = regex.endsWith("$")) ? regex.length() - 1 : regex.length());
        boolean boxes = content.contains("[");
        if (!boxes) {
            if (startsWith && endsWith) {
                if (content.length() == 0) {
                    return new /* Unavailable Anonymous Inner Class!! */;
                }
                return new /* Unavailable Anonymous Inner Class!! */;
            }
            if ((startsWith || endsWith) && content.length() == 0) {
                return ALL_STRINGS_RMATCHER;
            }
            if (startsWith) {
                return new /* Unavailable Anonymous Inner Class!! */;
            }
            if (endsWith) {
                return new /* Unavailable Anonymous Inner Class!! */;
            }
        } else {
            String boxContent;
            boolean startsWithBox = content.startsWith("[");
            boolean endsWithBox = content.endsWith("]");
            if (startsWithBox && endsWithBox && !(boxContent = content.substring(1, content.length() - 1)).contains("[")) {
                boolean shouldMatch;
                boolean negate = boxContent.startsWith("^");
                if (negate) {
                    boxContent = boxContent.substring(1);
                }
                String bContent = boxContent;
                boolean bl = shouldMatch = !negate;
                if (startsWith && endsWith) {
                    return new /* Unavailable Anonymous Inner Class!! */;
                }
                if (startsWith) {
                    return new /* Unavailable Anonymous Inner Class!! */;
                }
                if (endsWith) {
                    return new /* Unavailable Anonymous Inner Class!! */;
                }
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static boolean startsWith(CharSequence input, CharSequence prefix) {
        if (prefix.length() > input.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (input.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static String stripQuotes(String str) {
        if (str.startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public Rule(String pattern, String lContext, String rContext, PhonemeExpr phoneme) {
        this.pattern = pattern;
        this.lContext = Rule.pattern((String)(lContext + "$"));
        this.rContext = Rule.pattern((String)("^" + rContext));
        this.phoneme = phoneme;
    }

    public RPattern getLContext() {
        return this.lContext;
    }

    public String getPattern() {
        return this.pattern;
    }

    public PhonemeExpr getPhoneme() {
        return this.phoneme;
    }

    public RPattern getRContext() {
        return this.rContext;
    }

    public boolean patternAndContextMatches(CharSequence input, int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException("Can not match pattern at negative indexes");
        }
        int patternLength = this.pattern.length();
        int ipl = i + patternLength;
        if (ipl > input.length()) {
            return false;
        }
        if (!input.subSequence(i, ipl).equals(this.pattern)) {
            return false;
        }
        if (!this.rContext.isMatch(input.subSequence(ipl, input.length()))) {
            return false;
        }
        return this.lContext.isMatch(input.subSequence(0, i));
    }

    static /* synthetic */ boolean access$100(CharSequence x0, CharSequence x1) {
        return Rule.startsWith((CharSequence)x0, (CharSequence)x1);
    }

    static /* synthetic */ boolean access$200(CharSequence x0, CharSequence x1) {
        return Rule.endsWith((CharSequence)x0, (CharSequence)x1);
    }

    static /* synthetic */ boolean access$300(CharSequence x0, char x1) {
        return Rule.contains((CharSequence)x0, (char)x1);
    }

    static {
        for (NameType s : NameType.values()) {
            EnumMap rts = new EnumMap(RuleType.class);
            for (RuleType rt : RuleType.values()) {
                HashMap<String, Map> rs = new HashMap<String, Map>();
                Languages ls = Languages.getInstance((NameType)s);
                for (String l : ls.getLanguages()) {
                    try {
                        Scanner scanner = Rule.createScanner((NameType)s, (RuleType)rt, (String)l);
                        Throwable throwable = null;
                        try {
                            rs.put(l, Rule.parseRules((Scanner)scanner, (String)Rule.createResourceName((NameType)s, (RuleType)rt, (String)l)));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (scanner == null) continue;
                            if (throwable != null) {
                                try {
                                    scanner.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            scanner.close();
                        }
                    }
                    catch (IllegalStateException e) {
                        throw new IllegalStateException("Problem processing " + Rule.createResourceName((NameType)s, (RuleType)rt, (String)l), e);
                    }
                }
                if (!rt.equals((Object)RuleType.RULES)) {
                    try (Scanner scanner = Rule.createScanner((NameType)s, (RuleType)rt, (String)"common");){
                        rs.put("common", Rule.parseRules((Scanner)scanner, (String)Rule.createResourceName((NameType)s, (RuleType)rt, (String)"common")));
                    }
                }
                rts.put(rt, Collections.unmodifiableMap(rs));
            }
            RULES.put(s, Collections.unmodifiableMap(rts));
        }
    }
}

