/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.iterators.SingletonIterator;

/*
 * Exception performing whole class analysis ignored.
 */
public class FluentIterable<E>
implements Iterable<E> {
    private final Iterable<E> iterable;

    public static <T> FluentIterable<T> empty() {
        return IterableUtils.EMPTY_ITERABLE;
    }

    public static <T> FluentIterable<T> of(T singleton) {
        return FluentIterable.of((Iterable)IteratorUtils.asIterable((Iterator)new SingletonIterator(singleton, false)));
    }

    public static <T> FluentIterable<T> of(T ... elements) {
        return FluentIterable.of(Arrays.asList(elements));
    }

    public static <T> FluentIterable<T> of(Iterable<T> iterable) {
        IterableUtils.checkNotNull(iterable);
        if (iterable instanceof FluentIterable) {
            return (FluentIterable)iterable;
        }
        return new FluentIterable(iterable);
    }

    FluentIterable() {
        this.iterable = this;
    }

    private FluentIterable(Iterable<E> iterable) {
        this.iterable = iterable;
    }

    public FluentIterable<E> append(E ... elements) {
        return this.append(Arrays.asList(elements));
    }

    public FluentIterable<E> append(Iterable<? extends E> other) {
        return FluentIterable.of((Iterable)IterableUtils.chainedIterable((Iterable)this.iterable, other));
    }

    public FluentIterable<E> collate(Iterable<? extends E> other) {
        return FluentIterable.of((Iterable)IterableUtils.collatedIterable((Iterable)this.iterable, other));
    }

    public FluentIterable<E> collate(Iterable<? extends E> other, Comparator<? super E> comparator) {
        return FluentIterable.of((Iterable)IterableUtils.collatedIterable(comparator, (Iterable)this.iterable, other));
    }

    public FluentIterable<E> eval() {
        return FluentIterable.of((Iterable)this.toList());
    }

    public FluentIterable<E> filter(Predicate<? super E> predicate) {
        return FluentIterable.of((Iterable)IterableUtils.filteredIterable((Iterable)this.iterable, predicate));
    }

    public FluentIterable<E> limit(long maxSize) {
        return FluentIterable.of((Iterable)IterableUtils.boundedIterable((Iterable)this.iterable, (long)maxSize));
    }

    public FluentIterable<E> loop() {
        return FluentIterable.of((Iterable)IterableUtils.loopingIterable((Iterable)this.iterable));
    }

    public FluentIterable<E> reverse() {
        return FluentIterable.of((Iterable)IterableUtils.reversedIterable((Iterable)this.iterable));
    }

    public FluentIterable<E> skip(long elementsToSkip) {
        return FluentIterable.of((Iterable)IterableUtils.skippingIterable((Iterable)this.iterable, (long)elementsToSkip));
    }

    public <O> FluentIterable<O> transform(Transformer<? super E, ? extends O> transformer) {
        return FluentIterable.of((Iterable)IterableUtils.transformedIterable((Iterable)this.iterable, transformer));
    }

    public FluentIterable<E> unique() {
        return FluentIterable.of((Iterable)IterableUtils.uniqueIterable((Iterable)this.iterable));
    }

    public FluentIterable<E> unmodifiable() {
        return FluentIterable.of((Iterable)IterableUtils.unmodifiableIterable((Iterable)this.iterable));
    }

    public FluentIterable<E> zip(Iterable<? extends E> other) {
        return FluentIterable.of((Iterable)IterableUtils.zippingIterable((Iterable)this.iterable, other));
    }

    public FluentIterable<E> zip(Iterable<? extends E> ... others) {
        return FluentIterable.of((Iterable)IterableUtils.zippingIterable((Iterable)this.iterable, (Iterable[])others));
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterable.iterator();
    }

    public Enumeration<E> asEnumeration() {
        return IteratorUtils.asEnumeration((Iterator)this.iterator());
    }

    public boolean allMatch(Predicate<? super E> predicate) {
        return IterableUtils.matchesAll((Iterable)this.iterable, predicate);
    }

    public boolean anyMatch(Predicate<? super E> predicate) {
        return IterableUtils.matchesAny((Iterable)this.iterable, predicate);
    }

    public boolean isEmpty() {
        return IterableUtils.isEmpty((Iterable)this.iterable);
    }

    public boolean contains(Object object) {
        return IterableUtils.contains((Iterable)this.iterable, (Object)object);
    }

    @Override
    public void forEach(Closure<? super E> closure) {
        IterableUtils.forEach((Iterable)this.iterable, closure);
    }

    public E get(int position) {
        return (E)IterableUtils.get((Iterable)this.iterable, (int)position);
    }

    public int size() {
        return IterableUtils.size((Iterable)this.iterable);
    }

    public void copyInto(Collection<? super E> collection) {
        if (collection == null) {
            throw new NullPointerException("Collection must not be null");
        }
        CollectionUtils.addAll(collection, (Iterable)this.iterable);
    }

    public E[] toArray(Class<E> arrayClass) {
        return IteratorUtils.toArray((Iterator)this.iterator(), arrayClass);
    }

    public List<E> toList() {
        return IterableUtils.toList((Iterable)this.iterable);
    }

    public String toString() {
        return IterableUtils.toString((Iterable)this.iterable);
    }
}

