/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Equator;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.FluentIterable;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.EqualPredicate;

/*
 * Exception performing whole class analysis ignored.
 */
public class IterableUtils {
    static final FluentIterable EMPTY_ITERABLE = new /* Unavailable Anonymous Inner Class!! */;

    public static <E> Iterable<E> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public static <E> Iterable<E> chainedIterable(Iterable<? extends E> a, Iterable<? extends E> b) {
        return IterableUtils.chainedIterable((Iterable[])new Iterable[]{a, b});
    }

    public static <E> Iterable<E> chainedIterable(Iterable<? extends E> a, Iterable<? extends E> b, Iterable<? extends E> c) {
        return IterableUtils.chainedIterable((Iterable[])new Iterable[]{a, b, c});
    }

    public static <E> Iterable<E> chainedIterable(Iterable<? extends E> a, Iterable<? extends E> b, Iterable<? extends E> c, Iterable<? extends E> d) {
        return IterableUtils.chainedIterable((Iterable[])new Iterable[]{a, b, c, d});
    }

    public static <E> Iterable<E> chainedIterable(Iterable<? extends E> ... iterables) {
        IterableUtils.checkNotNull((Iterable[])iterables);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> collatedIterable(Iterable<? extends E> a, Iterable<? extends E> b) {
        IterableUtils.checkNotNull((Iterable[])new Iterable[]{a, b});
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> collatedIterable(Comparator<? super E> comparator, Iterable<? extends E> a, Iterable<? extends E> b) {
        IterableUtils.checkNotNull((Iterable[])new Iterable[]{a, b});
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> filteredIterable(Iterable<E> iterable, Predicate<? super E> predicate) {
        IterableUtils.checkNotNull(iterable);
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null.");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> boundedIterable(Iterable<E> iterable, long maxSize) {
        IterableUtils.checkNotNull(iterable);
        if (maxSize < 0L) {
            throw new IllegalArgumentException("MaxSize parameter must not be negative.");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> loopingIterable(Iterable<E> iterable) {
        IterableUtils.checkNotNull(iterable);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> reversedIterable(Iterable<E> iterable) {
        IterableUtils.checkNotNull(iterable);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> skippingIterable(Iterable<E> iterable, long elementsToSkip) {
        IterableUtils.checkNotNull(iterable);
        if (elementsToSkip < 0L) {
            throw new IllegalArgumentException("ElementsToSkip parameter must not be negative.");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <I, O> Iterable<O> transformedIterable(Iterable<I> iterable, Transformer<? super I, ? extends O> transformer) {
        IterableUtils.checkNotNull(iterable);
        if (transformer == null) {
            throw new NullPointerException("Transformer must not be null.");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> uniqueIterable(Iterable<E> iterable) {
        IterableUtils.checkNotNull(iterable);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> unmodifiableIterable(Iterable<E> iterable) {
        IterableUtils.checkNotNull(iterable);
        if (iterable instanceof UnmodifiableIterable) {
            return iterable;
        }
        return new UnmodifiableIterable(iterable);
    }

    public static <E> Iterable<E> zippingIterable(Iterable<? extends E> a, Iterable<? extends E> b) {
        IterableUtils.checkNotNull(a);
        IterableUtils.checkNotNull(b);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> zippingIterable(Iterable<? extends E> first, Iterable<? extends E> ... others) {
        IterableUtils.checkNotNull(first);
        IterableUtils.checkNotNull((Iterable[])others);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <E> Iterable<E> emptyIfNull(Iterable<E> iterable) {
        return iterable == null ? IterableUtils.emptyIterable() : iterable;
    }

    public static <E> void forEach(Iterable<E> iterable, Closure<? super E> closure) {
        IteratorUtils.forEach((Iterator)IterableUtils.emptyIteratorIfNull(iterable), closure);
    }

    public static <E> E forEachButLast(Iterable<E> iterable, Closure<? super E> closure) {
        return (E)IteratorUtils.forEachButLast((Iterator)IterableUtils.emptyIteratorIfNull(iterable), closure);
    }

    public static <E> E find(Iterable<E> iterable, Predicate<? super E> predicate) {
        return (E)IteratorUtils.find((Iterator)IterableUtils.emptyIteratorIfNull(iterable), predicate);
    }

    public static <E> int indexOf(Iterable<E> iterable, Predicate<? super E> predicate) {
        return IteratorUtils.indexOf((Iterator)IterableUtils.emptyIteratorIfNull(iterable), predicate);
    }

    public static <E> boolean matchesAll(Iterable<E> iterable, Predicate<? super E> predicate) {
        return IteratorUtils.matchesAll((Iterator)IterableUtils.emptyIteratorIfNull(iterable), predicate);
    }

    public static <E> boolean matchesAny(Iterable<E> iterable, Predicate<? super E> predicate) {
        return IteratorUtils.matchesAny((Iterator)IterableUtils.emptyIteratorIfNull(iterable), predicate);
    }

    public static <E> long countMatches(Iterable<E> input, Predicate<? super E> predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null.");
        }
        return IterableUtils.size((Iterable)IterableUtils.filteredIterable((Iterable)IterableUtils.emptyIfNull(input), predicate));
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return IteratorUtils.isEmpty((Iterator)IterableUtils.emptyIteratorIfNull(iterable));
    }

    public static <E> boolean contains(Iterable<E> iterable, Object object) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).contains(object);
        }
        return IteratorUtils.contains((Iterator)IterableUtils.emptyIteratorIfNull(iterable), (Object)object);
    }

    public static <E> boolean contains(Iterable<? extends E> iterable, E object, Equator<? super E> equator) {
        if (equator == null) {
            throw new NullPointerException("Equator must not be null.");
        }
        return IterableUtils.matchesAny(iterable, (Predicate)EqualPredicate.equalPredicate(object, equator));
    }

    public static <E, T extends E> int frequency(Iterable<E> iterable, T obj) {
        if (iterable instanceof Set) {
            return ((Set)iterable).contains(obj) ? 1 : 0;
        }
        if (iterable instanceof Bag) {
            return ((Bag)iterable).getCount(obj);
        }
        return IterableUtils.size((Iterable)IterableUtils.filteredIterable((Iterable)IterableUtils.emptyIfNull(iterable), (Predicate)EqualPredicate.equalPredicate(obj)));
    }

    public static <T> T get(Iterable<T> iterable, int index) {
        CollectionUtils.checkIndexBounds((int)index);
        if (iterable instanceof List) {
            return (T)((List)iterable).get(index);
        }
        return (T)IteratorUtils.get((Iterator)IterableUtils.emptyIteratorIfNull(iterable), (int)index);
    }

    public static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return IteratorUtils.size((Iterator)IterableUtils.emptyIteratorIfNull(iterable));
    }

    public static <O> List<List<O>> partition(Iterable<? extends O> iterable, Predicate<? super O> predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null.");
        }
        Factory factory = FactoryUtils.instantiateFactory(ArrayList.class);
        Predicate[] predicates = new Predicate[]{predicate};
        return IterableUtils.partition(iterable, (Factory)factory, (Predicate[])predicates);
    }

    public static <O> List<List<O>> partition(Iterable<? extends O> iterable, Predicate<? super O> ... predicates) {
        Factory factory = FactoryUtils.instantiateFactory(ArrayList.class);
        return IterableUtils.partition(iterable, (Factory)factory, predicates);
    }

    public static <O, R extends Collection<O>> List<R> partition(Iterable<? extends O> iterable, Factory<R> partitionFactory, Predicate<? super O> ... predicates) {
        if (iterable == null) {
            Iterable empty = IterableUtils.emptyIterable();
            return IterableUtils.partition((Iterable)empty, partitionFactory, predicates);
        }
        if (predicates == null) {
            throw new NullPointerException("Predicates must not be null.");
        }
        for (Predicate<? super O> p : predicates) {
            if (p != null) continue;
            throw new NullPointerException("Predicate must not be null.");
        }
        if (predicates.length < 1) {
            Collection singlePartition = (Collection)partitionFactory.create();
            CollectionUtils.addAll((Collection)singlePartition, iterable);
            return Collections.singletonList(singlePartition);
        }
        int numberOfPredicates = predicates.length;
        int numberOfPartitions = numberOfPredicates + 1;
        ArrayList<Object> partitions = new ArrayList<Object>(numberOfPartitions);
        for (int i = 0; i < numberOfPartitions; ++i) {
            partitions.add(partitionFactory.create());
        }
        for (O element : iterable) {
            boolean elementAssigned = false;
            for (int i = 0; i < numberOfPredicates; ++i) {
                if (!predicates[i].evaluate(element)) continue;
                ((Collection)partitions.get(i)).add(element);
                elementAssigned = true;
                break;
            }
            if (elementAssigned) continue;
            ((Collection)partitions.get(numberOfPredicates)).add(element);
        }
        return partitions;
    }

    public static <E> List<E> toList(Iterable<E> iterable) {
        return IteratorUtils.toList((Iterator)IterableUtils.emptyIteratorIfNull(iterable));
    }

    public static <E> String toString(Iterable<E> iterable) {
        return IteratorUtils.toString((Iterator)IterableUtils.emptyIteratorIfNull(iterable));
    }

    public static <E> String toString(Iterable<E> iterable, Transformer<? super E, String> transformer) {
        if (transformer == null) {
            throw new NullPointerException("Transformer must not be null.");
        }
        return IteratorUtils.toString((Iterator)IterableUtils.emptyIteratorIfNull(iterable), transformer);
    }

    public static <E> String toString(Iterable<E> iterable, Transformer<? super E, String> transformer, String delimiter, String prefix, String suffix) {
        return IteratorUtils.toString((Iterator)IterableUtils.emptyIteratorIfNull(iterable), transformer, (String)delimiter, (String)prefix, (String)suffix);
    }

    static void checkNotNull(Iterable<?> iterable) {
        if (iterable == null) {
            throw new NullPointerException("Iterable must not be null.");
        }
    }

    static void checkNotNull(Iterable<?> ... iterables) {
        if (iterables == null) {
            throw new NullPointerException("Iterables must not be null.");
        }
        for (Iterable<?> iterable : iterables) {
            IterableUtils.checkNotNull(iterable);
        }
    }

    private static <E> Iterator<E> emptyIteratorIfNull(Iterable<E> iterable) {
        return iterable != null ? iterable.iterator() : IteratorUtils.emptyIterator();
    }

    static /* synthetic */ Iterator access$000(Iterable x0) {
        return IterableUtils.emptyIteratorIfNull((Iterable)x0);
    }
}

