/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Map;
import org.apache.commons.collections4.Get;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.Put;
import org.apache.commons.collections4.SplitMapUtils;

public class SplitMapUtils {
    private SplitMapUtils() {
    }

    public static <K, V> IterableMap<K, V> readableMap(Get<K, V> get) {
        if (get == null) {
            throw new NullPointerException("Get must not be null");
        }
        if (get instanceof Map) {
            return get instanceof IterableMap ? (IterableMap)get : MapUtils.iterableMap((Map)((Map)get));
        }
        return new WrappedGet(get, null);
    }

    public static <K, V> Map<K, V> writableMap(Put<K, V> put) {
        if (put == null) {
            throw new NullPointerException("Put must not be null");
        }
        if (put instanceof Map) {
            return (Map)put;
        }
        return new WrappedPut(put, null);
    }
}

