/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.bag.AbstractMapBag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.set.UnmodifiableSet;

public abstract class AbstractMapBag<E>
implements Bag<E> {
    private transient Map<E, MutableInteger> map;
    private int size;
    private transient int modCount;
    private transient Set<E> uniqueSet;

    protected AbstractMapBag() {
    }

    protected AbstractMapBag(Map<E, MutableInteger> map) {
        this.map = map;
    }

    protected Map<E, MutableInteger> getMap() {
        return this.map;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int getCount(Object object) {
        MutableInteger count = (MutableInteger)this.map.get(object);
        if (count != null) {
            return count.value;
        }
        return 0;
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public boolean containsAll(Collection<?> coll) {
        if (coll instanceof Bag) {
            return this.containsAll((Bag)coll);
        }
        return this.containsAll((Bag)new HashBag(coll));
    }

    boolean containsAll(Bag<?> other) {
        for (Object current : other.uniqueSet()) {
            if (this.getCount(current) >= other.getCount(current)) continue;
            return false;
        }
        return true;
    }

    public Iterator<E> iterator() {
        return new BagIterator(this);
    }

    public boolean add(E object) {
        return this.add(object, 1);
    }

    public boolean add(E object, int nCopies) {
        ++this.modCount;
        if (nCopies > 0) {
            MutableInteger mut = (MutableInteger)this.map.get(object);
            this.size += nCopies;
            if (mut == null) {
                this.map.put(object, new MutableInteger(nCopies));
                return true;
            }
            mut.value += nCopies;
            return false;
        }
        return false;
    }

    public boolean addAll(Collection<? extends E> coll) {
        boolean changed = false;
        Iterator<E> i = coll.iterator();
        while (i.hasNext()) {
            boolean added = this.add(i.next());
            changed = changed || added;
        }
        return changed;
    }

    public void clear() {
        ++this.modCount;
        this.map.clear();
        this.size = 0;
    }

    public boolean remove(Object object) {
        MutableInteger mut = (MutableInteger)this.map.get(object);
        if (mut == null) {
            return false;
        }
        ++this.modCount;
        this.map.remove(object);
        this.size -= mut.value;
        return true;
    }

    public boolean remove(Object object, int nCopies) {
        MutableInteger mut = (MutableInteger)this.map.get(object);
        if (mut == null) {
            return false;
        }
        if (nCopies <= 0) {
            return false;
        }
        ++this.modCount;
        if (nCopies < mut.value) {
            mut.value -= nCopies;
            this.size -= nCopies;
        } else {
            this.map.remove(object);
            this.size -= mut.value;
        }
        return true;
    }

    public boolean removeAll(Collection<?> coll) {
        boolean result = false;
        if (coll != null) {
            Iterator<?> i = coll.iterator();
            while (i.hasNext()) {
                boolean changed = this.remove(i.next(), 1);
                result = result || changed;
            }
        }
        return result;
    }

    public boolean retainAll(Collection<?> coll) {
        if (coll instanceof Bag) {
            return this.retainAll((Bag)coll);
        }
        return this.retainAll((Bag)new HashBag(coll));
    }

    boolean retainAll(Bag<?> other) {
        boolean result = false;
        HashBag excess = new HashBag();
        for (Object current : this.uniqueSet()) {
            int myCount = this.getCount(current);
            int otherCount = other.getCount(current);
            if (1 <= otherCount && otherCount <= myCount) {
                excess.add(current, myCount - otherCount);
                continue;
            }
            excess.add(current, myCount);
        }
        if (!excess.isEmpty()) {
            result = this.removeAll((Collection)excess);
        }
        return result;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (Object current : this.map.keySet()) {
            for (int index = this.getCount(current); index > 0; --index) {
                result[i++] = current;
            }
        }
        return result;
    }

    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            Object[] unchecked = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            array = unchecked;
        }
        int i = 0;
        for (Object current : this.map.keySet()) {
            for (int index = this.getCount(current); index > 0; --index) {
                Object unchecked = current;
                array[i++] = unchecked;
            }
        }
        while (i < array.length) {
            array[i++] = null;
        }
        return array;
    }

    public Set<E> uniqueSet() {
        if (this.uniqueSet == null) {
            this.uniqueSet = UnmodifiableSet.unmodifiableSet(this.map.keySet());
        }
        return this.uniqueSet;
    }

    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry entry : this.map.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeInt(((MutableInteger)entry.getValue()).value);
        }
    }

    protected void doReadObject(Map<E, MutableInteger> map, ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.map = map;
        int entrySize = in.readInt();
        for (int i = 0; i < entrySize; ++i) {
            Object obj = in.readObject();
            int count = in.readInt();
            map.put(obj, new MutableInteger(count));
            this.size += count;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Bag)) {
            return false;
        }
        Bag other = (Bag)object;
        if (other.size() != this.size()) {
            return false;
        }
        for (Object element : this.map.keySet()) {
            if (other.getCount(element) == this.getCount(element)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int total = 0;
        for (Map.Entry entry : this.map.entrySet()) {
            Object element = entry.getKey();
            MutableInteger count = (MutableInteger)entry.getValue();
            total += (element == null ? 0 : element.hashCode()) ^ count.value;
        }
        return total;
    }

    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Iterator it = this.uniqueSet().iterator();
        while (it.hasNext()) {
            Object current = it.next();
            int count = this.getCount(current);
            buf.append(count);
            buf.append(':');
            buf.append(current);
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Map access$000(AbstractMapBag x0) {
        return x0.map;
    }

    static /* synthetic */ int access$100(AbstractMapBag x0) {
        return x0.modCount;
    }

    static /* synthetic */ int access$210(AbstractMapBag x0) {
        return x0.size--;
    }
}

