/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.bidimap.AbstractDualBidiMap;

public abstract class AbstractDualBidiMap<K, V>
implements BidiMap<K, V> {
    transient Map<K, V> normalMap;
    transient Map<V, K> reverseMap;
    transient BidiMap<V, K> inverseBidiMap = null;
    transient Set<K> keySet = null;
    transient Set<V> values = null;
    transient Set<Map.Entry<K, V>> entrySet = null;

    protected AbstractDualBidiMap() {
    }

    protected AbstractDualBidiMap(Map<K, V> normalMap, Map<V, K> reverseMap) {
        this.normalMap = normalMap;
        this.reverseMap = reverseMap;
    }

    protected AbstractDualBidiMap(Map<K, V> normalMap, Map<V, K> reverseMap, BidiMap<V, K> inverseBidiMap) {
        this.normalMap = normalMap;
        this.reverseMap = reverseMap;
        this.inverseBidiMap = inverseBidiMap;
    }

    protected abstract BidiMap<V, K> createBidiMap(Map<V, K> var1, Map<K, V> var2, BidiMap<K, V> var3);

    public V get(Object key) {
        return this.normalMap.get(key);
    }

    public int size() {
        return this.normalMap.size();
    }

    public boolean isEmpty() {
        return this.normalMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.normalMap.containsKey(key);
    }

    public boolean equals(Object obj) {
        return this.normalMap.equals(obj);
    }

    public int hashCode() {
        return this.normalMap.hashCode();
    }

    public String toString() {
        return this.normalMap.toString();
    }

    public V put(K key, V value) {
        if (this.normalMap.containsKey(key)) {
            this.reverseMap.remove(this.normalMap.get(key));
        }
        if (this.reverseMap.containsKey(value)) {
            this.normalMap.remove(this.reverseMap.get(value));
        }
        V obj = this.normalMap.put(key, value);
        this.reverseMap.put(value, key);
        return obj;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V remove(Object key) {
        V value = null;
        if (this.normalMap.containsKey(key)) {
            value = this.normalMap.remove(key);
            this.reverseMap.remove(value);
        }
        return value;
    }

    public void clear() {
        this.normalMap.clear();
        this.reverseMap.clear();
    }

    public boolean containsValue(Object value) {
        return this.reverseMap.containsKey(value);
    }

    public MapIterator<K, V> mapIterator() {
        return new BidiMapIterator(this);
    }

    public K getKey(Object value) {
        return (K)this.reverseMap.get(value);
    }

    public K removeValue(Object value) {
        K key = null;
        if (this.reverseMap.containsKey(value)) {
            key = (K)this.reverseMap.remove(value);
            this.normalMap.remove(key);
        }
        return key;
    }

    public BidiMap<V, K> inverseBidiMap() {
        if (this.inverseBidiMap == null) {
            this.inverseBidiMap = this.createBidiMap(this.reverseMap, this.normalMap, (BidiMap)this);
        }
        return this.inverseBidiMap;
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    protected Iterator<K> createKeySetIterator(Iterator<K> iterator) {
        return new KeySetIterator(iterator, this);
    }

    public Set<V> values() {
        if (this.values == null) {
            this.values = new Values(this);
        }
        return this.values;
    }

    protected Iterator<V> createValuesIterator(Iterator<V> iterator) {
        return new ValuesIterator(iterator, this);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    protected Iterator<Map.Entry<K, V>> createEntrySetIterator(Iterator<Map.Entry<K, V>> iterator) {
        return new EntrySetIterator(iterator, this);
    }
}

