/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.OrderedBidiMap;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.SortedBidiMap;
import org.apache.commons.collections4.bidimap.AbstractDualBidiMap;
import org.apache.commons.collections4.bidimap.DualTreeBidiMap;

public class DualTreeBidiMap<K, V>
extends AbstractDualBidiMap<K, V>
implements SortedBidiMap<K, V>,
Serializable {
    private static final long serialVersionUID = 721969328361809L;
    private final Comparator<? super K> comparator;
    private final Comparator<? super V> valueComparator;

    public DualTreeBidiMap() {
        super(new TreeMap(), new TreeMap());
        this.comparator = null;
        this.valueComparator = null;
    }

    public DualTreeBidiMap(Map<? extends K, ? extends V> map) {
        super(new TreeMap(), new TreeMap());
        this.putAll(map);
        this.comparator = null;
        this.valueComparator = null;
    }

    public DualTreeBidiMap(Comparator<? super K> keyComparator, Comparator<? super V> valueComparator) {
        super(new TreeMap(keyComparator), new TreeMap(valueComparator));
        this.comparator = keyComparator;
        this.valueComparator = valueComparator;
    }

    protected DualTreeBidiMap(Map<K, V> normalMap, Map<V, K> reverseMap, BidiMap<V, K> inverseBidiMap) {
        super(normalMap, reverseMap, inverseBidiMap);
        this.comparator = ((SortedMap)normalMap).comparator();
        this.valueComparator = ((SortedMap)reverseMap).comparator();
    }

    protected DualTreeBidiMap<V, K> createBidiMap(Map<V, K> normalMap, Map<K, V> reverseMap, BidiMap<K, V> inverseMap) {
        return new DualTreeBidiMap(normalMap, reverseMap, inverseMap);
    }

    public Comparator<? super K> comparator() {
        return ((SortedMap)this.normalMap).comparator();
    }

    public Comparator<? super V> valueComparator() {
        return ((SortedMap)this.reverseMap).comparator();
    }

    public K firstKey() {
        return ((SortedMap)this.normalMap).firstKey();
    }

    public K lastKey() {
        return ((SortedMap)this.normalMap).lastKey();
    }

    public K nextKey(K key) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.normalMap instanceof OrderedMap) {
            return (K)((OrderedMap)this.normalMap).nextKey(key);
        }
        SortedMap sm = (SortedMap)this.normalMap;
        Iterator<K> it = sm.tailMap(key).keySet().iterator();
        it.next();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public K previousKey(K key) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.normalMap instanceof OrderedMap) {
            return (K)((OrderedMap)this.normalMap).previousKey(key);
        }
        SortedMap sm = (SortedMap)this.normalMap;
        SortedMap hm = sm.headMap(key);
        if (hm.isEmpty()) {
            return null;
        }
        return hm.lastKey();
    }

    public OrderedMapIterator<K, V> mapIterator() {
        return new BidiOrderedMapIterator((AbstractDualBidiMap)this);
    }

    public SortedBidiMap<V, K> inverseSortedBidiMap() {
        return this.inverseBidiMap();
    }

    public OrderedBidiMap<V, K> inverseOrderedBidiMap() {
        return this.inverseBidiMap();
    }

    public SortedMap<K, V> headMap(K toKey) {
        SortedMap sub = ((SortedMap)this.normalMap).headMap(toKey);
        return new ViewMap(this, sub);
    }

    public SortedMap<K, V> tailMap(K fromKey) {
        SortedMap sub = ((SortedMap)this.normalMap).tailMap(fromKey);
        return new ViewMap(this, sub);
    }

    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        SortedMap sub = ((SortedMap)this.normalMap).subMap(fromKey, toKey);
        return new ViewMap(this, sub);
    }

    public SortedBidiMap<V, K> inverseBidiMap() {
        return (SortedBidiMap)super.inverseBidiMap();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.normalMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.normalMap = new TreeMap(this.comparator);
        this.reverseMap = new TreeMap(this.valueComparator);
        Map map = (Map)in.readObject();
        this.putAll(map);
    }
}

