/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.OrderedBidiMap;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.commons.collections4.iterators.EmptyOrderedMapIterator;

/*
 * Exception performing whole class analysis ignored.
 */
public class TreeBidiMap<K extends Comparable<K>, V extends Comparable<V>>
implements OrderedBidiMap<K, V>,
Serializable {
    private static final long serialVersionUID = 721969328361807L;
    private transient Node<K, V>[] rootNode = new Node[2];
    private transient int nodeCount = 0;
    private transient int modifications = 0;
    private transient Set<K> keySet;
    private transient Set<V> valuesSet;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient Inverse inverse = null;

    public TreeBidiMap() {
    }

    public TreeBidiMap(Map<? extends K, ? extends V> map) {
        this();
        this.putAll(map);
    }

    public int size() {
        return this.nodeCount;
    }

    public boolean isEmpty() {
        return this.nodeCount == 0;
    }

    public boolean containsKey(Object key) {
        TreeBidiMap.checkKey((Object)key);
        return this.lookupKey(key) != null;
    }

    public boolean containsValue(Object value) {
        TreeBidiMap.checkValue((Object)value);
        return this.lookupValue(value) != null;
    }

    public V get(Object key) {
        TreeBidiMap.checkKey((Object)key);
        Node node = this.lookupKey(key);
        return (V)(node == null ? null : node.getValue());
    }

    public V put(K key, V value) {
        Comparable result = this.get(key);
        this.doPut(key, value);
        return (V)result;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put((Comparable)e.getKey(), (Comparable)e.getValue());
        }
    }

    public V remove(Object key) {
        return (V)this.doRemoveKey(key);
    }

    public void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[DataElement.KEY.ordinal()] = null;
        this.rootNode[DataElement.VALUE.ordinal()] = null;
    }

    public K getKey(Object value) {
        TreeBidiMap.checkValue((Object)value);
        Node node = this.lookupValue(value);
        return (K)(node == null ? null : node.getKey());
    }

    public K removeValue(Object value) {
        return (K)this.doRemoveValue(value);
    }

    public K firstKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return (K)this.leastNode(this.rootNode[DataElement.KEY.ordinal()], DataElement.KEY).getKey();
    }

    public K lastKey() {
        if (this.nodeCount == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return (K)this.greatestNode(this.rootNode[DataElement.KEY.ordinal()], DataElement.KEY).getKey();
    }

    public K nextKey(K key) {
        TreeBidiMap.checkKey(key);
        Node node = this.nextGreater(this.lookupKey(key), DataElement.KEY);
        return (K)(node == null ? null : node.getKey());
    }

    public K previousKey(K key) {
        TreeBidiMap.checkKey(key);
        Node node = this.nextSmaller(this.lookupKey(key), DataElement.KEY);
        return (K)(node == null ? null : node.getKey());
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeyView(this, DataElement.KEY);
        }
        return this.keySet;
    }

    public Set<V> values() {
        if (this.valuesSet == null) {
            this.valuesSet = new ValueView(this, DataElement.KEY);
        }
        return this.valuesSet;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntryView(this);
        }
        return this.entrySet;
    }

    public OrderedMapIterator<K, V> mapIterator() {
        if (this.isEmpty()) {
            return EmptyOrderedMapIterator.emptyOrderedMapIterator();
        }
        return new ViewMapIterator(this, DataElement.KEY);
    }

    public OrderedBidiMap<V, K> inverseBidiMap() {
        if (this.inverse == null) {
            this.inverse = new Inverse(this);
        }
        return this.inverse;
    }

    public boolean equals(Object obj) {
        return this.doEquals(obj, DataElement.KEY);
    }

    public int hashCode() {
        return this.doHashCode(DataElement.KEY);
    }

    public String toString() {
        return this.doToString(DataElement.KEY);
    }

    private void doPut(K key, V value) {
        block6: {
            TreeBidiMap.checkKeyAndValue(key, value);
            this.doRemoveKey(key);
            this.doRemoveValue(value);
            Node node = this.rootNode[DataElement.KEY.ordinal()];
            if (node == null) {
                Node root;
                this.rootNode[DataElement.KEY.ordinal()] = root = new Node(key, value);
                this.rootNode[DataElement.VALUE.ordinal()] = root;
                this.grow();
            } else {
                while (true) {
                    int cmp;
                    if ((cmp = TreeBidiMap.compare(key, (Comparable)node.getKey())) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + key + "\") in this Map");
                    }
                    if (cmp < 0) {
                        if (Node.access$000((Node)node, (DataElement)DataElement.KEY) != null) {
                            node = Node.access$000((Node)node, (DataElement)DataElement.KEY);
                            continue;
                        }
                        Node newNode = new Node(key, value);
                        this.insertValue(newNode);
                        Node.access$100((Node)node, (Node)newNode, (DataElement)DataElement.KEY);
                        Node.access$200((Node)newNode, (Node)node, (DataElement)DataElement.KEY);
                        this.doRedBlackInsert(newNode, DataElement.KEY);
                        this.grow();
                        break block6;
                    }
                    if (Node.access$300((Node)node, (DataElement)DataElement.KEY) == null) break;
                    node = Node.access$300((Node)node, (DataElement)DataElement.KEY);
                }
                Node newNode = new Node(key, value);
                this.insertValue(newNode);
                Node.access$400((Node)node, (Node)newNode, (DataElement)DataElement.KEY);
                Node.access$200((Node)newNode, (Node)node, (DataElement)DataElement.KEY);
                this.doRedBlackInsert(newNode, DataElement.KEY);
                this.grow();
            }
        }
    }

    private V doRemoveKey(Object key) {
        Node node = this.lookupKey(key);
        if (node == null) {
            return null;
        }
        this.doRedBlackDelete(node);
        return (V)node.getValue();
    }

    private K doRemoveValue(Object value) {
        Node node = this.lookupValue(value);
        if (node == null) {
            return null;
        }
        this.doRedBlackDelete(node);
        return (K)node.getKey();
    }

    private <T extends Comparable<T>> Node<K, V> lookup(Object data, DataElement dataElement) {
        Node rval = null;
        Node node = this.rootNode[dataElement.ordinal()];
        while (node != null) {
            int cmp = TreeBidiMap.compare((Comparable)((Comparable)data), (Comparable)((Comparable)Node.access$500((Node)node, (DataElement)dataElement)));
            if (cmp == 0) {
                rval = node;
                break;
            }
            node = cmp < 0 ? Node.access$000((Node)node, (DataElement)dataElement) : Node.access$300((Node)node, (DataElement)dataElement);
        }
        return rval;
    }

    private Node<K, V> lookupKey(Object key) {
        return this.lookup(key, DataElement.KEY);
    }

    private Node<K, V> lookupValue(Object value) {
        return this.lookup(value, DataElement.VALUE);
    }

    private Node<K, V> nextGreater(Node<K, V> node, DataElement dataElement) {
        Node rval;
        if (node == null) {
            rval = null;
        } else if (Node.access$300(node, (DataElement)dataElement) != null) {
            rval = this.leastNode(Node.access$300(node, (DataElement)dataElement), dataElement);
        } else {
            Node parent = Node.access$600(node, (DataElement)dataElement);
            Node child = node;
            while (parent != null && child == Node.access$300((Node)parent, (DataElement)dataElement)) {
                child = parent;
                parent = Node.access$600((Node)parent, (DataElement)dataElement);
            }
            rval = parent;
        }
        return rval;
    }

    private Node<K, V> nextSmaller(Node<K, V> node, DataElement dataElement) {
        Node rval;
        if (node == null) {
            rval = null;
        } else if (Node.access$000(node, (DataElement)dataElement) != null) {
            rval = this.greatestNode(Node.access$000(node, (DataElement)dataElement), dataElement);
        } else {
            Node parent = Node.access$600(node, (DataElement)dataElement);
            Node child = node;
            while (parent != null && child == Node.access$000((Node)parent, (DataElement)dataElement)) {
                child = parent;
                parent = Node.access$600((Node)parent, (DataElement)dataElement);
            }
            rval = parent;
        }
        return rval;
    }

    private static <T extends Comparable<T>> int compare(T o1, T o2) {
        return o1.compareTo(o2);
    }

    private Node<K, V> leastNode(Node<K, V> node, DataElement dataElement) {
        Node rval = node;
        if (rval != null) {
            while (Node.access$000(rval, (DataElement)dataElement) != null) {
                rval = Node.access$000(rval, (DataElement)dataElement);
            }
        }
        return rval;
    }

    private Node<K, V> greatestNode(Node<K, V> node, DataElement dataElement) {
        Node rval = node;
        if (rval != null) {
            while (Node.access$300(rval, (DataElement)dataElement) != null) {
                rval = Node.access$300(rval, (DataElement)dataElement);
            }
        }
        return rval;
    }

    private void copyColor(Node<K, V> from, Node<K, V> to, DataElement dataElement) {
        if (to != null) {
            if (from == null) {
                Node.access$700(to, (DataElement)dataElement);
            } else {
                Node.access$800(to, from, (DataElement)dataElement);
            }
        }
    }

    private static boolean isRed(Node<?, ?> node, DataElement dataElement) {
        return node != null && Node.access$900(node, (DataElement)dataElement);
    }

    private static boolean isBlack(Node<?, ?> node, DataElement dataElement) {
        return node == null || Node.access$1000(node, (DataElement)dataElement);
    }

    private static void makeRed(Node<?, ?> node, DataElement dataElement) {
        if (node != null) {
            Node.access$1100(node, (DataElement)dataElement);
        }
    }

    private static void makeBlack(Node<?, ?> node, DataElement dataElement) {
        if (node != null) {
            Node.access$700(node, (DataElement)dataElement);
        }
    }

    private Node<K, V> getGrandParent(Node<K, V> node, DataElement dataElement) {
        return this.getParent(this.getParent(node, dataElement), dataElement);
    }

    private Node<K, V> getParent(Node<K, V> node, DataElement dataElement) {
        return node == null ? null : Node.access$600(node, (DataElement)dataElement);
    }

    private Node<K, V> getRightChild(Node<K, V> node, DataElement dataElement) {
        return node == null ? null : Node.access$300(node, (DataElement)dataElement);
    }

    private Node<K, V> getLeftChild(Node<K, V> node, DataElement dataElement) {
        return node == null ? null : Node.access$000(node, (DataElement)dataElement);
    }

    private void rotateLeft(Node<K, V> node, DataElement dataElement) {
        Node rightChild = Node.access$300(node, (DataElement)dataElement);
        Node.access$400(node, (Node)Node.access$000((Node)rightChild, (DataElement)dataElement), (DataElement)dataElement);
        if (Node.access$000((Node)rightChild, (DataElement)dataElement) != null) {
            Node.access$200((Node)Node.access$000((Node)rightChild, (DataElement)dataElement), node, (DataElement)dataElement);
        }
        Node.access$200((Node)rightChild, (Node)Node.access$600(node, (DataElement)dataElement), (DataElement)dataElement);
        if (Node.access$600(node, (DataElement)dataElement) == null) {
            this.rootNode[dataElement.ordinal()] = rightChild;
        } else if (Node.access$000((Node)Node.access$600(node, (DataElement)dataElement), (DataElement)dataElement) == node) {
            Node.access$100((Node)Node.access$600(node, (DataElement)dataElement), (Node)rightChild, (DataElement)dataElement);
        } else {
            Node.access$400((Node)Node.access$600(node, (DataElement)dataElement), (Node)rightChild, (DataElement)dataElement);
        }
        Node.access$100((Node)rightChild, node, (DataElement)dataElement);
        Node.access$200(node, (Node)rightChild, (DataElement)dataElement);
    }

    private void rotateRight(Node<K, V> node, DataElement dataElement) {
        Node leftChild = Node.access$000(node, (DataElement)dataElement);
        Node.access$100(node, (Node)Node.access$300((Node)leftChild, (DataElement)dataElement), (DataElement)dataElement);
        if (Node.access$300((Node)leftChild, (DataElement)dataElement) != null) {
            Node.access$200((Node)Node.access$300((Node)leftChild, (DataElement)dataElement), node, (DataElement)dataElement);
        }
        Node.access$200((Node)leftChild, (Node)Node.access$600(node, (DataElement)dataElement), (DataElement)dataElement);
        if (Node.access$600(node, (DataElement)dataElement) == null) {
            this.rootNode[dataElement.ordinal()] = leftChild;
        } else if (Node.access$300((Node)Node.access$600(node, (DataElement)dataElement), (DataElement)dataElement) == node) {
            Node.access$400((Node)Node.access$600(node, (DataElement)dataElement), (Node)leftChild, (DataElement)dataElement);
        } else {
            Node.access$100((Node)Node.access$600(node, (DataElement)dataElement), (Node)leftChild, (DataElement)dataElement);
        }
        Node.access$400((Node)leftChild, node, (DataElement)dataElement);
        Node.access$200(node, (Node)leftChild, (DataElement)dataElement);
    }

    private void doRedBlackInsert(Node<K, V> insertedNode, DataElement dataElement) {
        Node currentNode = insertedNode;
        TreeBidiMap.makeRed(currentNode, (DataElement)dataElement);
        while (currentNode != null && currentNode != this.rootNode[dataElement.ordinal()] && TreeBidiMap.isRed((Node)Node.access$600(currentNode, (DataElement)dataElement), (DataElement)dataElement)) {
            Node y;
            if (Node.access$1200(currentNode, (DataElement)dataElement)) {
                y = this.getRightChild(this.getGrandParent(currentNode, dataElement), dataElement);
                if (TreeBidiMap.isRed((Node)y, (DataElement)dataElement)) {
                    TreeBidiMap.makeBlack((Node)this.getParent(currentNode, dataElement), (DataElement)dataElement);
                    TreeBidiMap.makeBlack((Node)y, (DataElement)dataElement);
                    TreeBidiMap.makeRed((Node)this.getGrandParent(currentNode, dataElement), (DataElement)dataElement);
                    currentNode = this.getGrandParent(currentNode, dataElement);
                    continue;
                }
                if (Node.access$1300(currentNode, (DataElement)dataElement)) {
                    currentNode = this.getParent(currentNode, dataElement);
                    this.rotateLeft(currentNode, dataElement);
                }
                TreeBidiMap.makeBlack((Node)this.getParent(currentNode, dataElement), (DataElement)dataElement);
                TreeBidiMap.makeRed((Node)this.getGrandParent(currentNode, dataElement), (DataElement)dataElement);
                if (this.getGrandParent(currentNode, dataElement) == null) continue;
                this.rotateRight(this.getGrandParent(currentNode, dataElement), dataElement);
                continue;
            }
            y = this.getLeftChild(this.getGrandParent(currentNode, dataElement), dataElement);
            if (TreeBidiMap.isRed((Node)y, (DataElement)dataElement)) {
                TreeBidiMap.makeBlack((Node)this.getParent(currentNode, dataElement), (DataElement)dataElement);
                TreeBidiMap.makeBlack((Node)y, (DataElement)dataElement);
                TreeBidiMap.makeRed((Node)this.getGrandParent(currentNode, dataElement), (DataElement)dataElement);
                currentNode = this.getGrandParent(currentNode, dataElement);
                continue;
            }
            if (Node.access$1200(currentNode, (DataElement)dataElement)) {
                currentNode = this.getParent(currentNode, dataElement);
                this.rotateRight(currentNode, dataElement);
            }
            TreeBidiMap.makeBlack((Node)this.getParent(currentNode, dataElement), (DataElement)dataElement);
            TreeBidiMap.makeRed((Node)this.getGrandParent(currentNode, dataElement), (DataElement)dataElement);
            if (this.getGrandParent(currentNode, dataElement) == null) continue;
            this.rotateLeft(this.getGrandParent(currentNode, dataElement), dataElement);
        }
        TreeBidiMap.makeBlack((Node)this.rootNode[dataElement.ordinal()], (DataElement)dataElement);
    }

    private void doRedBlackDelete(Node<K, V> deletedNode) {
        for (DataElement dataElement : DataElement.values()) {
            Node replacement;
            if (Node.access$000(deletedNode, (DataElement)dataElement) != null && Node.access$300(deletedNode, (DataElement)dataElement) != null) {
                this.swapPosition(this.nextGreater(deletedNode, dataElement), deletedNode, dataElement);
            }
            Node node = replacement = Node.access$000(deletedNode, (DataElement)dataElement) != null ? Node.access$000(deletedNode, (DataElement)dataElement) : Node.access$300(deletedNode, (DataElement)dataElement);
            if (replacement != null) {
                Node.access$200((Node)replacement, (Node)Node.access$600(deletedNode, (DataElement)dataElement), (DataElement)dataElement);
                if (Node.access$600(deletedNode, (DataElement)dataElement) == null) {
                    this.rootNode[dataElement.ordinal()] = replacement;
                } else if (deletedNode == Node.access$000((Node)Node.access$600(deletedNode, (DataElement)dataElement), (DataElement)dataElement)) {
                    Node.access$100((Node)Node.access$600(deletedNode, (DataElement)dataElement), (Node)replacement, (DataElement)dataElement);
                } else {
                    Node.access$400((Node)Node.access$600(deletedNode, (DataElement)dataElement), (Node)replacement, (DataElement)dataElement);
                }
                Node.access$100(deletedNode, null, (DataElement)dataElement);
                Node.access$400(deletedNode, null, (DataElement)dataElement);
                Node.access$200(deletedNode, null, (DataElement)dataElement);
                if (!TreeBidiMap.isBlack(deletedNode, (DataElement)dataElement)) continue;
                this.doRedBlackDeleteFixup(replacement, dataElement);
                continue;
            }
            if (Node.access$600(deletedNode, (DataElement)dataElement) == null) {
                this.rootNode[dataElement.ordinal()] = null;
                continue;
            }
            if (TreeBidiMap.isBlack(deletedNode, (DataElement)dataElement)) {
                this.doRedBlackDeleteFixup(deletedNode, dataElement);
            }
            if (Node.access$600(deletedNode, (DataElement)dataElement) == null) continue;
            if (deletedNode == Node.access$000((Node)Node.access$600(deletedNode, (DataElement)dataElement), (DataElement)dataElement)) {
                Node.access$100((Node)Node.access$600(deletedNode, (DataElement)dataElement), null, (DataElement)dataElement);
            } else {
                Node.access$400((Node)Node.access$600(deletedNode, (DataElement)dataElement), null, (DataElement)dataElement);
            }
            Node.access$200(deletedNode, null, (DataElement)dataElement);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node<K, V> replacementNode, DataElement dataElement) {
        Node currentNode = replacementNode;
        while (currentNode != this.rootNode[dataElement.ordinal()] && TreeBidiMap.isBlack(currentNode, (DataElement)dataElement)) {
            Node siblingNode;
            if (Node.access$1200(currentNode, (DataElement)dataElement)) {
                siblingNode = this.getRightChild(this.getParent(currentNode, dataElement), dataElement);
                if (TreeBidiMap.isRed((Node)siblingNode, (DataElement)dataElement)) {
                    TreeBidiMap.makeBlack((Node)siblingNode, (DataElement)dataElement);
                    TreeBidiMap.makeRed((Node)this.getParent(currentNode, dataElement), (DataElement)dataElement);
                    this.rotateLeft(this.getParent(currentNode, dataElement), dataElement);
                    siblingNode = this.getRightChild(this.getParent(currentNode, dataElement), dataElement);
                }
                if (TreeBidiMap.isBlack((Node)this.getLeftChild(siblingNode, dataElement), (DataElement)dataElement) && TreeBidiMap.isBlack((Node)this.getRightChild(siblingNode, dataElement), (DataElement)dataElement)) {
                    TreeBidiMap.makeRed((Node)siblingNode, (DataElement)dataElement);
                    currentNode = this.getParent(currentNode, dataElement);
                    continue;
                }
                if (TreeBidiMap.isBlack((Node)this.getRightChild(siblingNode, dataElement), (DataElement)dataElement)) {
                    TreeBidiMap.makeBlack((Node)this.getLeftChild(siblingNode, dataElement), (DataElement)dataElement);
                    TreeBidiMap.makeRed((Node)siblingNode, (DataElement)dataElement);
                    this.rotateRight(siblingNode, dataElement);
                    siblingNode = this.getRightChild(this.getParent(currentNode, dataElement), dataElement);
                }
                this.copyColor(this.getParent(currentNode, dataElement), siblingNode, dataElement);
                TreeBidiMap.makeBlack((Node)this.getParent(currentNode, dataElement), (DataElement)dataElement);
                TreeBidiMap.makeBlack((Node)this.getRightChild(siblingNode, dataElement), (DataElement)dataElement);
                this.rotateLeft(this.getParent(currentNode, dataElement), dataElement);
                currentNode = this.rootNode[dataElement.ordinal()];
                continue;
            }
            siblingNode = this.getLeftChild(this.getParent(currentNode, dataElement), dataElement);
            if (TreeBidiMap.isRed((Node)siblingNode, (DataElement)dataElement)) {
                TreeBidiMap.makeBlack((Node)siblingNode, (DataElement)dataElement);
                TreeBidiMap.makeRed((Node)this.getParent(currentNode, dataElement), (DataElement)dataElement);
                this.rotateRight(this.getParent(currentNode, dataElement), dataElement);
                siblingNode = this.getLeftChild(this.getParent(currentNode, dataElement), dataElement);
            }
            if (TreeBidiMap.isBlack((Node)this.getRightChild(siblingNode, dataElement), (DataElement)dataElement) && TreeBidiMap.isBlack((Node)this.getLeftChild(siblingNode, dataElement), (DataElement)dataElement)) {
                TreeBidiMap.makeRed((Node)siblingNode, (DataElement)dataElement);
                currentNode = this.getParent(currentNode, dataElement);
                continue;
            }
            if (TreeBidiMap.isBlack((Node)this.getLeftChild(siblingNode, dataElement), (DataElement)dataElement)) {
                TreeBidiMap.makeBlack((Node)this.getRightChild(siblingNode, dataElement), (DataElement)dataElement);
                TreeBidiMap.makeRed((Node)siblingNode, (DataElement)dataElement);
                this.rotateLeft(siblingNode, dataElement);
                siblingNode = this.getLeftChild(this.getParent(currentNode, dataElement), dataElement);
            }
            this.copyColor(this.getParent(currentNode, dataElement), siblingNode, dataElement);
            TreeBidiMap.makeBlack((Node)this.getParent(currentNode, dataElement), (DataElement)dataElement);
            TreeBidiMap.makeBlack((Node)this.getLeftChild(siblingNode, dataElement), (DataElement)dataElement);
            this.rotateRight(this.getParent(currentNode, dataElement), dataElement);
            currentNode = this.rootNode[dataElement.ordinal()];
        }
        TreeBidiMap.makeBlack(currentNode, (DataElement)dataElement);
    }

    private void swapPosition(Node<K, V> x, Node<K, V> y, DataElement dataElement) {
        boolean yWasLeftChild;
        Node xFormerParent = Node.access$600(x, (DataElement)dataElement);
        Node xFormerLeftChild = Node.access$000(x, (DataElement)dataElement);
        Node xFormerRightChild = Node.access$300(x, (DataElement)dataElement);
        Node yFormerParent = Node.access$600(y, (DataElement)dataElement);
        Node yFormerLeftChild = Node.access$000(y, (DataElement)dataElement);
        Node yFormerRightChild = Node.access$300(y, (DataElement)dataElement);
        boolean xWasLeftChild = Node.access$600(x, (DataElement)dataElement) != null && x == Node.access$000((Node)Node.access$600(x, (DataElement)dataElement), (DataElement)dataElement);
        boolean bl = yWasLeftChild = Node.access$600(y, (DataElement)dataElement) != null && y == Node.access$000((Node)Node.access$600(y, (DataElement)dataElement), (DataElement)dataElement);
        if (x == yFormerParent) {
            Node.access$200(x, y, (DataElement)dataElement);
            if (yWasLeftChild) {
                Node.access$100(y, x, (DataElement)dataElement);
                Node.access$400(y, (Node)xFormerRightChild, (DataElement)dataElement);
            } else {
                Node.access$400(y, x, (DataElement)dataElement);
                Node.access$100(y, (Node)xFormerLeftChild, (DataElement)dataElement);
            }
        } else {
            Node.access$200(x, (Node)yFormerParent, (DataElement)dataElement);
            if (yFormerParent != null) {
                if (yWasLeftChild) {
                    Node.access$100((Node)yFormerParent, x, (DataElement)dataElement);
                } else {
                    Node.access$400((Node)yFormerParent, x, (DataElement)dataElement);
                }
            }
            Node.access$100(y, (Node)xFormerLeftChild, (DataElement)dataElement);
            Node.access$400(y, (Node)xFormerRightChild, (DataElement)dataElement);
        }
        if (y == xFormerParent) {
            Node.access$200(y, x, (DataElement)dataElement);
            if (xWasLeftChild) {
                Node.access$100(x, y, (DataElement)dataElement);
                Node.access$400(x, (Node)yFormerRightChild, (DataElement)dataElement);
            } else {
                Node.access$400(x, y, (DataElement)dataElement);
                Node.access$100(x, (Node)yFormerLeftChild, (DataElement)dataElement);
            }
        } else {
            Node.access$200(y, (Node)xFormerParent, (DataElement)dataElement);
            if (xFormerParent != null) {
                if (xWasLeftChild) {
                    Node.access$100((Node)xFormerParent, y, (DataElement)dataElement);
                } else {
                    Node.access$400((Node)xFormerParent, y, (DataElement)dataElement);
                }
            }
            Node.access$100(x, (Node)yFormerLeftChild, (DataElement)dataElement);
            Node.access$400(x, (Node)yFormerRightChild, (DataElement)dataElement);
        }
        if (Node.access$000(x, (DataElement)dataElement) != null) {
            Node.access$200((Node)Node.access$000(x, (DataElement)dataElement), x, (DataElement)dataElement);
        }
        if (Node.access$300(x, (DataElement)dataElement) != null) {
            Node.access$200((Node)Node.access$300(x, (DataElement)dataElement), x, (DataElement)dataElement);
        }
        if (Node.access$000(y, (DataElement)dataElement) != null) {
            Node.access$200((Node)Node.access$000(y, (DataElement)dataElement), y, (DataElement)dataElement);
        }
        if (Node.access$300(y, (DataElement)dataElement) != null) {
            Node.access$200((Node)Node.access$300(y, (DataElement)dataElement), y, (DataElement)dataElement);
        }
        Node.access$1400(x, y, (DataElement)dataElement);
        if (this.rootNode[dataElement.ordinal()] == x) {
            this.rootNode[dataElement.ordinal()] = y;
        } else if (this.rootNode[dataElement.ordinal()] == y) {
            this.rootNode[dataElement.ordinal()] = x;
        }
    }

    private static void checkNonNullComparable(Object o, DataElement dataElement) {
        if (o == null) {
            throw new NullPointerException(dataElement + " cannot be null");
        }
        if (!(o instanceof Comparable)) {
            throw new ClassCastException(dataElement + " must be Comparable");
        }
    }

    private static void checkKey(Object key) {
        TreeBidiMap.checkNonNullComparable((Object)key, (DataElement)DataElement.KEY);
    }

    private static void checkValue(Object value) {
        TreeBidiMap.checkNonNullComparable((Object)value, (DataElement)DataElement.VALUE);
    }

    private static void checkKeyAndValue(Object key, Object value) {
        TreeBidiMap.checkKey((Object)key);
        TreeBidiMap.checkValue((Object)value);
    }

    private void modify() {
        ++this.modifications;
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    private void insertValue(Node<K, V> newNode) throws IllegalArgumentException {
        block4: {
            Node node = this.rootNode[DataElement.VALUE.ordinal()];
            while (true) {
                int cmp;
                if ((cmp = TreeBidiMap.compare((Comparable)newNode.getValue(), (Comparable)node.getValue())) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + Node.access$500(newNode, (DataElement)DataElement.VALUE) + "\") in this Map");
                }
                if (cmp < 0) {
                    if (Node.access$000((Node)node, (DataElement)DataElement.VALUE) != null) {
                        node = Node.access$000((Node)node, (DataElement)DataElement.VALUE);
                        continue;
                    }
                    Node.access$100((Node)node, newNode, (DataElement)DataElement.VALUE);
                    Node.access$200(newNode, (Node)node, (DataElement)DataElement.VALUE);
                    this.doRedBlackInsert(newNode, DataElement.VALUE);
                    break block4;
                }
                if (Node.access$300((Node)node, (DataElement)DataElement.VALUE) == null) break;
                node = Node.access$300((Node)node, (DataElement)DataElement.VALUE);
            }
            Node.access$400((Node)node, newNode, (DataElement)DataElement.VALUE);
            Node.access$200(newNode, (Node)node, (DataElement)DataElement.VALUE);
            this.doRedBlackInsert(newNode, DataElement.VALUE);
        }
    }

    private boolean doEquals(Object obj, DataElement dataElement) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (other.size() != this.size()) {
            return false;
        }
        if (this.nodeCount > 0) {
            try {
                MapIterator it = this.getMapIterator(dataElement);
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = it.getValue();
                    if (value.equals(other.get(key))) continue;
                    return false;
                }
            }
            catch (ClassCastException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    private int doHashCode(DataElement dataElement) {
        int total = 0;
        if (this.nodeCount > 0) {
            MapIterator it = this.getMapIterator(dataElement);
            while (it.hasNext()) {
                Object key = it.next();
                Object value = it.getValue();
                total += key.hashCode() ^ value.hashCode();
            }
        }
        return total;
    }

    private String doToString(DataElement dataElement) {
        if (this.nodeCount == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder(this.nodeCount * 32);
        buf.append('{');
        MapIterator it = this.getMapIterator(dataElement);
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Object key = it.next();
            Object value = it.getValue();
            buf.append(key == this ? "(this Map)" : key).append('=').append(value == this ? "(this Map)" : value);
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    private MapIterator<?, ?> getMapIterator(DataElement dataElement) {
        switch (1.$SwitchMap$org$apache$commons$collections4$bidimap$TreeBidiMap$DataElement[dataElement.ordinal()]) {
            case 1: {
                return new ViewMapIterator(this, DataElement.KEY);
            }
            case 2: {
                return new InverseViewMapIterator(this, DataElement.VALUE);
            }
        }
        throw new IllegalArgumentException();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.rootNode = new Node[2];
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            Comparable k = (Comparable)stream.readObject();
            Comparable v = (Comparable)stream.readObject();
            this.put(k, v);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    static /* synthetic */ void access$1500(Object x0, DataElement x1) {
        TreeBidiMap.checkNonNullComparable((Object)x0, (DataElement)x1);
    }

    static /* synthetic */ Node access$1600(TreeBidiMap x0, Object x1) {
        return x0.lookupKey(x1);
    }

    static /* synthetic */ Comparable access$1700(TreeBidiMap x0, Object x1) {
        return x0.doRemoveKey(x1);
    }

    static /* synthetic */ Node access$1800(TreeBidiMap x0, Object x1) {
        return x0.lookupValue(x1);
    }

    static /* synthetic */ Comparable access$1900(TreeBidiMap x0, Object x1) {
        return x0.doRemoveValue(x1);
    }

    static /* synthetic */ void access$2000(TreeBidiMap x0, Node x1) {
        x0.doRedBlackDelete(x1);
    }

    static /* synthetic */ int access$2100(TreeBidiMap x0) {
        return x0.modifications;
    }

    static /* synthetic */ Node[] access$2200(TreeBidiMap x0) {
        return x0.rootNode;
    }

    static /* synthetic */ Node access$2300(TreeBidiMap x0, Node x1, DataElement x2) {
        return x0.leastNode(x1, x2);
    }

    static /* synthetic */ Node access$2400(TreeBidiMap x0, Node x1, DataElement x2) {
        return x0.nextGreater(x1, x2);
    }

    static /* synthetic */ Node access$2500(TreeBidiMap x0, Node x1, DataElement x2) {
        return x0.nextSmaller(x1, x2);
    }

    static /* synthetic */ Node access$2600(TreeBidiMap x0, Node x1, DataElement x2) {
        return x0.greatestNode(x1, x2);
    }

    static /* synthetic */ int access$2700(TreeBidiMap x0) {
        return x0.nodeCount;
    }

    static /* synthetic */ void access$2800(Object x0) {
        TreeBidiMap.checkKey((Object)x0);
    }

    static /* synthetic */ Node access$2900(TreeBidiMap x0, Object x1, DataElement x2) {
        return x0.lookup(x1, x2);
    }

    static /* synthetic */ void access$3000(TreeBidiMap x0, Comparable x1, Comparable x2) {
        x0.doPut(x1, x2);
    }

    static /* synthetic */ boolean access$3100(TreeBidiMap x0, Object x1, DataElement x2) {
        return x0.doEquals(x1, x2);
    }

    static /* synthetic */ int access$3200(TreeBidiMap x0, DataElement x1) {
        return x0.doHashCode(x1);
    }

    static /* synthetic */ String access$3300(TreeBidiMap x0, DataElement x1) {
        return x0.doToString(x1);
    }
}

