/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.ResettableListIterator;
import org.apache.commons.collections4.iterators.ObjectArrayIterator;

public class ObjectArrayListIterator<E>
extends ObjectArrayIterator<E>
implements ResettableListIterator<E> {
    private int lastItemIndex = -1;

    public ObjectArrayListIterator(E ... array) {
        super((Object[])array);
    }

    public ObjectArrayListIterator(E[] array, int start) {
        super((Object[])array, start);
    }

    public ObjectArrayListIterator(E[] array, int start, int end) {
        super((Object[])array, start, end);
    }

    public boolean hasPrevious() {
        return this.index > this.getStartIndex();
    }

    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.lastItemIndex = --this.index;
        return (E)this.array[this.index];
    }

    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastItemIndex = this.index;
        return (E)this.array[this.index++];
    }

    public int nextIndex() {
        return this.index - this.getStartIndex();
    }

    public int previousIndex() {
        return this.index - this.getStartIndex() - 1;
    }

    public void add(E obj) {
        throw new UnsupportedOperationException("add() method is not supported");
    }

    public void set(E obj) {
        if (this.lastItemIndex == -1) {
            throw new IllegalStateException("must call next() or previous() before a call to set()");
        }
        this.array[this.lastItemIndex] = obj;
    }

    public void reset() {
        super.reset();
        this.lastItemIndex = -1;
    }
}

