/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.collections4.list.TreeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class TreeList<E>
extends AbstractList<E> {
    private AVLNode<E> root;
    private int size;

    public TreeList() {
    }

    public TreeList(Collection<? extends E> coll) {
        if (!coll.isEmpty()) {
            this.root = new AVLNode(coll, null);
            this.size = coll.size();
        }
    }

    @Override
    public E get(int index) {
        this.checkInterval(index, 0, this.size() - 1);
        return (E)this.root.get(index).getValue();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int fromIndex) {
        this.checkInterval(fromIndex, 0, this.size());
        return new TreeListIterator(this, fromIndex);
    }

    @Override
    public int indexOf(Object object) {
        if (this.root == null) {
            return -1;
        }
        return this.root.indexOf(object, AVLNode.access$100((AVLNode)this.root));
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        if (this.root != null) {
            this.root.toArray(array, AVLNode.access$100((AVLNode)this.root));
        }
        return array;
    }

    @Override
    public void add(int index, E obj) {
        ++this.modCount;
        this.checkInterval(index, 0, this.size());
        this.root = this.root == null ? new AVLNode(index, obj, null, null, null) : this.root.insert(index, obj);
        ++this.size;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        this.modCount += c.size();
        AVLNode cTree = new AVLNode(c, null);
        this.root = this.root == null ? cTree : AVLNode.access$300((AVLNode)this.root, (AVLNode)cTree, (int)this.size);
        this.size += c.size();
        return true;
    }

    @Override
    public E set(int index, E obj) {
        this.checkInterval(index, 0, this.size() - 1);
        AVLNode node = this.root.get(index);
        Object result = AVLNode.access$400((AVLNode)node);
        node.setValue(obj);
        return (E)result;
    }

    @Override
    public E remove(int index) {
        ++this.modCount;
        this.checkInterval(index, 0, this.size() - 1);
        Object result = this.get(index);
        this.root = this.root.remove(index);
        --this.size;
        return (E)result;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.root = null;
        this.size = 0;
    }

    private void checkInterval(int index, int startIndex, int endIndex) {
        if (index < startIndex || index > endIndex) {
            throw new IndexOutOfBoundsException("Invalid index:" + index + ", size=" + this.size());
        }
    }

    static /* synthetic */ int access$500(TreeList x0) {
        return x0.modCount;
    }

    static /* synthetic */ AVLNode access$600(TreeList x0) {
        return x0.root;
    }

    static /* synthetic */ int access$700(TreeList x0) {
        return x0.modCount;
    }
}

