/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.map.AbstractHashedMap;
import org.apache.commons.collections4.map.AbstractReferenceMap;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractReferenceMap<K, V>
extends AbstractHashedMap<K, V> {
    private ReferenceStrength keyType;
    private ReferenceStrength valueType;
    private boolean purgeValues;
    private transient ReferenceQueue<Object> queue;

    protected AbstractReferenceMap() {
    }

    protected AbstractReferenceMap(ReferenceStrength keyType, ReferenceStrength valueType, int capacity, float loadFactor, boolean purgeValues) {
        super(capacity, loadFactor);
        this.keyType = keyType;
        this.valueType = valueType;
        this.purgeValues = purgeValues;
    }

    protected void init() {
        this.queue = new ReferenceQueue();
    }

    public int size() {
        this.purgeBeforeRead();
        return super.size();
    }

    public boolean isEmpty() {
        this.purgeBeforeRead();
        return super.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.purgeBeforeRead();
        AbstractHashedMap.HashEntry entry = this.getEntry(key);
        if (entry == null) {
            return false;
        }
        return entry.getValue() != null;
    }

    public boolean containsValue(Object value) {
        this.purgeBeforeRead();
        if (value == null) {
            return false;
        }
        return super.containsValue(value);
    }

    public V get(Object key) {
        this.purgeBeforeRead();
        AbstractHashedMap.HashEntry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("null keys not allowed");
        }
        if (value == null) {
            throw new NullPointerException("null values not allowed");
        }
        this.purgeBeforeWrite();
        return (V)super.put(key, value);
    }

    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        this.purgeBeforeWrite();
        return (V)super.remove(key);
    }

    public void clear() {
        super.clear();
        while (this.queue.poll() != null) {
        }
    }

    public MapIterator<K, V> mapIterator() {
        return new ReferenceMapIterator(this);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ReferenceEntrySet((AbstractHashedMap)this);
        }
        return this.entrySet;
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new ReferenceKeySet((AbstractHashedMap)this);
        }
        return this.keySet;
    }

    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ReferenceValues((AbstractHashedMap)this);
        }
        return this.values;
    }

    protected void purgeBeforeRead() {
        this.purge();
    }

    protected void purgeBeforeWrite() {
        this.purge();
    }

    protected void purge() {
        Reference ref = this.queue.poll();
        while (ref != null) {
            this.purge(ref);
            ref = this.queue.poll();
        }
    }

    protected void purge(Reference<?> ref) {
        int hash = ref.hashCode();
        int index = this.hashIndex(hash, this.data.length);
        AbstractHashedMap.HashEntry previous = null;
        AbstractHashedMap.HashEntry entry = this.data[index];
        while (entry != null) {
            if (((ReferenceEntry)entry).purge(ref)) {
                if (previous == null) {
                    this.data[index] = entry.next;
                } else {
                    previous.next = entry.next;
                }
                --this.size;
                return;
            }
            previous = entry;
            entry = entry.next;
        }
    }

    protected AbstractHashedMap.HashEntry<K, V> getEntry(Object key) {
        if (key == null) {
            return null;
        }
        return super.getEntry(key);
    }

    protected int hashEntry(Object key, Object value) {
        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
    }

    protected boolean isEqualKey(Object key1, Object key2) {
        key2 = this.keyType == ReferenceStrength.HARD ? key2 : ((Reference)key2).get();
        return key1 == key2 || key1.equals(key2);
    }

    protected ReferenceEntry<K, V> createEntry(AbstractHashedMap.HashEntry<K, V> next, int hashCode, K key, V value) {
        return new ReferenceEntry(this, next, hashCode, key, value);
    }

    protected Iterator<Map.Entry<K, V>> createEntrySetIterator() {
        return new ReferenceEntrySetIterator(this);
    }

    protected Iterator<K> createKeySetIterator() {
        return new ReferenceKeySetIterator(this);
    }

    protected Iterator<V> createValuesIterator() {
        return new ReferenceValuesIterator(this);
    }

    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.keyType.value);
        out.writeInt(this.valueType.value);
        out.writeBoolean(this.purgeValues);
        out.writeFloat(this.loadFactor);
        out.writeInt(this.data.length);
        MapIterator it = this.mapIterator();
        while (it.hasNext()) {
            out.writeObject(it.next());
            out.writeObject(it.getValue());
        }
        out.writeObject(null);
    }

    protected void doReadObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object key;
        this.keyType = ReferenceStrength.resolve((int)in.readInt());
        this.valueType = ReferenceStrength.resolve((int)in.readInt());
        this.purgeValues = in.readBoolean();
        this.loadFactor = in.readFloat();
        int capacity = in.readInt();
        this.init();
        this.data = new AbstractHashedMap.HashEntry[capacity];
        while ((key = in.readObject()) != null) {
            Object value = in.readObject();
            this.put(key, value);
        }
        this.threshold = this.calculateThreshold(this.data.length, this.loadFactor);
    }

    protected boolean isKeyType(ReferenceStrength type) {
        return this.keyType == type;
    }

    static /* synthetic */ ReferenceStrength access$000(AbstractReferenceMap x0) {
        return x0.keyType;
    }

    static /* synthetic */ ReferenceStrength access$100(AbstractReferenceMap x0) {
        return x0.valueType;
    }

    static /* synthetic */ ReferenceQueue access$200(AbstractReferenceMap x0) {
        return x0.queue;
    }

    static /* synthetic */ boolean access$300(AbstractReferenceMap x0) {
        return x0.purgeValues;
    }
}

