/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import org.apache.commons.collections4.IterableSortedMap;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.map.AbstractMapDecorator;
import org.apache.commons.collections4.map.AbstractSortedMapDecorator;

public abstract class AbstractSortedMapDecorator<K, V>
extends AbstractMapDecorator<K, V>
implements IterableSortedMap<K, V> {
    protected AbstractSortedMapDecorator() {
    }

    public AbstractSortedMapDecorator(SortedMap<K, V> map) {
        super(map);
    }

    protected SortedMap<K, V> decorated() {
        return (SortedMap)super.decorated();
    }

    public Comparator<? super K> comparator() {
        return this.decorated().comparator();
    }

    public K firstKey() {
        return this.decorated().firstKey();
    }

    public K lastKey() {
        return this.decorated().lastKey();
    }

    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.decorated().subMap(fromKey, toKey);
    }

    public SortedMap<K, V> headMap(K toKey) {
        return this.decorated().headMap(toKey);
    }

    public SortedMap<K, V> tailMap(K fromKey) {
        return this.decorated().tailMap(fromKey);
    }

    public K previousKey(K key) {
        SortedMap headMap = this.headMap(key);
        return headMap.isEmpty() ? null : (K)headMap.lastKey();
    }

    public K nextKey(K key) {
        Iterator it = this.tailMap(key).keySet().iterator();
        it.next();
        return it.hasNext() ? (K)it.next() : null;
    }

    public OrderedMapIterator<K, V> mapIterator() {
        return new SortedMapIterator(this.entrySet());
    }
}

