/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.commons.collections4.map.AbstractMapDecorator;
import org.apache.commons.collections4.map.ListOrderedMap;

public class ListOrderedMap<K, V>
extends AbstractMapDecorator<K, V>
implements OrderedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 2728177751851003750L;
    private final List<K> insertOrder = new ArrayList();

    public static <K, V> ListOrderedMap<K, V> listOrderedMap(Map<K, V> map) {
        return new ListOrderedMap(map);
    }

    public ListOrderedMap() {
        this(new HashMap());
    }

    protected ListOrderedMap(Map<K, V> map) {
        super(map);
        this.insertOrder.addAll(this.decorated().keySet());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    public OrderedMapIterator<K, V> mapIterator() {
        return new ListOrderedMapIterator(this);
    }

    public K firstKey() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return (K)this.insertOrder.get(0);
    }

    public K lastKey() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Map is empty");
        }
        return (K)this.insertOrder.get(this.size() - 1);
    }

    public K nextKey(Object key) {
        int index = this.insertOrder.indexOf(key);
        if (index >= 0 && index < this.size() - 1) {
            return (K)this.insertOrder.get(index + 1);
        }
        return null;
    }

    public K previousKey(Object key) {
        int index = this.insertOrder.indexOf(key);
        if (index > 0) {
            return (K)this.insertOrder.get(index - 1);
        }
        return null;
    }

    public V put(K key, V value) {
        if (this.decorated().containsKey(key)) {
            return this.decorated().put(key, value);
        }
        V result = this.decorated().put(key, value);
        this.insertOrder.add(key);
        return result;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(int index, Map<? extends K, ? extends V> map) {
        if (index < 0 || index > this.insertOrder.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.insertOrder.size());
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            boolean contains = this.containsKey(key);
            this.put(index, entry.getKey(), entry.getValue());
            if (!contains) {
                ++index;
                continue;
            }
            index = this.indexOf(entry.getKey()) + 1;
        }
    }

    public V remove(Object key) {
        V result = null;
        if (this.decorated().containsKey(key)) {
            result = this.decorated().remove(key);
            this.insertOrder.remove(key);
        }
        return result;
    }

    public void clear() {
        this.decorated().clear();
        this.insertOrder.clear();
    }

    public Set<K> keySet() {
        return new KeySetView(this);
    }

    public List<K> keyList() {
        return UnmodifiableList.unmodifiableList((List)this.insertOrder);
    }

    public Collection<V> values() {
        return new ValuesView(this);
    }

    public List<V> valueList() {
        return new ValuesView(this);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySetView(this, this.insertOrder);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        boolean first = true;
        for (Map.Entry entry : this.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append((Object)(key == this ? "(this Map)" : key));
            buf.append('=');
            buf.append((Object)(value == this ? "(this Map)" : value));
        }
        buf.append('}');
        return buf.toString();
    }

    public K get(int index) {
        return (K)this.insertOrder.get(index);
    }

    public V getValue(int index) {
        return (V)this.get(this.insertOrder.get(index));
    }

    public int indexOf(Object key) {
        return this.insertOrder.indexOf(key);
    }

    public V setValue(int index, V value) {
        Object key = this.insertOrder.get(index);
        return (V)this.put(key, value);
    }

    public V put(int index, K key, V value) {
        if (index < 0 || index > this.insertOrder.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.insertOrder.size());
        }
        Map m = this.decorated();
        if (m.containsKey(key)) {
            Object result = m.remove(key);
            int pos = this.insertOrder.indexOf(key);
            this.insertOrder.remove(pos);
            if (pos < index) {
                --index;
            }
            this.insertOrder.add(index, key);
            m.put(key, value);
            return result;
        }
        this.insertOrder.add(index, key);
        m.put(key, value);
        return null;
    }

    public V remove(int index) {
        return (V)this.remove(this.get(index));
    }

    public List<K> asList() {
        return this.keyList();
    }

    static /* synthetic */ List access$000(ListOrderedMap x0) {
        return x0.insertOrder;
    }
}

