/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.map.AbstractMapDecorator;
import org.apache.commons.collections4.map.PassiveExpiringMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class PassiveExpiringMap<K, V>
extends AbstractMapDecorator<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Object, Long> expirationMap = new HashMap();
    private final ExpirationPolicy<K, V> expiringPolicy;

    private static long validateAndConvertToMillis(long timeToLive, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("Time unit must not be null");
        }
        return TimeUnit.MILLISECONDS.convert(timeToLive, timeUnit);
    }

    public PassiveExpiringMap() {
        this(-1L);
    }

    public PassiveExpiringMap(ExpirationPolicy<K, V> expiringPolicy) {
        this(expiringPolicy, new HashMap());
    }

    public PassiveExpiringMap(ExpirationPolicy<K, V> expiringPolicy, Map<K, V> map) {
        super(map);
        if (expiringPolicy == null) {
            throw new NullPointerException("Policy must not be null.");
        }
        this.expiringPolicy = expiringPolicy;
    }

    public PassiveExpiringMap(long timeToLiveMillis) {
        this((ExpirationPolicy)new ConstantTimeToLiveExpirationPolicy(timeToLiveMillis), new HashMap());
    }

    public PassiveExpiringMap(long timeToLiveMillis, Map<K, V> map) {
        this((ExpirationPolicy)new ConstantTimeToLiveExpirationPolicy(timeToLiveMillis), map);
    }

    public PassiveExpiringMap(long timeToLive, TimeUnit timeUnit) {
        this(PassiveExpiringMap.validateAndConvertToMillis((long)timeToLive, (TimeUnit)timeUnit));
    }

    public PassiveExpiringMap(long timeToLive, TimeUnit timeUnit, Map<K, V> map) {
        this(PassiveExpiringMap.validateAndConvertToMillis((long)timeToLive, (TimeUnit)timeUnit), map);
    }

    public PassiveExpiringMap(Map<K, V> map) {
        this(-1L, map);
    }

    public void clear() {
        super.clear();
        this.expirationMap.clear();
    }

    public boolean containsKey(Object key) {
        this.removeIfExpired(key, this.now());
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.removeAllExpired(this.now());
        return super.containsValue(value);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.removeAllExpired(this.now());
        return super.entrySet();
    }

    public V get(Object key) {
        this.removeIfExpired(key, this.now());
        return (V)super.get(key);
    }

    public boolean isEmpty() {
        this.removeAllExpired(this.now());
        return super.isEmpty();
    }

    private boolean isExpired(long now, Long expirationTimeObject) {
        if (expirationTimeObject != null) {
            long expirationTime = expirationTimeObject;
            return expirationTime >= 0L && now >= expirationTime;
        }
        return false;
    }

    public Set<K> keySet() {
        this.removeAllExpired(this.now());
        return super.keySet();
    }

    private long now() {
        return System.currentTimeMillis();
    }

    public V put(K key, V value) {
        long expirationTime = this.expiringPolicy.expirationTime(key, value);
        this.expirationMap.put(key, expirationTime);
        return (V)super.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> mapToCopy) {
        for (Map.Entry<K, V> entry : mapToCopy.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V remove(Object key) {
        this.expirationMap.remove(key);
        return (V)super.remove(key);
    }

    private void removeAllExpired(long now) {
        Iterator iter = this.expirationMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry expirationEntry = iter.next();
            if (!this.isExpired(now, (Long)expirationEntry.getValue())) continue;
            super.remove(expirationEntry.getKey());
            iter.remove();
        }
    }

    private void removeIfExpired(Object key, long now) {
        Long expirationTimeObject = (Long)this.expirationMap.get(key);
        if (this.isExpired(now, expirationTimeObject)) {
            this.remove(key);
        }
    }

    public int size() {
        this.removeAllExpired(this.now());
        return super.size();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    public Collection<V> values() {
        this.removeAllExpired(this.now());
        return super.values();
    }

    static /* synthetic */ long access$000(long x0, TimeUnit x1) {
        return PassiveExpiringMap.validateAndConvertToMillis((long)x0, (TimeUnit)x1);
    }
}

