/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.BoundedMap;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.keyvalue.TiedMapEntry;
import org.apache.commons.collections4.map.SingletonMap;

public class SingletonMap<K, V>
implements OrderedMap<K, V>,
BoundedMap<K, V>,
KeyValue<K, V>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8931271118676803261L;
    private final K key;
    private V value;

    public SingletonMap() {
        this.key = null;
    }

    public SingletonMap(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public SingletonMap(KeyValue<K, V> keyValue) {
        this.key = keyValue.getKey();
        this.value = keyValue.getValue();
    }

    public SingletonMap(Map.Entry<? extends K, ? extends V> mapEntry) {
        this.key = mapEntry.getKey();
        this.value = mapEntry.getValue();
    }

    public SingletonMap(Map<? extends K, ? extends V> map) {
        if (map.size() != 1) {
            throw new IllegalArgumentException("The map size must be 1");
        }
        Map.Entry<K, V> entry = map.entrySet().iterator().next();
        this.key = entry.getKey();
        this.value = entry.getValue();
    }

    public K getKey() {
        return (K)this.key;
    }

    public V getValue() {
        return (V)this.value;
    }

    public V setValue(V value) {
        Object old = this.value;
        this.value = value;
        return (V)old;
    }

    public boolean isFull() {
        return true;
    }

    public int maxSize() {
        return 1;
    }

    public V get(Object key) {
        if (this.isEqualKey(key)) {
            return (V)this.value;
        }
        return null;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(Object key) {
        return this.isEqualKey(key);
    }

    public boolean containsValue(Object value) {
        return this.isEqualValue(value);
    }

    public V put(K key, V value) {
        if (this.isEqualKey(key)) {
            return (V)this.setValue(value);
        }
        throw new IllegalArgumentException("Cannot put new key/value pair - Map is fixed size singleton");
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return;
            }
            case 1: {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                this.put(entry.getKey(), entry.getValue());
                return;
            }
        }
        throw new IllegalArgumentException("The map size must be 0 or 1");
    }

    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        TiedMapEntry entry = new TiedMapEntry((Map)this, this.getKey());
        return Collections.singleton(entry);
    }

    public Set<K> keySet() {
        return Collections.singleton(this.key);
    }

    public Collection<V> values() {
        return new SingletonValues(this);
    }

    public OrderedMapIterator<K, V> mapIterator() {
        return new SingletonMapIterator(this);
    }

    public K firstKey() {
        return (K)this.getKey();
    }

    public K lastKey() {
        return (K)this.getKey();
    }

    public K nextKey(K key) {
        return null;
    }

    public K previousKey(K key) {
        return null;
    }

    protected boolean isEqualKey(Object key) {
        return key == null ? this.getKey() == null : key.equals(this.getKey());
    }

    protected boolean isEqualValue(Object value) {
        return value == null ? this.getValue() == null : value.equals(this.getValue());
    }

    public SingletonMap<K, V> clone() {
        try {
            return (SingletonMap)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (other.size() != 1) {
            return false;
        }
        Map.Entry entry = other.entrySet().iterator().next();
        return this.isEqualKey(entry.getKey()) && this.isEqualValue(entry.getValue());
    }

    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return new StringBuilder(128).append('{').append(this.getKey() == this ? "(this Map)" : this.getKey()).append('=').append(this.getValue() == this ? "(this Map)" : this.getValue()).append('}').toString();
    }
}

