/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.AbstractIterableMap;
import org.apache.commons.collections4.map.StaticBucketMap;

public final class StaticBucketMap<K, V>
extends AbstractIterableMap<K, V> {
    private static final int DEFAULT_BUCKETS = 255;
    private final Node<K, V>[] buckets;
    private final Lock[] locks;

    public StaticBucketMap() {
        this(255);
    }

    public StaticBucketMap(int numBuckets) {
        int size = Math.max(17, numBuckets);
        if (size % 2 == 0) {
            --size;
        }
        this.buckets = new Node[size];
        this.locks = new Lock[size];
        for (int i = 0; i < size; ++i) {
            this.locks[i] = new Lock(null);
        }
    }

    private int getHash(Object key) {
        if (key == null) {
            return 0;
        }
        int hash = key.hashCode();
        hash += ~(hash << 15);
        hash ^= hash >>> 10;
        hash += hash << 3;
        hash ^= hash >>> 6;
        hash += ~(hash << 11);
        hash ^= hash >>> 16;
        return (hash %= this.buckets.length) < 0 ? hash * -1 : hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int cnt = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            Lock lock = this.locks[i];
            synchronized (lock) {
                cnt += this.locks[i].size;
                continue;
            }
        }
        return cnt;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Object key) {
        int hash = this.getHash(key);
        Lock lock = this.locks[hash];
        synchronized (lock) {
            Node n = this.buckets[hash];
            while (n != null) {
                if (n.key == key || n.key != null && n.key.equals(key)) {
                    return (V)n.value;
                }
                n = n.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        int hash = this.getHash(key);
        Lock lock = this.locks[hash];
        synchronized (lock) {
            Node n = this.buckets[hash];
            while (n != null) {
                if (n.key == key || n.key != null && n.key.equals(key)) {
                    return true;
                }
                n = n.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Lock lock = this.locks[i];
            synchronized (lock) {
                Node n = this.buckets[i];
                while (n != null) {
                    if (n.value == value || n.value != null && n.value.equals(value)) {
                        return true;
                    }
                    n = n.next;
                }
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        int hash = this.getHash(key);
        Lock lock = this.locks[hash];
        synchronized (lock) {
            Node n = this.buckets[hash];
            if (n == null) {
                n = new Node(null);
                n.key = key;
                n.value = value;
                this.buckets[hash] = n;
                ++this.locks[hash].size;
                return null;
            }
            Node next = n;
            while (next != null) {
                n = next;
                if (n.key == key || n.key != null && n.key.equals(key)) {
                    Object returnVal = n.value;
                    n.value = value;
                    return (V)returnVal;
                }
                next = next.next;
            }
            Node newNode = new Node(null);
            newNode.key = key;
            newNode.value = value;
            n.next = newNode;
            ++this.locks[hash].size;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key) {
        int hash = this.getHash(key);
        Lock lock = this.locks[hash];
        synchronized (lock) {
            Node n = this.buckets[hash];
            Node prev = null;
            while (n != null) {
                if (n.key == key || n.key != null && n.key.equals(key)) {
                    if (null == prev) {
                        this.buckets[hash] = n.next;
                    } else {
                        prev.next = n.next;
                    }
                    --this.locks[hash].size;
                    return (V)n.value;
                }
                prev = n;
                n = n.next;
            }
        }
        return null;
    }

    public Set<K> keySet() {
        return new KeySet(this, null);
    }

    public Collection<V> values() {
        return new Values(this, null);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(this, null);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            Lock lock;
            Lock lock2 = lock = this.locks[i];
            synchronized (lock2) {
                this.buckets[i] = null;
                lock.size = 0;
                continue;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        return this.entrySet().equals(other.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            Lock lock = this.locks[i];
            synchronized (lock) {
                Node n = this.buckets[i];
                while (n != null) {
                    hashCode += n.hashCode();
                    n = n.next;
                }
                continue;
            }
        }
        return hashCode;
    }

    public void atomic(Runnable r) {
        if (r == null) {
            throw new NullPointerException();
        }
        this.atomic(r, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atomic(Runnable r, int bucket) {
        if (bucket >= this.buckets.length) {
            r.run();
            return;
        }
        Lock lock = this.locks[bucket];
        synchronized (lock) {
            this.atomic(r, bucket + 1);
        }
    }

    static /* synthetic */ Node[] access$500(StaticBucketMap x0) {
        return x0.buckets;
    }

    static /* synthetic */ Lock[] access$600(StaticBucketMap x0) {
        return x0.locks;
    }

    static /* synthetic */ int access$900(StaticBucketMap x0, Object x1) {
        return x0.getHash(x1);
    }
}

