/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.iterators.EmptyMapIterator;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMap;
import org.apache.commons.collections4.multiset.UnmodifiableMultiSet;

public abstract class AbstractMultiValuedMap<K, V>
implements MultiValuedMap<K, V> {
    private transient Collection<V> valuesView;
    private transient EntryValues entryValuesView;
    private transient MultiSet<K> keysMultiSetView;
    private transient AsMap asMapView;
    private transient Map<K, Collection<V>> map;

    protected AbstractMultiValuedMap() {
    }

    protected AbstractMultiValuedMap(Map<K, ? extends Collection<V>> map) {
        if (map == null) {
            throw new NullPointerException("Map must not be null.");
        }
        this.map = map;
    }

    protected Map<K, ? extends Collection<V>> getMap() {
        return this.map;
    }

    protected void setMap(Map<K, ? extends Collection<V>> map) {
        this.map = map;
    }

    protected abstract Collection<V> createCollection();

    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public boolean containsMapping(Object key, Object value) {
        Collection coll = (Collection)this.getMap().get(key);
        return coll != null && coll.contains(value);
    }

    public Collection<Map.Entry<K, V>> entries() {
        return this.entryValuesView != null ? this.entryValuesView : (this.entryValuesView = new EntryValues(this, null));
    }

    public Collection<V> get(K key) {
        return this.wrappedCollection(key);
    }

    Collection<V> wrappedCollection(K key) {
        return new WrappedCollection(this, key);
    }

    public Collection<V> remove(Object key) {
        return CollectionUtils.emptyIfNull((Collection)((Collection)this.getMap().remove(key)));
    }

    public boolean removeMapping(Object key, Object value) {
        Collection coll = (Collection)this.getMap().get(key);
        if (coll == null) {
            return false;
        }
        boolean changed = coll.remove(value);
        if (coll.isEmpty()) {
            this.getMap().remove(key);
        }
        return changed;
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    public int size() {
        int size = 0;
        for (Collection col : this.getMap().values()) {
            size += col.size();
        }
        return size;
    }

    public Collection<V> values() {
        Collection vs = this.valuesView;
        return vs != null ? vs : (this.valuesView = new Values(this, null));
    }

    public void clear() {
        this.getMap().clear();
    }

    public boolean put(K key, V value) {
        Collection coll = (Collection)this.getMap().get(key);
        if (coll == null) {
            coll = this.createCollection();
            if (coll.add(value)) {
                this.map.put(key, coll);
                return true;
            }
            return false;
        }
        return coll.add(value);
    }

    public boolean putAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException("Map must not be null.");
        }
        boolean changed = false;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    public boolean putAll(MultiValuedMap<? extends K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException("Map must not be null.");
        }
        boolean changed = false;
        for (Map.Entry entry : map.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    public MultiSet<K> keys() {
        if (this.keysMultiSetView == null) {
            this.keysMultiSetView = UnmodifiableMultiSet.unmodifiableMultiSet((MultiSet)new KeysMultiSet(this, null));
        }
        return this.keysMultiSetView;
    }

    public Map<K, Collection<V>> asMap() {
        return this.asMapView != null ? this.asMapView : (this.asMapView = new AsMap(this, this.map));
    }

    public boolean putAll(K key, Iterable<? extends V> values) {
        if (values == null) {
            throw new NullPointerException("Values must not be null.");
        }
        if (values instanceof Collection) {
            Collection valueCollection = (Collection)values;
            return !valueCollection.isEmpty() && this.get(key).addAll(valueCollection);
        }
        Iterator<V> it = values.iterator();
        return it.hasNext() && CollectionUtils.addAll((Collection)this.get(key), it);
    }

    public MapIterator<K, V> mapIterator() {
        if (this.size() == 0) {
            return EmptyMapIterator.emptyMapIterator();
        }
        return new MultiValuedMapIterator(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiValuedMap) {
            return this.asMap().equals(((MultiValuedMap)obj).asMap());
        }
        return false;
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public String toString() {
        return this.getMap().toString();
    }

    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry entry : this.map.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeInt(((Collection)entry.getValue()).size());
            for (Object value : (Collection)entry.getValue()) {
                out.writeObject(value);
            }
        }
    }

    protected void doReadObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int entrySize = in.readInt();
        for (int i = 0; i < entrySize; ++i) {
            Object key = in.readObject();
            Collection values = this.get(key);
            int valueSize = in.readInt();
            for (int j = 0; j < valueSize; ++j) {
                Object value = in.readObject();
                values.add(value);
            }
        }
    }

    static /* synthetic */ Map access$300(AbstractMultiValuedMap x0) {
        return x0.map;
    }
}

