/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multiset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.multiset.AbstractMapMultiSet;
import org.apache.commons.collections4.multiset.AbstractMultiSet;

public abstract class AbstractMapMultiSet<E>
extends AbstractMultiSet<E> {
    private transient Map<E, MutableInteger> map;
    private transient int size;
    private transient int modCount;

    protected AbstractMapMultiSet() {
    }

    protected AbstractMapMultiSet(Map<E, MutableInteger> map) {
        this.map = map;
    }

    protected Map<E, MutableInteger> getMap() {
        return this.map;
    }

    protected void setMap(Map<E, MutableInteger> map) {
        this.map = map;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int getCount(Object object) {
        MutableInteger count = (MutableInteger)this.map.get(object);
        if (count != null) {
            return count.value;
        }
        return 0;
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public Iterator<E> iterator() {
        return new MapBasedMultiSetIterator(this);
    }

    public int add(E object, int occurrences) {
        int oldCount;
        if (occurrences < 0) {
            throw new IllegalArgumentException("Occurrences must not be negative.");
        }
        MutableInteger mut = (MutableInteger)this.map.get(object);
        int n = oldCount = mut != null ? mut.value : 0;
        if (occurrences > 0) {
            ++this.modCount;
            this.size += occurrences;
            if (mut == null) {
                this.map.put(object, new MutableInteger(occurrences));
            } else {
                mut.value += occurrences;
            }
        }
        return oldCount;
    }

    public void clear() {
        ++this.modCount;
        this.map.clear();
        this.size = 0;
    }

    public int remove(Object object, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Occurrences must not be negative.");
        }
        MutableInteger mut = (MutableInteger)this.map.get(object);
        if (mut == null) {
            return 0;
        }
        int oldCount = mut.value;
        if (occurrences > 0) {
            ++this.modCount;
            if (occurrences < mut.value) {
                mut.value -= occurrences;
                this.size -= occurrences;
            } else {
                this.map.remove(object);
                this.size -= mut.value;
            }
        }
        return oldCount;
    }

    protected Iterator<E> createUniqueSetIterator() {
        return new UniqueSetIterator(this.getMap().keySet().iterator(), this);
    }

    protected int uniqueElements() {
        return this.map.size();
    }

    protected Iterator<MultiSet.Entry<E>> createEntrySetIterator() {
        return new EntrySetIterator(this.map.entrySet().iterator(), this);
    }

    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry entry : this.map.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeInt(((MutableInteger)entry.getValue()).value);
        }
    }

    protected void doReadObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int entrySize = in.readInt();
        for (int i = 0; i < entrySize; ++i) {
            Object obj = in.readObject();
            int count = in.readInt();
            this.map.put(obj, new MutableInteger(count));
            this.size += count;
        }
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        for (Map.Entry entry : this.map.entrySet()) {
            Object current = entry.getKey();
            MutableInteger count = (MutableInteger)entry.getValue();
            for (int index = count.value; index > 0; --index) {
                result[i++] = current;
            }
        }
        return result;
    }

    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            Object[] unchecked = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            array = unchecked;
        }
        int i = 0;
        for (Map.Entry entry : this.map.entrySet()) {
            Object current = entry.getKey();
            MutableInteger count = (MutableInteger)entry.getValue();
            for (int index = count.value; index > 0; --index) {
                Object unchecked = current;
                array[i++] = unchecked;
            }
        }
        while (i < array.length) {
            array[i++] = null;
        }
        return array;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultiSet)) {
            return false;
        }
        MultiSet other = (MultiSet)object;
        if (other.size() != this.size()) {
            return false;
        }
        for (Object element : this.map.keySet()) {
            if (other.getCount(element) == this.getCount(element)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int total = 0;
        for (Map.Entry entry : this.map.entrySet()) {
            Object element = entry.getKey();
            MutableInteger count = (MutableInteger)entry.getValue();
            total += (element == null ? 0 : element.hashCode()) ^ count.value;
        }
        return total;
    }

    static /* synthetic */ Map access$000(AbstractMapMultiSet x0) {
        return x0.map;
    }

    static /* synthetic */ int access$100(AbstractMapMultiSet x0) {
        return x0.modCount;
    }

    static /* synthetic */ int access$210(AbstractMapMultiSet x0) {
        return x0.size--;
    }
}

