/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multiset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.multiset.AbstractMultiSet;

public abstract class AbstractMultiSet<E>
extends AbstractCollection<E>
implements MultiSet<E> {
    private transient Set<E> uniqueSet;
    private transient Set<MultiSet.Entry<E>> entrySet;

    protected AbstractMultiSet() {
    }

    @Override
    public int size() {
        int totalSize = 0;
        for (MultiSet.Entry entry : this.entrySet()) {
            totalSize += entry.getCount();
        }
        return totalSize;
    }

    public int getCount(Object object) {
        for (MultiSet.Entry entry : this.entrySet()) {
            Object element = entry.getElement();
            if (element != object && (element == null || !element.equals(object))) continue;
            return entry.getCount();
        }
        return 0;
    }

    public int setCount(E object, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must not be negative.");
        }
        int oldCount = this.getCount(object);
        if (oldCount < count) {
            this.add(object, count - oldCount);
        } else {
            this.remove(object, oldCount - count);
        }
        return oldCount;
    }

    @Override
    public boolean contains(Object object) {
        return this.getCount(object) > 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new MultiSetIterator(this);
    }

    @Override
    public boolean add(E object) {
        this.add(object, 1);
        return true;
    }

    public int add(E object, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public boolean remove(Object object) {
        return this.remove(object, 1) != 0;
    }

    public int remove(Object object, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean result = false;
        for (Object obj : coll) {
            boolean changed = this.remove(obj, this.getCount(obj)) != 0;
            result = result || changed;
        }
        return result;
    }

    public Set<E> uniqueSet() {
        if (this.uniqueSet == null) {
            this.uniqueSet = this.createUniqueSet();
        }
        return this.uniqueSet;
    }

    protected Set<E> createUniqueSet() {
        return new UniqueSet(this);
    }

    protected Iterator<E> createUniqueSetIterator() {
        1 transformer = new /* Unavailable Anonymous Inner Class!! */;
        return IteratorUtils.transformedIterator(this.entrySet().iterator(), (Transformer)transformer);
    }

    public Set<MultiSet.Entry<E>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = this.createEntrySet();
        }
        return this.entrySet;
    }

    protected Set<MultiSet.Entry<E>> createEntrySet() {
        return new EntrySet(this);
    }

    protected abstract int uniqueElements();

    protected abstract Iterator<MultiSet.Entry<E>> createEntrySetIterator();

    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.entrySet().size());
        for (MultiSet.Entry entry : this.entrySet()) {
            out.writeObject(entry.getElement());
            out.writeInt(entry.getCount());
        }
    }

    protected void doReadObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int entrySize = in.readInt();
        for (int i = 0; i < entrySize; ++i) {
            Object obj = in.readObject();
            int count = in.readInt();
            this.setCount(obj, count);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultiSet)) {
            return false;
        }
        MultiSet other = (MultiSet)object;
        if (other.size() != this.size()) {
            return false;
        }
        for (MultiSet.Entry entry : this.entrySet()) {
            if (other.getCount(entry.getElement()) == this.getCount(entry.getElement())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }
}

