/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.iterators.UnmodifiableIterator;
import org.apache.commons.collections4.queue.AbstractQueueDecorator;

public final class UnmodifiableQueue<E>
extends AbstractQueueDecorator<E>
implements Unmodifiable {
    private static final long serialVersionUID = 1832948656215393357L;

    public static <E> Queue<E> unmodifiableQueue(Queue<? extends E> queue) {
        if (queue instanceof Unmodifiable) {
            Queue<? extends E> tmpQueue = queue;
            return tmpQueue;
        }
        return new UnmodifiableQueue(queue);
    }

    private UnmodifiableQueue(Queue<? extends E> queue) {
        super(queue);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.decorated());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setCollection((Collection)in.readObject());
    }

    public Iterator<E> iterator() {
        return UnmodifiableIterator.unmodifiableIterator(this.decorated().iterator());
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    public boolean offer(E obj) {
        throw new UnsupportedOperationException();
    }

    public E poll() {
        throw new UnsupportedOperationException();
    }

    public E remove() {
        throw new UnsupportedOperationException();
    }
}

