/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.trie;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.trie.AbstractBitwiseTrie;
import org.apache.commons.collections4.trie.AbstractPatriciaTrie;
import org.apache.commons.collections4.trie.KeyAnalyzer;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class AbstractPatriciaTrie<K, V>
extends AbstractBitwiseTrie<K, V> {
    private static final long serialVersionUID = 5155253417231339498L;
    private transient TrieEntry<K, V> root = new TrieEntry(null, null, -1);
    private volatile transient Set<K> keySet;
    private volatile transient Collection<V> values;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private transient int size = 0;
    protected transient int modCount = 0;

    protected AbstractPatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer) {
        super(keyAnalyzer);
    }

    protected AbstractPatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer, Map<? extends K, ? extends V> map) {
        super(keyAnalyzer);
        this.putAll(map);
    }

    public void clear() {
        this.root.key = null;
        this.root.bitIndex = -1;
        this.root.value = null;
        this.root.parent = null;
        this.root.left = this.root;
        this.root.right = null;
        this.root.predecessor = this.root;
        this.size = 0;
        this.incrementModCount();
    }

    public int size() {
        return this.size;
    }

    void incrementSize() {
        ++this.size;
        this.incrementModCount();
    }

    void decrementSize() {
        --this.size;
        this.incrementModCount();
    }

    private void incrementModCount() {
        ++this.modCount;
    }

    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        int lengthInBits = this.lengthInBits(key);
        if (lengthInBits == 0) {
            if (this.root.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return (V)this.root.setKeyValue(key, value);
        }
        TrieEntry found = this.getNearestEntryForKey(key, lengthInBits);
        if (this.compareKeys(key, found.key)) {
            if (found.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return (V)found.setKeyValue(key, value);
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (!KeyAnalyzer.isOutOfBoundsIndex((int)bitIndex)) {
            if (KeyAnalyzer.isValidBitIndex((int)bitIndex)) {
                TrieEntry t = new TrieEntry(key, value, bitIndex);
                this.addEntry(t, lengthInBits);
                this.incrementSize();
                return null;
            }
            if (KeyAnalyzer.isNullBitKey((int)bitIndex)) {
                if (this.root.isEmpty()) {
                    this.incrementSize();
                } else {
                    this.incrementModCount();
                }
                return (V)this.root.setKeyValue(key, value);
            }
            if (KeyAnalyzer.isEqualBitKey((int)bitIndex) && found != this.root) {
                this.incrementModCount();
                return (V)found.setKeyValue(key, value);
            }
        }
        throw new IllegalArgumentException("Failed to put: " + key + " -> " + value + ", " + bitIndex);
    }

    TrieEntry<K, V> addEntry(TrieEntry<K, V> entry, int lengthInBits) {
        TrieEntry current = this.root.left;
        TrieEntry path = this.root;
        while (true) {
            if (current.bitIndex >= entry.bitIndex || current.bitIndex <= path.bitIndex) {
                entry.predecessor = entry;
                if (!this.isBitSet(entry.key, entry.bitIndex, lengthInBits)) {
                    entry.left = entry;
                    entry.right = current;
                } else {
                    entry.left = current;
                    entry.right = entry;
                }
                entry.parent = path;
                if (current.bitIndex >= entry.bitIndex) {
                    current.parent = entry;
                }
                if (current.bitIndex <= path.bitIndex) {
                    current.predecessor = entry;
                }
                if (path == this.root || !this.isBitSet(entry.key, path.bitIndex, lengthInBits)) {
                    path.left = entry;
                } else {
                    path.right = entry;
                }
                return entry;
            }
            path = current;
            if (!this.isBitSet(entry.key, current.bitIndex, lengthInBits)) {
                current = current.left;
                continue;
            }
            current = current.right;
        }
    }

    public V get(Object k) {
        TrieEntry entry = this.getEntry(k);
        return (V)(entry != null ? entry.getValue() : null);
    }

    TrieEntry<K, V> getEntry(Object k) {
        Object key = this.castKey(k);
        if (key == null) {
            return null;
        }
        int lengthInBits = this.lengthInBits(key);
        TrieEntry entry = this.getNearestEntryForKey(key, lengthInBits);
        return !entry.isEmpty() && this.compareKeys(key, entry.key) ? entry : null;
    }

    public Map.Entry<K, V> select(K key) {
        Reference reference;
        int lengthInBits = this.lengthInBits(key);
        if (!this.selectR(this.root.left, -1, key, lengthInBits, reference = new Reference(null))) {
            return (Map.Entry)reference.get();
        }
        return null;
    }

    public K selectKey(K key) {
        Map.Entry entry = this.select(key);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    public V selectValue(K key) {
        Map.Entry entry = this.select(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    private boolean selectR(TrieEntry<K, V> h, int bitIndex, K key, int lengthInBits, Reference<Map.Entry<K, V>> reference) {
        if (h.bitIndex <= bitIndex) {
            if (!h.isEmpty()) {
                reference.set(h);
                return false;
            }
            return true;
        }
        if (!this.isBitSet(key, h.bitIndex, lengthInBits)) {
            if (this.selectR(h.left, h.bitIndex, key, lengthInBits, reference)) {
                return this.selectR(h.right, h.bitIndex, key, lengthInBits, reference);
            }
        } else if (this.selectR(h.right, h.bitIndex, key, lengthInBits, reference)) {
            return this.selectR(h.left, h.bitIndex, key, lengthInBits, reference);
        }
        return false;
    }

    public boolean containsKey(Object k) {
        int lengthInBits;
        if (k == null) {
            return false;
        }
        Object key = this.castKey(k);
        TrieEntry entry = this.getNearestEntryForKey(key, lengthInBits = this.lengthInBits(key));
        return !entry.isEmpty() && this.compareKeys(key, entry.key);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this, null);
        }
        return this.entrySet;
    }

    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this, null);
        }
        return this.keySet;
    }

    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values(this, null);
        }
        return this.values;
    }

    public V remove(Object k) {
        if (k == null) {
            return null;
        }
        Object key = this.castKey(k);
        int lengthInBits = this.lengthInBits(key);
        TrieEntry current = this.root.left;
        TrieEntry path = this.root;
        while (true) {
            if (current.bitIndex <= path.bitIndex) {
                if (!current.isEmpty() && this.compareKeys(key, current.key)) {
                    return (V)this.removeEntry(current);
                }
                return null;
            }
            path = current;
            if (!this.isBitSet(key, current.bitIndex, lengthInBits)) {
                current = current.left;
                continue;
            }
            current = current.right;
        }
    }

    TrieEntry<K, V> getNearestEntryForKey(K key, int lengthInBits) {
        TrieEntry current = this.root.left;
        TrieEntry path = this.root;
        while (current.bitIndex > path.bitIndex) {
            path = current;
            if (!this.isBitSet(key, current.bitIndex, lengthInBits)) {
                current = current.left;
                continue;
            }
            current = current.right;
        }
        return current;
    }

    V removeEntry(TrieEntry<K, V> h) {
        if (h != this.root) {
            if (h.isInternalNode()) {
                this.removeInternalEntry(h);
            } else {
                this.removeExternalEntry(h);
            }
        }
        this.decrementSize();
        return (V)h.setKeyValue(null, null);
    }

    private void removeExternalEntry(TrieEntry<K, V> h) {
        TrieEntry child;
        if (h == this.root) {
            throw new IllegalArgumentException("Cannot delete root Entry!");
        }
        if (!h.isExternalNode()) {
            throw new IllegalArgumentException(h + " is not an external Entry!");
        }
        TrieEntry parent = h.parent;
        TrieEntry trieEntry = child = h.left == h ? h.right : h.left;
        if (parent.left == h) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        if (child.bitIndex > parent.bitIndex) {
            child.parent = parent;
        } else {
            child.predecessor = parent;
        }
    }

    private void removeInternalEntry(TrieEntry<K, V> h) {
        TrieEntry child;
        if (h == this.root) {
            throw new IllegalArgumentException("Cannot delete root Entry!");
        }
        if (!h.isInternalNode()) {
            throw new IllegalArgumentException(h + " is not an internal Entry!");
        }
        TrieEntry p = h.predecessor;
        p.bitIndex = h.bitIndex;
        TrieEntry parent = p.parent;
        TrieEntry trieEntry = child = p.left == h ? p.right : p.left;
        if (p.predecessor == p && p.parent != h) {
            p.predecessor = p.parent;
        }
        if (parent.left == p) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        if (child.bitIndex > parent.bitIndex) {
            child.parent = parent;
        }
        if (h.left.parent == h) {
            h.left.parent = p;
        }
        if (h.right.parent == h) {
            h.right.parent = p;
        }
        if (h.parent.left == h) {
            h.parent.left = p;
        } else {
            h.parent.right = p;
        }
        p.parent = h.parent;
        p.left = h.left;
        p.right = h.right;
        if (AbstractPatriciaTrie.isValidUplink((TrieEntry)p.left, (TrieEntry)p)) {
            p.left.predecessor = p;
        }
        if (AbstractPatriciaTrie.isValidUplink((TrieEntry)p.right, (TrieEntry)p)) {
            p.right.predecessor = p;
        }
    }

    TrieEntry<K, V> nextEntry(TrieEntry<K, V> node) {
        if (node == null) {
            return this.firstEntry();
        }
        return this.nextEntryImpl(node.predecessor, node, null);
    }

    TrieEntry<K, V> nextEntryImpl(TrieEntry<K, V> start, TrieEntry<K, V> previous, TrieEntry<K, V> tree) {
        TrieEntry current = start;
        if (previous == null || start != previous.predecessor) {
            while (!current.left.isEmpty() && previous != current.left) {
                if (AbstractPatriciaTrie.isValidUplink((TrieEntry)current.left, current)) {
                    return current.left;
                }
                current = current.left;
            }
        }
        if (current.isEmpty()) {
            return null;
        }
        if (current.right == null) {
            return null;
        }
        if (previous != current.right) {
            if (AbstractPatriciaTrie.isValidUplink((TrieEntry)current.right, (TrieEntry)current)) {
                return current.right;
            }
            return this.nextEntryImpl(current.right, previous, tree);
        }
        while (current == current.parent.right) {
            if (current == tree) {
                return null;
            }
            current = current.parent;
        }
        if (current == tree) {
            return null;
        }
        if (current.parent.right == null) {
            return null;
        }
        if (previous != current.parent.right && AbstractPatriciaTrie.isValidUplink((TrieEntry)current.parent.right, (TrieEntry)current.parent)) {
            return current.parent.right;
        }
        if (current.parent.right == current.parent) {
            return null;
        }
        return this.nextEntryImpl(current.parent.right, previous, tree);
    }

    TrieEntry<K, V> firstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.followLeft(this.root);
    }

    TrieEntry<K, V> followLeft(TrieEntry<K, V> node) {
        while (true) {
            TrieEntry child;
            if ((child = node.left).isEmpty()) {
                child = node.right;
            }
            if (child.bitIndex <= node.bitIndex) {
                return child;
            }
            node = child;
        }
    }

    public Comparator<? super K> comparator() {
        return this.getKeyAnalyzer();
    }

    public K firstKey() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return (K)this.firstEntry().getKey();
    }

    public K lastKey() {
        TrieEntry entry = this.lastEntry();
        if (entry != null) {
            return (K)entry.getKey();
        }
        throw new NoSuchElementException();
    }

    public K nextKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        TrieEntry entry = this.getEntry(key);
        if (entry != null) {
            TrieEntry nextEntry = this.nextEntry(entry);
            return (K)(nextEntry != null ? nextEntry.getKey() : null);
        }
        return null;
    }

    public K previousKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        TrieEntry entry = this.getEntry(key);
        if (entry != null) {
            TrieEntry prevEntry = this.previousEntry(entry);
            return (K)(prevEntry != null ? prevEntry.getKey() : null);
        }
        return null;
    }

    public OrderedMapIterator<K, V> mapIterator() {
        return new TrieMapIterator(this, null);
    }

    public SortedMap<K, V> prefixMap(K key) {
        return this.getPrefixMapByBits(key, 0, this.lengthInBits(key));
    }

    private SortedMap<K, V> getPrefixMapByBits(K key, int offsetInBits, int lengthInBits) {
        int offsetLength = offsetInBits + lengthInBits;
        if (offsetLength > this.lengthInBits(key)) {
            throw new IllegalArgumentException(offsetInBits + " + " + lengthInBits + " > " + this.lengthInBits(key));
        }
        if (offsetLength == 0) {
            return this;
        }
        return new PrefixRangeMap(this, key, offsetInBits, lengthInBits, null);
    }

    public SortedMap<K, V> headMap(K toKey) {
        return new RangeEntryMap(this, null, toKey);
    }

    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return new RangeEntryMap(this, fromKey, toKey);
    }

    public SortedMap<K, V> tailMap(K fromKey) {
        return new RangeEntryMap(this, fromKey, null);
    }

    TrieEntry<K, V> higherEntry(K key) {
        int lengthInBits = this.lengthInBits(key);
        if (lengthInBits == 0) {
            if (!this.root.isEmpty()) {
                if (this.size() > 1) {
                    return this.nextEntry(this.root);
                }
                return null;
            }
            return this.firstEntry();
        }
        TrieEntry found = this.getNearestEntryForKey(key, lengthInBits);
        if (this.compareKeys(key, found.key)) {
            return this.nextEntry(found);
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (KeyAnalyzer.isValidBitIndex((int)bitIndex)) {
            TrieEntry added = new TrieEntry(key, null, bitIndex);
            this.addEntry(added, lengthInBits);
            this.incrementSize();
            TrieEntry ceil = this.nextEntry(added);
            this.removeEntry(added);
            this.modCount -= 2;
            return ceil;
        }
        if (KeyAnalyzer.isNullBitKey((int)bitIndex)) {
            if (!this.root.isEmpty()) {
                return this.firstEntry();
            }
            if (this.size() > 1) {
                return this.nextEntry(this.firstEntry());
            }
            return null;
        }
        if (KeyAnalyzer.isEqualBitKey((int)bitIndex)) {
            return this.nextEntry(found);
        }
        throw new IllegalStateException("invalid lookup: " + key);
    }

    TrieEntry<K, V> ceilingEntry(K key) {
        int lengthInBits = this.lengthInBits(key);
        if (lengthInBits == 0) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return this.firstEntry();
        }
        TrieEntry found = this.getNearestEntryForKey(key, lengthInBits);
        if (this.compareKeys(key, found.key)) {
            return found;
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (KeyAnalyzer.isValidBitIndex((int)bitIndex)) {
            TrieEntry added = new TrieEntry(key, null, bitIndex);
            this.addEntry(added, lengthInBits);
            this.incrementSize();
            TrieEntry ceil = this.nextEntry(added);
            this.removeEntry(added);
            this.modCount -= 2;
            return ceil;
        }
        if (KeyAnalyzer.isNullBitKey((int)bitIndex)) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return this.firstEntry();
        }
        if (KeyAnalyzer.isEqualBitKey((int)bitIndex)) {
            return found;
        }
        throw new IllegalStateException("invalid lookup: " + key);
    }

    TrieEntry<K, V> lowerEntry(K key) {
        int lengthInBits = this.lengthInBits(key);
        if (lengthInBits == 0) {
            return null;
        }
        TrieEntry found = this.getNearestEntryForKey(key, lengthInBits);
        if (this.compareKeys(key, found.key)) {
            return this.previousEntry(found);
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (KeyAnalyzer.isValidBitIndex((int)bitIndex)) {
            TrieEntry added = new TrieEntry(key, null, bitIndex);
            this.addEntry(added, lengthInBits);
            this.incrementSize();
            TrieEntry prior = this.previousEntry(added);
            this.removeEntry(added);
            this.modCount -= 2;
            return prior;
        }
        if (KeyAnalyzer.isNullBitKey((int)bitIndex)) {
            return null;
        }
        if (KeyAnalyzer.isEqualBitKey((int)bitIndex)) {
            return this.previousEntry(found);
        }
        throw new IllegalStateException("invalid lookup: " + key);
    }

    TrieEntry<K, V> floorEntry(K key) {
        int lengthInBits = this.lengthInBits(key);
        if (lengthInBits == 0) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return null;
        }
        TrieEntry found = this.getNearestEntryForKey(key, lengthInBits);
        if (this.compareKeys(key, found.key)) {
            return found;
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (KeyAnalyzer.isValidBitIndex((int)bitIndex)) {
            TrieEntry added = new TrieEntry(key, null, bitIndex);
            this.addEntry(added, lengthInBits);
            this.incrementSize();
            TrieEntry floor = this.previousEntry(added);
            this.removeEntry(added);
            this.modCount -= 2;
            return floor;
        }
        if (KeyAnalyzer.isNullBitKey((int)bitIndex)) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return null;
        }
        if (KeyAnalyzer.isEqualBitKey((int)bitIndex)) {
            return found;
        }
        throw new IllegalStateException("invalid lookup: " + key);
    }

    TrieEntry<K, V> subtree(K prefix, int offsetInBits, int lengthInBits) {
        TrieEntry entry;
        TrieEntry current = this.root.left;
        TrieEntry path = this.root;
        while (current.bitIndex > path.bitIndex && lengthInBits > current.bitIndex) {
            path = current;
            if (!this.isBitSet(prefix, offsetInBits + current.bitIndex, offsetInBits + lengthInBits)) {
                current = current.left;
                continue;
            }
            current = current.right;
        }
        TrieEntry trieEntry = entry = current.isEmpty() ? path : current;
        if (entry.isEmpty()) {
            return null;
        }
        int endIndexInBits = offsetInBits + lengthInBits;
        if (entry == this.root && this.lengthInBits(entry.getKey()) < endIndexInBits) {
            return null;
        }
        if (this.isBitSet(prefix, endIndexInBits - 1, endIndexInBits) != this.isBitSet(entry.key, lengthInBits - 1, this.lengthInBits(entry.key))) {
            return null;
        }
        int bitIndex = this.getKeyAnalyzer().bitIndex(prefix, offsetInBits, lengthInBits, entry.key, 0, this.lengthInBits(entry.getKey()));
        if (bitIndex >= 0 && bitIndex < lengthInBits) {
            return null;
        }
        return entry;
    }

    TrieEntry<K, V> lastEntry() {
        return this.followRight(this.root.left);
    }

    TrieEntry<K, V> followRight(TrieEntry<K, V> node) {
        if (node.right == null) {
            return null;
        }
        while (node.right.bitIndex > node.bitIndex) {
            node = node.right;
        }
        return node.right;
    }

    TrieEntry<K, V> previousEntry(TrieEntry<K, V> start) {
        if (start.predecessor == null) {
            throw new IllegalArgumentException("must have come from somewhere!");
        }
        if (start.predecessor.right == start) {
            if (AbstractPatriciaTrie.isValidUplink((TrieEntry)start.predecessor.left, (TrieEntry)start.predecessor)) {
                return start.predecessor.left;
            }
            return this.followRight(start.predecessor.left);
        }
        TrieEntry node = start.predecessor;
        while (node.parent != null && node == node.parent.left) {
            node = node.parent;
        }
        if (node.parent == null) {
            return null;
        }
        if (AbstractPatriciaTrie.isValidUplink((TrieEntry)node.parent.left, (TrieEntry)node.parent)) {
            if (node.parent.left == this.root) {
                if (this.root.isEmpty()) {
                    return null;
                }
                return this.root;
            }
            return node.parent.left;
        }
        return this.followRight(node.parent.left);
    }

    TrieEntry<K, V> nextEntryInSubtree(TrieEntry<K, V> node, TrieEntry<K, V> parentOfSubtree) {
        if (node == null) {
            return this.firstEntry();
        }
        return this.nextEntryImpl(node.predecessor, node, parentOfSubtree);
    }

    static boolean isValidUplink(TrieEntry<?, ?> next, TrieEntry<?, ?> from) {
        return next != null && next.bitIndex <= from.bitIndex && !next.isEmpty();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.root = new TrieEntry(null, null, -1);
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            Object k = stream.readObject();
            Object v = stream.readObject();
            this.put(k, v);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }
}

