/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileDeleteStrategy;

public class FileCleaningTracker {
    ReferenceQueue<Object> q = new ReferenceQueue();
    final Collection<Tracker> trackers = Collections.synchronizedSet(new HashSet());
    final List<String> deleteFailures = Collections.synchronizedList(new ArrayList());
    volatile boolean exitWhenFinished = false;
    Thread reaper;

    public void track(File file, Object marker) {
        this.track(file, marker, (FileDeleteStrategy)null);
    }

    public void track(File file, Object marker, FileDeleteStrategy deleteStrategy) {
        if (file == null) {
            throw new NullPointerException("The file must not be null");
        }
        this.addTracker(file.getPath(), marker, deleteStrategy);
    }

    public void track(String path, Object marker) {
        this.track(path, marker, (FileDeleteStrategy)null);
    }

    public void track(String path, Object marker, FileDeleteStrategy deleteStrategy) {
        if (path == null) {
            throw new NullPointerException("The path must not be null");
        }
        this.addTracker(path, marker, deleteStrategy);
    }

    private synchronized void addTracker(String path, Object marker, FileDeleteStrategy deleteStrategy) {
        if (this.exitWhenFinished) {
            throw new IllegalStateException("No new trackers can be added once exitWhenFinished() is called");
        }
        if (this.reaper == null) {
            this.reaper = new Reaper(this);
            this.reaper.start();
        }
        this.trackers.add(new Tracker(path, deleteStrategy, marker, this.q));
    }

    public int getTrackCount() {
        return this.trackers.size();
    }

    public List<String> getDeleteFailures() {
        return this.deleteFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exitWhenFinished() {
        this.exitWhenFinished = true;
        if (this.reaper != null) {
            Thread thread = this.reaper;
            synchronized (thread) {
                this.reaper.interrupt();
            }
        }
    }
}

