/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.input.ReversedLinesFileReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReversedLinesFileReader
implements Closeable {
    private final int blockSize;
    private final Charset encoding;
    private final RandomAccessFile randomAccessFile;
    private final long totalByteLength;
    private final long totalBlockCount;
    private final byte[][] newLineSequences;
    private final int avoidNewlineSplitBufferSize;
    private final int byteDecrement;
    private FilePart currentFilePart;
    private boolean trailingNewlineOfFileSkipped = false;

    public ReversedLinesFileReader(File file) throws IOException {
        this(file, 4096, Charset.defaultCharset().toString());
    }

    public ReversedLinesFileReader(File file, int blockSize, Charset encoding) throws IOException {
        this.blockSize = blockSize;
        this.encoding = encoding;
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.totalByteLength = this.randomAccessFile.length();
        int lastBlockLength = (int)(this.totalByteLength % (long)blockSize);
        if (lastBlockLength > 0) {
            this.totalBlockCount = this.totalByteLength / (long)blockSize + 1L;
        } else {
            this.totalBlockCount = this.totalByteLength / (long)blockSize;
            if (this.totalByteLength > 0L) {
                lastBlockLength = blockSize;
            }
        }
        this.currentFilePart = new FilePart(this, this.totalBlockCount, lastBlockLength, null, null);
        Charset charset = Charsets.toCharset((Charset)encoding);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        float maxBytesPerChar = charsetEncoder.maxBytesPerChar();
        if (maxBytesPerChar == 1.0f) {
            this.byteDecrement = 1;
        } else if (charset == Charset.forName("UTF-8")) {
            this.byteDecrement = 1;
        } else if (charset == Charset.forName("Shift_JIS")) {
            this.byteDecrement = 1;
        } else if (charset == Charset.forName("UTF-16BE") || charset == Charset.forName("UTF-16LE")) {
            this.byteDecrement = 2;
        } else {
            if (charset == Charset.forName("UTF-16")) {
                throw new UnsupportedEncodingException("For UTF-16, you need to specify the byte order (use UTF-16BE or UTF-16LE)");
            }
            throw new UnsupportedEncodingException("Encoding " + encoding + " is not supported yet (feel free to submit a patch)");
        }
        this.newLineSequences = new byte[][]{"\r\n".getBytes(encoding), "\n".getBytes(encoding), "\r".getBytes(encoding)};
        this.avoidNewlineSplitBufferSize = this.newLineSequences[0].length;
    }

    public ReversedLinesFileReader(File file, int blockSize, String encoding) throws IOException {
        this(file, blockSize, Charsets.toCharset((String)encoding));
    }

    public String readLine() throws IOException {
        String line = FilePart.access$100((FilePart)this.currentFilePart);
        while (line == null) {
            this.currentFilePart = FilePart.access$200((FilePart)this.currentFilePart);
            if (this.currentFilePart == null) break;
            line = FilePart.access$100((FilePart)this.currentFilePart);
        }
        if ("".equals(line) && !this.trailingNewlineOfFileSkipped) {
            this.trailingNewlineOfFileSkipped = true;
            line = this.readLine();
        }
        return line;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    static /* synthetic */ int access$300(ReversedLinesFileReader x0) {
        return x0.blockSize;
    }

    static /* synthetic */ RandomAccessFile access$400(ReversedLinesFileReader x0) {
        return x0.randomAccessFile;
    }

    static /* synthetic */ Charset access$500(ReversedLinesFileReader x0) {
        return x0.encoding;
    }

    static /* synthetic */ int access$600(ReversedLinesFileReader x0) {
        return x0.avoidNewlineSplitBufferSize;
    }

    static /* synthetic */ int access$700(ReversedLinesFileReader x0) {
        return x0.byteDecrement;
    }

    static /* synthetic */ byte[][] access$800(ReversedLinesFileReader x0) {
        return x0.newLineSequences;
    }
}

