/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Random;
import org.apache.commons.lang3.RandomUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomStringUtils {
    private static final Random RANDOM = new Random();

    public static String random(int count) {
        return RandomStringUtils.random((int)count, (boolean)false, (boolean)false);
    }

    public static String randomAscii(int count) {
        return RandomStringUtils.random((int)count, (int)32, (int)127, (boolean)false, (boolean)false);
    }

    public static String randomAscii(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomAscii((int)RandomUtils.nextInt((int)minLengthInclusive, (int)maxLengthExclusive));
    }

    public static String randomAlphabetic(int count) {
        return RandomStringUtils.random((int)count, (boolean)true, (boolean)false);
    }

    public static String randomAlphabetic(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomAlphabetic((int)RandomUtils.nextInt((int)minLengthInclusive, (int)maxLengthExclusive));
    }

    public static String randomAlphanumeric(int count) {
        return RandomStringUtils.random((int)count, (boolean)true, (boolean)true);
    }

    public static String randomAlphanumeric(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomAlphanumeric((int)RandomUtils.nextInt((int)minLengthInclusive, (int)maxLengthExclusive));
    }

    public static String randomGraph(int count) {
        return RandomStringUtils.random((int)count, (int)33, (int)126, (boolean)false, (boolean)false);
    }

    public static String randomGraph(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomGraph((int)RandomUtils.nextInt((int)minLengthInclusive, (int)maxLengthExclusive));
    }

    public static String randomNumeric(int count) {
        return RandomStringUtils.random((int)count, (boolean)false, (boolean)true);
    }

    public static String randomNumeric(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomNumeric((int)RandomUtils.nextInt((int)minLengthInclusive, (int)maxLengthExclusive));
    }

    public static String randomPrint(int count) {
        return RandomStringUtils.random((int)count, (int)32, (int)126, (boolean)false, (boolean)false);
    }

    public static String randomPrint(int minLengthInclusive, int maxLengthExclusive) {
        return RandomStringUtils.randomPrint((int)RandomUtils.nextInt((int)minLengthInclusive, (int)maxLengthExclusive));
    }

    public static String random(int count, boolean letters, boolean numbers) {
        return RandomStringUtils.random((int)count, (int)0, (int)0, (boolean)letters, (boolean)numbers);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers) {
        return RandomStringUtils.random((int)count, (int)start, (int)end, (boolean)letters, (boolean)numbers, null, (Random)RANDOM);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers, char ... chars) {
        return RandomStringUtils.random((int)count, (int)start, (int)end, (boolean)letters, (boolean)numbers, (char[])chars, (Random)RANDOM);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        if (chars != null && chars.length == 0) {
            throw new IllegalArgumentException("The chars array must not be empty");
        }
        if (start == 0 && end == 0) {
            if (chars != null) {
                end = chars.length;
            } else if (!letters && !numbers) {
                end = Integer.MAX_VALUE;
            } else {
                end = 123;
                start = 32;
            }
        } else if (end <= start) {
            throw new IllegalArgumentException("Parameter end (" + end + ") must be greater than start (" + start + ")");
        }
        char[] buffer = new char[count];
        int gap = end - start;
        while (count-- != 0) {
            char ch = chars == null ? (char)(random.nextInt(gap) + start) : chars[random.nextInt(gap) + start];
            if (letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                if (ch >= '\udc00' && ch <= '\udfff') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = ch;
                    buffer[--count] = (char)(55296 + random.nextInt(128));
                    continue;
                }
                if (ch >= '\ud800' && ch <= '\udb7f') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = (char)(56320 + random.nextInt(128));
                    buffer[--count] = ch;
                    continue;
                }
                if (ch >= '\udb80' && ch <= '\udbff') {
                    ++count;
                    continue;
                }
                buffer[count] = ch;
                continue;
            }
            ++count;
        }
        return new String(buffer);
    }

    public static String random(int count, String chars) {
        if (chars == null) {
            return RandomStringUtils.random((int)count, (int)0, (int)0, (boolean)false, (boolean)false, null, (Random)RANDOM);
        }
        return RandomStringUtils.random((int)count, (char[])chars.toCharArray());
    }

    public static String random(int count, char ... chars) {
        if (chars == null) {
            return RandomStringUtils.random((int)count, (int)0, (int)0, (boolean)false, (boolean)false, null, (Random)RANDOM);
        }
        return RandomStringUtils.random((int)count, (int)0, (int)chars.length, (boolean)false, (boolean)false, (char[])chars, (Random)RANDOM);
    }
}

