/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Random;
import org.apache.commons.lang3.Validate;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomUtils {
    private static final Random RANDOM = new Random();

    public static boolean nextBoolean() {
        return RANDOM.nextBoolean();
    }

    public static byte[] nextBytes(int count) {
        Validate.isTrue((count >= 0 ? 1 : 0) != 0, (String)"Count cannot be negative.", (Object[])new Object[0]);
        byte[] result = new byte[count];
        RANDOM.nextBytes(result);
        return result;
    }

    public static int nextInt(int startInclusive, int endExclusive) {
        Validate.isTrue((endExclusive >= startInclusive ? 1 : 0) != 0, (String)"Start value must be smaller or equal to end value.", (Object[])new Object[0]);
        Validate.isTrue((startInclusive >= 0 ? 1 : 0) != 0, (String)"Both range values must be non-negative.", (Object[])new Object[0]);
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + RANDOM.nextInt(endExclusive - startInclusive);
    }

    public static int nextInt() {
        return RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE);
    }

    public static long nextLong(long startInclusive, long endExclusive) {
        Validate.isTrue((endExclusive >= startInclusive ? 1 : 0) != 0, (String)"Start value must be smaller or equal to end value.", (Object[])new Object[0]);
        Validate.isTrue((startInclusive >= 0L ? 1 : 0) != 0, (String)"Both range values must be non-negative.", (Object[])new Object[0]);
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return (long)RandomUtils.nextDouble((double)startInclusive, (double)endExclusive);
    }

    public static long nextLong() {
        return RandomUtils.nextLong((long)0L, (long)Long.MAX_VALUE);
    }

    public static double nextDouble(double startInclusive, double endInclusive) {
        Validate.isTrue((endInclusive >= startInclusive ? 1 : 0) != 0, (String)"Start value must be smaller or equal to end value.", (Object[])new Object[0]);
        Validate.isTrue((startInclusive >= 0.0 ? 1 : 0) != 0, (String)"Both range values must be non-negative.", (Object[])new Object[0]);
        if (startInclusive == endInclusive) {
            return startInclusive;
        }
        return startInclusive + (endInclusive - startInclusive) * RANDOM.nextDouble();
    }

    public static double nextDouble() {
        return RandomUtils.nextDouble((double)0.0, (double)Double.MAX_VALUE);
    }

    public static float nextFloat(float startInclusive, float endInclusive) {
        Validate.isTrue((endInclusive >= startInclusive ? 1 : 0) != 0, (String)"Start value must be smaller or equal to end value.", (Object[])new Object[0]);
        Validate.isTrue((startInclusive >= 0.0f ? 1 : 0) != 0, (String)"Both range values must be non-negative.", (Object[])new Object[0]);
        if (startInclusive == endInclusive) {
            return startInclusive;
        }
        return startInclusive + (endInclusive - startInclusive) * RANDOM.nextFloat();
    }

    public static float nextFloat() {
        return RandomUtils.nextFloat((float)0.0f, (float)Float.MAX_VALUE);
    }
}

