/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SerializationUtils {
    public static <T extends Serializable> T clone(T object) {
        if (object == null) {
            return null;
        }
        byte[] objectData = SerializationUtils.serialize(object);
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        ClassLoaderAwareObjectInputStream in = null;
        try {
            Serializable readObject;
            in = new ClassLoaderAwareObjectInputStream((InputStream)bais, object.getClass().getClassLoader());
            Serializable serializable = readObject = (Serializable)in.readObject();
            return (T)serializable;
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException("ClassNotFoundException while reading cloned object data", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SerializationException("IOException while reading cloned object data", (Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                throw new SerializationException("IOException on closing cloned object data InputStream.", (Throwable)ex);
            }
        }
    }

    public static <T extends Serializable> T roundtrip(T msg) {
        return (T)((Serializable)SerializationUtils.deserialize((byte[])SerializationUtils.serialize(msg)));
    }

    public static void serialize(Serializable obj, OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(obj);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Serializable obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SerializationUtils.serialize((Serializable)obj, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static <T> T deserialize(InputStream inputStream) {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream in = null;
        try {
            Object obj;
            in = new ObjectInputStream(inputStream);
            object = obj = in.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (T)object;
    }

    public static <T> T deserialize(byte[] objectData) {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return (T)SerializationUtils.deserialize((InputStream)new ByteArrayInputStream(objectData));
    }
}

