/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ThreadUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThreadUtils {
    public static final AlwaysTruePredicate ALWAYS_TRUE_PREDICATE = new AlwaysTruePredicate(null);

    public static Thread findThreadById(long threadId, ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new IllegalArgumentException("The thread group must not be null");
        }
        Thread thread = ThreadUtils.findThreadById((long)threadId);
        if (thread != null && threadGroup.equals(thread.getThreadGroup())) {
            return thread;
        }
        return null;
    }

    public static Thread findThreadById(long threadId, String threadGroupName) {
        if (threadGroupName == null) {
            throw new IllegalArgumentException("The thread group name must not be null");
        }
        Thread thread = ThreadUtils.findThreadById((long)threadId);
        if (thread != null && thread.getThreadGroup() != null && thread.getThreadGroup().getName().equals(threadGroupName)) {
            return thread;
        }
        return null;
    }

    public static Collection<Thread> findThreadsByName(String threadName, ThreadGroup threadGroup) {
        return ThreadUtils.findThreads((ThreadGroup)threadGroup, (boolean)false, (ThreadPredicate)new NamePredicate(threadName));
    }

    public static Collection<Thread> findThreadsByName(String threadName, String threadGroupName) {
        if (threadName == null) {
            throw new IllegalArgumentException("The thread name must not be null");
        }
        if (threadGroupName == null) {
            throw new IllegalArgumentException("The thread group name must not be null");
        }
        Collection threadGroups = ThreadUtils.findThreadGroups((ThreadGroupPredicate)new NamePredicate(threadGroupName));
        if (threadGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        NamePredicate threadNamePredicate = new NamePredicate(threadName);
        for (ThreadGroup group : threadGroups) {
            result.addAll(ThreadUtils.findThreads((ThreadGroup)group, (boolean)false, (ThreadPredicate)threadNamePredicate));
        }
        return Collections.unmodifiableCollection(result);
    }

    public static Collection<ThreadGroup> findThreadGroupsByName(String threadGroupName) {
        return ThreadUtils.findThreadGroups((ThreadGroupPredicate)new NamePredicate(threadGroupName));
    }

    public static Collection<ThreadGroup> getAllThreadGroups() {
        return ThreadUtils.findThreadGroups((ThreadGroupPredicate)ALWAYS_TRUE_PREDICATE);
    }

    public static ThreadGroup getSystemThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public static Collection<Thread> getAllThreads() {
        return ThreadUtils.findThreads((ThreadPredicate)ALWAYS_TRUE_PREDICATE);
    }

    public static Collection<Thread> findThreadsByName(String threadName) {
        return ThreadUtils.findThreads((ThreadPredicate)new NamePredicate(threadName));
    }

    public static Thread findThreadById(long threadId) {
        Collection result = ThreadUtils.findThreads((ThreadPredicate)new ThreadIdPredicate(threadId));
        return result.isEmpty() ? null : (Thread)result.iterator().next();
    }

    public static Collection<Thread> findThreads(ThreadPredicate predicate) {
        return ThreadUtils.findThreads((ThreadGroup)ThreadUtils.getSystemThreadGroup(), (boolean)true, (ThreadPredicate)predicate);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroupPredicate predicate) {
        return ThreadUtils.findThreadGroups((ThreadGroup)ThreadUtils.getSystemThreadGroup(), (boolean)true, (ThreadGroupPredicate)predicate);
    }

    public static Collection<Thread> findThreads(ThreadGroup group, boolean recurse, ThreadPredicate predicate) {
        Thread[] threads;
        if (group == null) {
            throw new IllegalArgumentException("The group must not be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        int count = group.activeCount();
        while ((count = group.enumerate(threads = new Thread[count + count / 2 + 1], recurse)) >= threads.length) {
        }
        ArrayList<Thread> result = new ArrayList<Thread>(count);
        for (int i = 0; i < count; ++i) {
            if (!predicate.test(threads[i])) continue;
            result.add(threads[i]);
        }
        return Collections.unmodifiableCollection(result);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup group, boolean recurse, ThreadGroupPredicate predicate) {
        ThreadGroup[] threadGroups;
        if (group == null) {
            throw new IllegalArgumentException("The group must not be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        int count = group.activeGroupCount();
        while ((count = group.enumerate(threadGroups = new ThreadGroup[count + count / 2 + 1], recurse)) >= threadGroups.length) {
        }
        ArrayList<ThreadGroup> result = new ArrayList<ThreadGroup>(count);
        for (int i = 0; i < count; ++i) {
            if (!predicate.test(threadGroups[i])) continue;
            result.add(threadGroups[i]);
        }
        return Collections.unmodifiableCollection(result);
    }
}

