/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DiffBuilder
implements Builder<DiffResult> {
    private final List<Diff<?>> diffs;
    private final boolean objectsTriviallyEqual;
    private final Object left;
    private final Object right;
    private final ToStringStyle style;

    public DiffBuilder(Object lhs, Object rhs, ToStringStyle style, boolean testTriviallyEqual) {
        if (lhs == null) {
            throw new IllegalArgumentException("lhs cannot be null");
        }
        if (rhs == null) {
            throw new IllegalArgumentException("rhs cannot be null");
        }
        this.diffs = new ArrayList();
        this.left = lhs;
        this.right = rhs;
        this.style = style;
        this.objectsTriviallyEqual = testTriviallyEqual && (lhs == rhs || lhs.equals(rhs));
    }

    public DiffBuilder(Object lhs, Object rhs, ToStringStyle style) {
        this(lhs, rhs, style, true);
    }

    public DiffBuilder append(String fieldName, boolean lhs, boolean rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, boolean[] lhs, boolean[] rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, byte lhs, byte rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, byte[] lhs, byte[] rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, char lhs, char rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, char[] lhs, char[] rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, double lhs, double rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Double.doubleToLongBits(lhs) != Double.doubleToLongBits(rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, double[] lhs, double[] rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, float lhs, float rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Float.floatToIntBits(lhs) != Float.floatToIntBits(rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, float[] lhs, float[] rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, int lhs, int rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, int[] lhs, int[] rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, long lhs, long rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, long[] lhs, long[] rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, short lhs, short rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs != rhs) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, short[] lhs, short[] rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, Object lhs, Object rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        Object objectToTest = lhs != null ? lhs : rhs;
        if (objectToTest.getClass().isArray()) {
            if (objectToTest instanceof boolean[]) {
                return this.append(fieldName, (boolean[])lhs, (boolean[])rhs);
            }
            if (objectToTest instanceof byte[]) {
                return this.append(fieldName, (byte[])lhs, (byte[])rhs);
            }
            if (objectToTest instanceof char[]) {
                return this.append(fieldName, (char[])lhs, (char[])rhs);
            }
            if (objectToTest instanceof double[]) {
                return this.append(fieldName, (double[])lhs, (double[])rhs);
            }
            if (objectToTest instanceof float[]) {
                return this.append(fieldName, (float[])lhs, (float[])rhs);
            }
            if (objectToTest instanceof int[]) {
                return this.append(fieldName, (int[])lhs, (int[])rhs);
            }
            if (objectToTest instanceof long[]) {
                return this.append(fieldName, (long[])lhs, (long[])rhs);
            }
            if (objectToTest instanceof short[]) {
                return this.append(fieldName, (short[])lhs, (short[])rhs);
            }
            return this.append(fieldName, (Object[])lhs, (Object[])rhs);
        }
        if (lhs != null && lhs.equals(rhs)) {
            return this;
        }
        this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        return this;
    }

    public DiffBuilder append(String fieldName, Object[] lhs, Object[] rhs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lhs, rhs)) {
            this.diffs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        return this;
    }

    public DiffBuilder append(String fieldName, DiffResult diffResult) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (diffResult == null) {
            throw new IllegalArgumentException("Diff result cannot be null");
        }
        if (this.objectsTriviallyEqual) {
            return this;
        }
        for (Diff diff : diffResult.getDiffs()) {
            this.append(fieldName + "." + diff.getFieldName(), diff.getLeft(), diff.getRight());
        }
        return this;
    }

    public DiffResult build() {
        return new DiffResult(this.left, this.right, this.diffs, this.style);
    }
}

