/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.event.EventUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventUtils {
    public static <L> void addEventListener(Object eventSource, Class<L> listenerType, L listener) {
        try {
            MethodUtils.invokeMethod((Object)eventSource, (String)("add" + listenerType.getSimpleName()), (Object[])new Object[]{listener});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + eventSource.getClass().getName() + " does not have a public add" + listenerType.getSimpleName() + " method which takes a parameter of type " + listenerType.getName() + ".");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class " + eventSource.getClass().getName() + " does not have an accessible add" + listenerType.getSimpleName() + " method which takes a parameter of type " + listenerType.getName() + ".");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to add listener.", e.getCause());
        }
    }

    public static <L> void bindEventsToMethod(Object target, String methodName, Object eventSource, Class<L> listenerType, String ... eventTypes) {
        L listener = listenerType.cast(Proxy.newProxyInstance(target.getClass().getClassLoader(), new Class[]{listenerType}, (InvocationHandler)new EventBindingInvocationHandler(target, methodName, eventTypes)));
        EventUtils.addEventListener((Object)eventSource, listenerType, listener);
    }
}

