/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements ExceptionContext,
Serializable {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList();

    public DefaultExceptionContext addContextValue(String label, Object value) {
        this.contextValues.add(new ImmutablePair((Object)label, value));
        return this;
    }

    public DefaultExceptionContext setContextValue(String label, Object value) {
        Iterator iter = this.contextValues.iterator();
        while (iter.hasNext()) {
            Pair p = (Pair)iter.next();
            if (!StringUtils.equals((CharSequence)label, (CharSequence)((CharSequence)p.getKey()))) continue;
            iter.remove();
        }
        this.addContextValue(label, value);
        return this;
    }

    public List<Object> getContextValues(String label) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Pair pair : this.contextValues) {
            if (!StringUtils.equals((CharSequence)label, (CharSequence)((CharSequence)pair.getKey()))) continue;
            values.add(pair.getValue());
        }
        return values;
    }

    public Object getFirstContextValue(String label) {
        for (Pair pair : this.contextValues) {
            if (!StringUtils.equals((CharSequence)label, (CharSequence)((CharSequence)pair.getKey()))) continue;
            return pair.getValue();
        }
        return null;
    }

    public Set<String> getContextLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (Pair pair : this.contextValues) {
            labels.add((String)pair.getKey());
        }
        return labels;
    }

    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    public String getFormattedExceptionMessage(String baseMessage) {
        StringBuilder buffer = new StringBuilder(256);
        if (baseMessage != null) {
            buffer.append(baseMessage);
        }
        if (this.contextValues.size() > 0) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append("Exception Context:\n");
            int i = 0;
            for (Pair pair : this.contextValues) {
                buffer.append("\t[");
                buffer.append(++i);
                buffer.append(':');
                buffer.append((String)pair.getKey());
                buffer.append("=");
                Object value = pair.getValue();
                if (value == null) {
                    buffer.append("null");
                } else {
                    String valueStr;
                    try {
                        valueStr = value.toString();
                    }
                    catch (Exception e) {
                        valueStr = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace((Throwable)e);
                    }
                    buffer.append(valueStr);
                }
                buffer.append("]\n");
            }
            buffer.append("---------------------------------");
        }
        return buffer.toString();
    }
}

