/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConstructorUtils {
    public static <T> T invokeConstructor(Class<T> cls, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])args);
        return (T)ConstructorUtils.invokeConstructor(cls, (Object[])args, (Class[])parameterTypes);
    }

    public static <T> T invokeConstructor(Class<T> cls, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Constructor ctor = ConstructorUtils.getMatchingAccessibleConstructor(cls, (Class[])(parameterTypes = ArrayUtils.nullToEmpty((Class[])parameterTypes)));
        if (ctor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + cls.getName());
        }
        if (ctor.isVarArgs()) {
            Class[] methodParameterTypes = ctor.getParameterTypes();
            args = MethodUtils.getVarArgs((Object[])args, (Class[])methodParameterTypes);
        }
        return ctor.newInstance(args);
    }

    public static <T> T invokeExactConstructor(Class<T> cls, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])args);
        return (T)ConstructorUtils.invokeExactConstructor(cls, (Object[])args, (Class[])parameterTypes);
    }

    public static <T> T invokeExactConstructor(Class<T> cls, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Constructor ctor = ConstructorUtils.getAccessibleConstructor(cls, (Class[])(parameterTypes = ArrayUtils.nullToEmpty((Class[])parameterTypes)));
        if (ctor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + cls.getName());
        }
        return ctor.newInstance(args);
    }

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Validate.notNull(cls, (String)"class cannot be null", (Object[])new Object[0]);
        try {
            return ConstructorUtils.getAccessibleConstructor(cls.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> ctor) {
        Validate.notNull(ctor, (String)"constructor cannot be null", (Object[])new Object[0]);
        return MemberUtils.isAccessible(ctor) && ConstructorUtils.isAccessible(ctor.getDeclaringClass()) ? ctor : null;
    }

    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Validate.notNull(cls, (String)"class cannot be null", (Object[])new Object[0]);
        try {
            Constructor<T> ctor = cls.getConstructor(parameterTypes);
            MemberUtils.setAccessibleWorkaround(ctor);
            return ctor;
        }
        catch (NoSuchMethodException ctor) {
            Constructor<?>[] ctors;
            Constructor result = null;
            for (Constructor<?> constructor : ctors = cls.getConstructors()) {
                Constructor constructor2;
                Constructor constructor3;
                if (!MemberUtils.isMatchingConstructor(constructor, (Class[])parameterTypes) || (constructor3 = ConstructorUtils.getAccessibleConstructor(constructor)) == null) continue;
                MemberUtils.setAccessibleWorkaround((AccessibleObject)constructor3);
                if (result != null && MemberUtils.compareConstructorFit((Constructor)constructor3, result, (Class[])parameterTypes) >= 0) continue;
                result = constructor2 = constructor3;
            }
            return result;
        }
    }

    private static boolean isAccessible(Class<?> type) {
        for (Class<?> cls = type; cls != null; cls = cls.getEnclosingClass()) {
            if (Modifier.isPublic(cls.getModifiers())) continue;
            return false;
        }
        return true;
    }
}

