/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FieldUtils {
    public static Field getField(Class<?> cls, String fieldName) {
        Field field = FieldUtils.getField(cls, (String)fieldName, (boolean)false);
        MemberUtils.setAccessibleWorkaround((AccessibleObject)field);
        return field;
    }

    public static Field getField(Class<?> cls, String fieldName, boolean forceAccess) {
        Validate.isTrue((cls != null ? 1 : 0) != 0, (String)"The class must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)fieldName), (String)"The field name must not be blank/empty", (Object[])new Object[0]);
        for (Class<?> acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field = acls.getDeclaredField(fieldName);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!forceAccess) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        Field match = null;
        for (Class class1 : ClassUtils.getAllInterfaces(cls)) {
            try {
                Field test = class1.getField(fieldName);
                Validate.isTrue((match == null ? 1 : 0) != 0, (String)"Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", (Object[])new Object[]{fieldName, cls});
                match = test;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return match;
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName) {
        return FieldUtils.getDeclaredField(cls, (String)fieldName, (boolean)false);
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName, boolean forceAccess) {
        Validate.isTrue((cls != null ? 1 : 0) != 0, (String)"The class must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)fieldName), (String)"The field name must not be blank/empty", (Object[])new Object[0]);
        try {
            Field field = cls.getDeclaredField(fieldName);
            if (!MemberUtils.isAccessible((Member)field)) {
                if (forceAccess) {
                    field.setAccessible(true);
                } else {
                    return null;
                }
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field[] getAllFields(Class<?> cls) {
        List allFieldsList = FieldUtils.getAllFieldsList(cls);
        return allFieldsList.toArray(new Field[allFieldsList.size()]);
    }

    public static List<Field> getAllFieldsList(Class<?> cls) {
        Validate.isTrue((cls != null ? 1 : 0) != 0, (String)"The class must not be null", (Object[])new Object[0]);
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = currentClass.getDeclaredFields()) {
                allFields.add(field);
            }
        }
        return allFields;
    }

    public static Field[] getFieldsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        List annotatedFieldsList = FieldUtils.getFieldsListWithAnnotation(cls, annotationCls);
        return annotatedFieldsList.toArray(new Field[annotatedFieldsList.size()]);
    }

    public static List<Field> getFieldsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        Validate.isTrue((annotationCls != null ? 1 : 0) != 0, (String)"The annotation class must not be null", (Object[])new Object[0]);
        List allFields = FieldUtils.getAllFieldsList(cls);
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : allFields) {
            if (field.getAnnotation(annotationCls) == null) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static Object readStaticField(Field field) throws IllegalAccessException {
        return FieldUtils.readStaticField((Field)field, (boolean)false);
    }

    public static Object readStaticField(Field field, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"The field must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)Modifier.isStatic(field.getModifiers()), (String)"The field '%s' is not static", (Object[])new Object[]{field.getName()});
        return FieldUtils.readField((Field)field, null, (boolean)forceAccess);
    }

    public static Object readStaticField(Class<?> cls, String fieldName) throws IllegalAccessException {
        return FieldUtils.readStaticField(cls, (String)fieldName, (boolean)false);
    }

    public static Object readStaticField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Field field = FieldUtils.getField(cls, (String)fieldName, (boolean)forceAccess);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate field '%s' on %s", (Object[])new Object[]{fieldName, cls});
        return FieldUtils.readStaticField((Field)field, (boolean)false);
    }

    public static Object readDeclaredStaticField(Class<?> cls, String fieldName) throws IllegalAccessException {
        return FieldUtils.readDeclaredStaticField(cls, (String)fieldName, (boolean)false);
    }

    public static Object readDeclaredStaticField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Field field = FieldUtils.getDeclaredField(cls, (String)fieldName, (boolean)forceAccess);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate declared field %s.%s", (Object[])new Object[]{cls.getName(), fieldName});
        return FieldUtils.readStaticField((Field)field, (boolean)false);
    }

    public static Object readField(Field field, Object target) throws IllegalAccessException {
        return FieldUtils.readField((Field)field, (Object)target, (boolean)false);
    }

    public static Object readField(Field field, Object target, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"The field must not be null", (Object[])new Object[0]);
        if (forceAccess && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround((AccessibleObject)field);
        }
        return field.get(target);
    }

    public static Object readField(Object target, String fieldName) throws IllegalAccessException {
        return FieldUtils.readField((Object)target, (String)fieldName, (boolean)false);
    }

    public static Object readField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue((target != null ? 1 : 0) != 0, (String)"target object must not be null", (Object[])new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getField(cls, (String)fieldName, (boolean)forceAccess);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate field %s on %s", (Object[])new Object[]{fieldName, cls});
        return FieldUtils.readField((Field)field, (Object)target, (boolean)false);
    }

    public static Object readDeclaredField(Object target, String fieldName) throws IllegalAccessException {
        return FieldUtils.readDeclaredField((Object)target, (String)fieldName, (boolean)false);
    }

    public static Object readDeclaredField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue((target != null ? 1 : 0) != 0, (String)"target object must not be null", (Object[])new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getDeclaredField(cls, (String)fieldName, (boolean)forceAccess);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate declared field %s.%s", (Object[])new Object[]{cls, fieldName});
        return FieldUtils.readField((Field)field, (Object)target, (boolean)false);
    }

    public static void writeStaticField(Field field, Object value) throws IllegalAccessException {
        FieldUtils.writeStaticField((Field)field, (Object)value, (boolean)false);
    }

    public static void writeStaticField(Field field, Object value, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"The field must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)Modifier.isStatic(field.getModifiers()), (String)"The field %s.%s is not static", (Object[])new Object[]{field.getDeclaringClass().getName(), field.getName()});
        FieldUtils.writeField((Field)field, null, (Object)value, (boolean)forceAccess);
    }

    public static void writeStaticField(Class<?> cls, String fieldName, Object value) throws IllegalAccessException {
        FieldUtils.writeStaticField(cls, (String)fieldName, (Object)value, (boolean)false);
    }

    public static void writeStaticField(Class<?> cls, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        Field field = FieldUtils.getField(cls, (String)fieldName, (boolean)forceAccess);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate field %s on %s", (Object[])new Object[]{fieldName, cls});
        FieldUtils.writeStaticField((Field)field, (Object)value, (boolean)false);
    }

    public static void writeDeclaredStaticField(Class<?> cls, String fieldName, Object value) throws IllegalAccessException {
        FieldUtils.writeDeclaredStaticField(cls, (String)fieldName, (Object)value, (boolean)false);
    }

    public static void writeDeclaredStaticField(Class<?> cls, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        Field field = FieldUtils.getDeclaredField(cls, (String)fieldName, (boolean)forceAccess);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate declared field %s.%s", (Object[])new Object[]{cls.getName(), fieldName});
        FieldUtils.writeField((Field)field, null, (Object)value, (boolean)false);
    }

    public static void writeField(Field field, Object target, Object value) throws IllegalAccessException {
        FieldUtils.writeField((Field)field, (Object)target, (Object)value, (boolean)false);
    }

    public static void writeField(Field field, Object target, Object value, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"The field must not be null", (Object[])new Object[0]);
        if (forceAccess && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround((AccessibleObject)field);
        }
        field.set(target, value);
    }

    public static void removeFinalModifier(Field field) {
        FieldUtils.removeFinalModifier((Field)field, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFinalModifier(Field field, boolean forceAccess) {
        block8: {
            Validate.isTrue((field != null ? 1 : 0) != 0, (String)"The field must not be null", (Object[])new Object[0]);
            try {
                boolean doForceAccess;
                if (!Modifier.isFinal(field.getModifiers())) break block8;
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                boolean bl = doForceAccess = forceAccess && !modifiersField.isAccessible();
                if (doForceAccess) {
                    modifiersField.setAccessible(true);
                }
                try {
                    modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                }
                finally {
                    if (doForceAccess) {
                        modifiersField.setAccessible(false);
                    }
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static void writeField(Object target, String fieldName, Object value) throws IllegalAccessException {
        FieldUtils.writeField((Object)target, (String)fieldName, (Object)value, (boolean)false);
    }

    public static void writeField(Object target, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue((target != null ? 1 : 0) != 0, (String)"target object must not be null", (Object[])new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getField(cls, (String)fieldName, (boolean)forceAccess);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate declared field %s.%s", (Object[])new Object[]{cls.getName(), fieldName});
        FieldUtils.writeField((Field)field, (Object)target, (Object)value, (boolean)false);
    }

    public static void writeDeclaredField(Object target, String fieldName, Object value) throws IllegalAccessException {
        FieldUtils.writeDeclaredField((Object)target, (String)fieldName, (Object)value, (boolean)false);
    }

    public static void writeDeclaredField(Object target, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        Validate.isTrue((target != null ? 1 : 0) != 0, (String)"target object must not be null", (Object[])new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getDeclaredField(cls, (String)fieldName, (boolean)forceAccess);
        Validate.isTrue((field != null ? 1 : 0) != 0, (String)"Cannot locate declared field %s.%s", (Object[])new Object[]{cls.getName(), fieldName});
        FieldUtils.writeField((Field)field, (Object)target, (Object)value, (boolean)false);
    }
}

