/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MethodUtils {
    public static Object invokeMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod((Object)object, (String)methodName, (Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod((Object)object, (boolean)forceAccess, (String)methodName, (Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])args);
        return MethodUtils.invokeMethod((Object)object, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])args);
        return MethodUtils.invokeMethod((Object)object, (boolean)forceAccess, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        parameterTypes = ArrayUtils.nullToEmpty((Class[])parameterTypes);
        args = ArrayUtils.nullToEmpty((Object[])args);
        AccessibleObject method = null;
        boolean isOriginallyAccessible = false;
        Object result = null;
        try {
            String messagePrefix;
            if (forceAccess) {
                messagePrefix = "No such method: ";
                method = MethodUtils.getMatchingMethod(object.getClass(), (String)methodName, (Class[])parameterTypes);
                if (method != null && !(isOriginallyAccessible = method.isAccessible())) {
                    ((Method)method).setAccessible(true);
                }
            } else {
                messagePrefix = "No such accessible method: ";
                method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), (String)methodName, (Class[])parameterTypes);
            }
            if (method == null) {
                throw new NoSuchMethodException(messagePrefix + methodName + "() on object: " + object.getClass().getName());
            }
            args = MethodUtils.toVarArgs((Method)method, (Object[])args);
            result = ((Method)method).invoke(object, args);
        }
        finally {
            if (method != null && forceAccess && method.isAccessible() != isOriginallyAccessible) {
                ((Method)method).setAccessible(isOriginallyAccessible);
            }
        }
        return result;
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeMethod((Object)object, (boolean)false, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodUtils.invokeExactMethod((Object)object, (String)methodName, (Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])args);
        return MethodUtils.invokeExactMethod((Object)object, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        parameterTypes = ArrayUtils.nullToEmpty((Class[])parameterTypes);
        Method method = MethodUtils.getAccessibleMethod(object.getClass(), (String)methodName, (Class[])parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Method method = MethodUtils.getAccessibleMethod(cls, (String)methodName, (Class[])(parameterTypes = ArrayUtils.nullToEmpty((Class[])parameterTypes)));
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        return method.invoke(null, args);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])args);
        return MethodUtils.invokeStaticMethod(cls, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Method method = MethodUtils.getMatchingAccessibleMethod(cls, (String)methodName, (Class[])(parameterTypes = ArrayUtils.nullToEmpty((Class[])parameterTypes)));
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        args = MethodUtils.toVarArgs((Method)method, (Object[])args);
        return method.invoke(null, args);
    }

    private static Object[] toVarArgs(Method method, Object[] args) {
        if (method.isVarArgs()) {
            Class[] methodParameterTypes = method.getParameterTypes();
            args = MethodUtils.getVarArgs((Object[])args, (Class[])methodParameterTypes);
        }
        return args;
    }

    static Object[] getVarArgs(Object[] args, Class<?>[] methodParameterTypes) {
        if (args.length == methodParameterTypes.length && args[args.length - 1].getClass().equals(methodParameterTypes[methodParameterTypes.length - 1])) {
            return args;
        }
        Object[] newArgs = new Object[methodParameterTypes.length];
        System.arraycopy(args, 0, newArgs, 0, methodParameterTypes.length - 1);
        Class<?> varArgComponentType = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
        int varArgLength = args.length - methodParameterTypes.length + 1;
        Object varArgsArray = Array.newInstance(ClassUtils.primitiveToWrapper(varArgComponentType), varArgLength);
        System.arraycopy(args, methodParameterTypes.length - 1, varArgsArray, 0, varArgLength);
        if (varArgComponentType.isPrimitive()) {
            varArgsArray = ArrayUtils.toPrimitive((Object)varArgsArray);
        }
        newArgs[methodParameterTypes.length - 1] = varArgsArray;
        return newArgs;
    }

    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])args);
        return MethodUtils.invokeExactStaticMethod(cls, (String)methodName, (Object[])args, (Class[])parameterTypes);
    }

    public static Method getAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            return MethodUtils.getAccessibleMethod((Method)cls.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        Class[] parameterTypes;
        if (!MemberUtils.isAccessible((Member)method)) {
            return null;
        }
        Class<?> cls = method.getDeclaringClass();
        if (Modifier.isPublic(cls.getModifiers())) {
            return method;
        }
        String methodName = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(cls, (String)methodName, (Class[])(parameterTypes = method.getParameterTypes()))) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(cls, (String)methodName, (Class[])parameterTypes);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> parentClass = cls.getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            if (!Modifier.isPublic(parentClass.getModifiers())) continue;
            try {
                return parentClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                try {
                    return interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], (String)methodName, (Class[])parameterTypes);
                    if (method == null) continue;
                    return method;
                }
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = cls.getMethod(methodName, parameterTypes);
            MemberUtils.setAccessibleWorkaround((AccessibleObject)method);
            return method;
        }
        catch (NoSuchMethodException method) {
            Method[] methods;
            Method bestMatch = null;
            for (Method method2 : methods = cls.getMethods()) {
                Method accessibleMethod;
                if (!method2.getName().equals(methodName) || !MemberUtils.isMatchingMethod((Method)method2, (Class[])parameterTypes) || (accessibleMethod = MethodUtils.getAccessibleMethod((Method)method2)) == null || bestMatch != null && MemberUtils.compareMethodFit((Method)accessibleMethod, (Method)bestMatch, (Class[])parameterTypes) >= 0) continue;
                bestMatch = accessibleMethod;
            }
            if (bestMatch != null) {
                MemberUtils.setAccessibleWorkaround(bestMatch);
            }
            return bestMatch;
        }
    }

    public static Method getMatchingMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Validate.notNull(cls, (String)"Null class not allowed.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)methodName, (String)"Null or blank methodName not allowed.", (Object[])new Object[0]);
        Object[] methodArray = cls.getDeclaredMethods();
        List superclassList = ClassUtils.getAllSuperclasses(cls);
        for (Class klass : superclassList) {
            methodArray = (Method[])ArrayUtils.addAll((Object[])methodArray, (Object[])klass.getDeclaredMethods());
        }
        Object inexactMatch = null;
        for (Object method : methodArray) {
            if (methodName.equals(((Method)method).getName()) && ArrayUtils.isEquals(parameterTypes, ((Method)method).getParameterTypes())) {
                return method;
            }
            if (!methodName.equals(((Method)method).getName()) || !ClassUtils.isAssignable((Class[])parameterTypes, (Class[])((Method)method).getParameterTypes(), (boolean)true)) continue;
            if (inexactMatch == null) {
                inexactMatch = method;
                continue;
            }
            if (MethodUtils.distance((Class[])parameterTypes, (Class[])((Method)method).getParameterTypes()) >= MethodUtils.distance((Class[])parameterTypes, (Class[])((Method)inexactMatch).getParameterTypes())) continue;
            inexactMatch = method;
        }
        return inexactMatch;
    }

    private static int distance(Class<?>[] classArray, Class<?>[] toClassArray) {
        int answer = 0;
        if (!ClassUtils.isAssignable((Class[])classArray, (Class[])toClassArray, (boolean)true)) {
            return -1;
        }
        for (int offset = 0; offset < classArray.length; ++offset) {
            if (classArray[offset].equals(toClassArray[offset])) continue;
            if (ClassUtils.isAssignable(classArray[offset], toClassArray[offset], (boolean)true) && !ClassUtils.isAssignable(classArray[offset], toClassArray[offset], (boolean)false)) {
                ++answer;
                continue;
            }
            answer += 2;
        }
        return answer;
    }

    public static Set<Method> getOverrideHierarchy(Method method, ClassUtils.Interfaces interfacesBehavior) {
        Validate.notNull((Object)method);
        LinkedHashSet<Method> result = new LinkedHashSet<Method>();
        result.add(method);
        Object[] parameterTypes = method.getParameterTypes();
        Class<?> declaringClass = method.getDeclaringClass();
        Iterator hierarchy = ClassUtils.hierarchy(declaringClass, (ClassUtils.Interfaces)interfacesBehavior).iterator();
        hierarchy.next();
        block0: while (hierarchy.hasNext()) {
            Class c = (Class)hierarchy.next();
            Method m = MethodUtils.getMatchingAccessibleMethod((Class)c, (String)method.getName(), (Class[])parameterTypes);
            if (m == null) continue;
            if (Arrays.equals(m.getParameterTypes(), parameterTypes)) {
                result.add(m);
                continue;
            }
            Map typeArguments = TypeUtils.getTypeArguments(declaringClass, m.getDeclaringClass());
            for (int i = 0; i < parameterTypes.length; ++i) {
                Type parentType;
                Type childType = TypeUtils.unrollVariables((Map)typeArguments, (Type)method.getGenericParameterTypes()[i]);
                if (!TypeUtils.equals((Type)childType, (Type)(parentType = TypeUtils.unrollVariables((Map)typeArguments, (Type)m.getGenericParameterTypes()[i])))) continue block0;
            }
            result.add(m);
        }
        return result;
    }

    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        List annotatedMethodsList = MethodUtils.getMethodsListWithAnnotation(cls, annotationCls);
        return annotatedMethodsList.toArray(new Method[annotatedMethodsList.size()]);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        Validate.isTrue((cls != null ? 1 : 0) != 0, (String)"The class must not be null", (Object[])new Object[0]);
        Validate.isTrue((annotationCls != null ? 1 : 0) != 0, (String)"The annotation class must not be null", (Object[])new Object[0]);
        Method[] allMethods = cls.getMethods();
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (method.getAnnotation(annotationCls) == null) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }
}

