/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.reflect.Typed;

/*
 * Exception performing whole class analysis ignored.
 */
public class TypeUtils {
    public static final WildcardType WILDCARD_ALL = TypeUtils.wildcardType().withUpperBounds(new Type[]{Object.class}).build();

    public static boolean isAssignable(Type type, Type toType) {
        return TypeUtils.isAssignable((Type)type, (Type)toType, null);
    }

    private static boolean isAssignable(Type type, Type toType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (toType == null || toType instanceof Class) {
            return TypeUtils.isAssignable((Type)type, (Class)((Class)toType));
        }
        if (toType instanceof ParameterizedType) {
            return TypeUtils.isAssignable((Type)type, (ParameterizedType)((ParameterizedType)toType), typeVarAssigns);
        }
        if (toType instanceof GenericArrayType) {
            return TypeUtils.isAssignable((Type)type, (GenericArrayType)((GenericArrayType)toType), typeVarAssigns);
        }
        if (toType instanceof WildcardType) {
            return TypeUtils.isAssignable((Type)type, (WildcardType)((WildcardType)toType), typeVarAssigns);
        }
        if (toType instanceof TypeVariable) {
            return TypeUtils.isAssignable((Type)type, (TypeVariable)((TypeVariable)toType), typeVarAssigns);
        }
        throw new IllegalStateException("found an unhandled type: " + toType);
    }

    private static boolean isAssignable(Type type, Class<?> toClass) {
        if (type == null) {
            return toClass == null || !toClass.isPrimitive();
        }
        if (toClass == null) {
            return false;
        }
        if (toClass.equals(type)) {
            return true;
        }
        if (type instanceof Class) {
            return ClassUtils.isAssignable((Class)((Class)type), toClass);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.isAssignable((Type)TypeUtils.getRawType((ParameterizedType)((ParameterizedType)type)), toClass);
        }
        if (type instanceof TypeVariable) {
            for (Type bound : ((TypeVariable)type).getBounds()) {
                if (!TypeUtils.isAssignable((Type)bound, toClass)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof GenericArrayType) {
            return toClass.equals(Object.class) || toClass.isArray() && TypeUtils.isAssignable((Type)((GenericArrayType)type).getGenericComponentType(), toClass.getComponentType());
        }
        if (type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static boolean isAssignable(Type type, ParameterizedType toParameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toParameterizedType == null) {
            return false;
        }
        if (toParameterizedType.equals(type)) {
            return true;
        }
        Class toClass = TypeUtils.getRawType((ParameterizedType)toParameterizedType);
        Map fromTypeVarAssigns = TypeUtils.getTypeArguments((Type)type, (Class)toClass, null);
        if (fromTypeVarAssigns == null) {
            return false;
        }
        if (fromTypeVarAssigns.isEmpty()) {
            return true;
        }
        Map toTypeVarAssigns = TypeUtils.getTypeArguments((ParameterizedType)toParameterizedType, (Class)toClass, typeVarAssigns);
        for (TypeVariable var : toTypeVarAssigns.keySet()) {
            Type toTypeArg = TypeUtils.unrollVariableAssignments((TypeVariable)var, (Map)toTypeVarAssigns);
            Type fromTypeArg = TypeUtils.unrollVariableAssignments((TypeVariable)var, (Map)fromTypeVarAssigns);
            if (toTypeArg == null && fromTypeArg instanceof Class || fromTypeArg == null || toTypeArg.equals(fromTypeArg) || toTypeArg instanceof WildcardType && TypeUtils.isAssignable((Type)fromTypeArg, (Type)toTypeArg, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    private static Type unrollVariableAssignments(TypeVariable<?> var, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type result;
        while ((result = typeVarAssigns.get(var)) instanceof TypeVariable && !result.equals(var)) {
            var = (TypeVariable)result;
        }
        return result;
    }

    private static boolean isAssignable(Type type, GenericArrayType toGenericArrayType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toGenericArrayType == null) {
            return false;
        }
        if (toGenericArrayType.equals(type)) {
            return true;
        }
        Type toComponentType = toGenericArrayType.getGenericComponentType();
        if (type instanceof Class) {
            Class cls = (Class)type;
            return cls.isArray() && TypeUtils.isAssignable(cls.getComponentType(), (Type)toComponentType, typeVarAssigns);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.isAssignable((Type)((GenericArrayType)type).getGenericComponentType(), (Type)toComponentType, typeVarAssigns);
        }
        if (type instanceof WildcardType) {
            for (Type bound : TypeUtils.getImplicitUpperBounds((WildcardType)((WildcardType)type))) {
                if (!TypeUtils.isAssignable((Type)bound, (Type)toGenericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof TypeVariable) {
            for (Type bound : TypeUtils.getImplicitBounds((TypeVariable)((TypeVariable)type))) {
                if (!TypeUtils.isAssignable((Type)bound, (Type)toGenericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static boolean isAssignable(Type type, WildcardType toWildcardType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toWildcardType == null) {
            return false;
        }
        if (toWildcardType.equals(type)) {
            return true;
        }
        Type[] toUpperBounds = TypeUtils.getImplicitUpperBounds((WildcardType)toWildcardType);
        Type[] toLowerBounds = TypeUtils.getImplicitLowerBounds((WildcardType)toWildcardType);
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = TypeUtils.getImplicitUpperBounds((WildcardType)wildcardType);
            Type[] lowerBounds = TypeUtils.getImplicitLowerBounds((WildcardType)wildcardType);
            for (Type toBound : toUpperBounds) {
                toBound = TypeUtils.substituteTypeVariables((Type)toBound, typeVarAssigns);
                for (Type bound : upperBounds) {
                    if (TypeUtils.isAssignable((Type)bound, (Type)toBound, typeVarAssigns)) continue;
                    return false;
                }
            }
            for (Type toBound : toLowerBounds) {
                toBound = TypeUtils.substituteTypeVariables((Type)toBound, typeVarAssigns);
                for (Type bound : lowerBounds) {
                    if (TypeUtils.isAssignable((Type)toBound, (Type)bound, typeVarAssigns)) continue;
                    return false;
                }
            }
            return true;
        }
        for (Type toBound : toUpperBounds) {
            if (TypeUtils.isAssignable((Type)type, (Type)TypeUtils.substituteTypeVariables((Type)toBound, typeVarAssigns), typeVarAssigns)) continue;
            return false;
        }
        for (Type toBound : toLowerBounds) {
            if (TypeUtils.isAssignable((Type)TypeUtils.substituteTypeVariables((Type)toBound, typeVarAssigns), (Type)type, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Type type, TypeVariable<?> toTypeVariable, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toTypeVariable == null) {
            return false;
        }
        if (toTypeVariable.equals(type)) {
            return true;
        }
        if (type instanceof TypeVariable) {
            Type[] bounds;
            for (Type bound : bounds = TypeUtils.getImplicitBounds((TypeVariable)((TypeVariable)type))) {
                if (!TypeUtils.isAssignable((Type)bound, toTypeVariable, typeVarAssigns)) continue;
                return true;
            }
        }
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static Type substituteTypeVariables(Type type, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type instanceof TypeVariable && typeVarAssigns != null) {
            Type replacementType = typeVarAssigns.get(type);
            if (replacementType == null) {
                throw new IllegalArgumentException("missing assignment type for type variable " + type);
            }
            return replacementType;
        }
        return type;
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType type) {
        return TypeUtils.getTypeArguments((ParameterizedType)type, (Class)TypeUtils.getRawType((ParameterizedType)type), null);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass) {
        return TypeUtils.getTypeArguments((Type)type, toClass, null);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        if (type instanceof Class) {
            return TypeUtils.getTypeArguments((Class)((Class)type), toClass, subtypeVarAssigns);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getTypeArguments((ParameterizedType)((ParameterizedType)type), toClass, subtypeVarAssigns);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.getTypeArguments((Type)((GenericArrayType)type).getGenericComponentType(), toClass.isArray() ? toClass.getComponentType() : toClass, subtypeVarAssigns);
        }
        if (type instanceof WildcardType) {
            for (Type bound : TypeUtils.getImplicitUpperBounds((WildcardType)((WildcardType)type))) {
                if (!TypeUtils.isAssignable((Type)bound, toClass)) continue;
                return TypeUtils.getTypeArguments((Type)bound, toClass, subtypeVarAssigns);
            }
            return null;
        }
        if (type instanceof TypeVariable) {
            for (Type bound : TypeUtils.getImplicitBounds((TypeVariable)((TypeVariable)type))) {
                if (!TypeUtils.isAssignable((Type)bound, toClass)) continue;
                return TypeUtils.getTypeArguments((Type)bound, toClass, subtypeVarAssigns);
            }
            return null;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        HashMap<TypeVariable<?>, Type> typeVarAssigns;
        Class cls = TypeUtils.getRawType((ParameterizedType)parameterizedType);
        if (!TypeUtils.isAssignable((Type)cls, toClass)) {
            return null;
        }
        Type ownerType = parameterizedType.getOwnerType();
        if (ownerType instanceof ParameterizedType) {
            ParameterizedType parameterizedOwnerType = (ParameterizedType)ownerType;
            typeVarAssigns = TypeUtils.getTypeArguments((ParameterizedType)parameterizedOwnerType, (Class)TypeUtils.getRawType((ParameterizedType)parameterizedOwnerType), subtypeVarAssigns);
        } else {
            typeVarAssigns = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
        }
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeParams = cls.getTypeParameters();
        for (int i = 0; i < typeParams.length; ++i) {
            Type typeArg = typeArgs[i];
            typeVarAssigns.put(typeParams[i], typeVarAssigns.containsKey(typeArg) ? (Type)typeVarAssigns.get(typeArg) : typeArg);
        }
        if (toClass.equals(cls)) {
            return typeVarAssigns;
        }
        return TypeUtils.getTypeArguments((Type)TypeUtils.getClosestParentType((Class)cls, toClass), toClass, typeVarAssigns);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(Class<?> cls, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        HashMap typeVarAssigns;
        if (!TypeUtils.isAssignable(cls, toClass)) {
            return null;
        }
        if (cls.isPrimitive()) {
            if (toClass.isPrimitive()) {
                return new HashMap();
            }
            cls = ClassUtils.primitiveToWrapper(cls);
        }
        HashMap hashMap = typeVarAssigns = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
        if (toClass.equals(cls)) {
            return typeVarAssigns;
        }
        return TypeUtils.getTypeArguments((Type)TypeUtils.getClosestParentType((Class)cls, toClass), toClass, typeVarAssigns);
    }

    public static Map<TypeVariable<?>, Type> determineTypeArguments(Class<?> cls, ParameterizedType superType) {
        Validate.notNull(cls, (String)"cls is null", (Object[])new Object[0]);
        Validate.notNull((Object)superType, (String)"superType is null", (Object[])new Object[0]);
        Class superClass = TypeUtils.getRawType((ParameterizedType)superType);
        if (!TypeUtils.isAssignable(cls, (Class)superClass)) {
            return null;
        }
        if (cls.equals(superClass)) {
            return TypeUtils.getTypeArguments((ParameterizedType)superType, (Class)superClass, null);
        }
        Type midType = TypeUtils.getClosestParentType(cls, (Class)superClass);
        if (midType instanceof Class) {
            return TypeUtils.determineTypeArguments((Class)((Class)midType), (ParameterizedType)superType);
        }
        ParameterizedType midParameterizedType = (ParameterizedType)midType;
        Class midClass = TypeUtils.getRawType((ParameterizedType)midParameterizedType);
        Map typeVarAssigns = TypeUtils.determineTypeArguments((Class)midClass, (ParameterizedType)superType);
        TypeUtils.mapTypeVariablesToArguments(cls, (ParameterizedType)midParameterizedType, (Map)typeVarAssigns);
        return typeVarAssigns;
    }

    private static <T> void mapTypeVariablesToArguments(Class<T> cls, ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type ownerType = parameterizedType.getOwnerType();
        if (ownerType instanceof ParameterizedType) {
            TypeUtils.mapTypeVariablesToArguments(cls, (ParameterizedType)((ParameterizedType)ownerType), typeVarAssigns);
        }
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeVars = TypeUtils.getRawType((ParameterizedType)parameterizedType).getTypeParameters();
        List<TypeVariable<Class<T>>> typeVarList = Arrays.asList(cls.getTypeParameters());
        for (int i = 0; i < typeArgs.length; ++i) {
            TypeVariable typeVar = typeVars[i];
            Type typeArg = typeArgs[i];
            if (!typeVarList.contains(typeArg) || !typeVarAssigns.containsKey(typeVar)) continue;
            typeVarAssigns.put((TypeVariable)typeArg, typeVarAssigns.get(typeVar));
        }
    }

    private static Type getClosestParentType(Class<?> cls, Class<?> superClass) {
        if (superClass.isInterface()) {
            Type[] interfaceTypes = cls.getGenericInterfaces();
            Type genericInterface = null;
            for (Type midType : interfaceTypes) {
                Class midClass = null;
                if (midType instanceof ParameterizedType) {
                    midClass = TypeUtils.getRawType((ParameterizedType)((ParameterizedType)midType));
                } else if (midType instanceof Class) {
                    midClass = (Class)midType;
                } else {
                    throw new IllegalStateException("Unexpected generic interface type found: " + midType);
                }
                if (!TypeUtils.isAssignable((Type)midClass, superClass) || !TypeUtils.isAssignable(genericInterface, (Type)midClass)) continue;
                genericInterface = midType;
            }
            if (genericInterface != null) {
                return genericInterface;
            }
        }
        return cls.getGenericSuperclass();
    }

    public static boolean isInstance(Object value, Type type) {
        if (type == null) {
            return false;
        }
        return value == null ? !(type instanceof Class) || !((Class)type).isPrimitive() : TypeUtils.isAssignable(value.getClass(), (Type)type, null);
    }

    public static Type[] normalizeUpperBounds(Type[] bounds) {
        Validate.notNull((Object)bounds, (String)"null value specified for bounds array", (Object[])new Object[0]);
        if (bounds.length < 2) {
            return bounds;
        }
        HashSet<Type> types = new HashSet<Type>(bounds.length);
        for (Type type1 : bounds) {
            boolean subtypeFound = false;
            for (Type type2 : bounds) {
                if (type1 == type2 || !TypeUtils.isAssignable((Type)type2, (Type)type1, null)) continue;
                subtypeFound = true;
                break;
            }
            if (subtypeFound) continue;
            types.add(type1);
        }
        return types.toArray(new Type[types.size()]);
    }

    public static Type[] getImplicitBounds(TypeVariable<?> typeVariable) {
        Type[] typeArray;
        Validate.notNull(typeVariable, (String)"typeVariable is null", (Object[])new Object[0]);
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        } else {
            typeArray = TypeUtils.normalizeUpperBounds((Type[])bounds);
        }
        return typeArray;
    }

    public static Type[] getImplicitUpperBounds(WildcardType wildcardType) {
        Type[] typeArray;
        Validate.notNull((Object)wildcardType, (String)"wildcardType is null", (Object[])new Object[0]);
        Type[] bounds = wildcardType.getUpperBounds();
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        } else {
            typeArray = TypeUtils.normalizeUpperBounds((Type[])bounds);
        }
        return typeArray;
    }

    public static Type[] getImplicitLowerBounds(WildcardType wildcardType) {
        Type[] typeArray;
        Validate.notNull((Object)wildcardType, (String)"wildcardType is null", (Object[])new Object[0]);
        Type[] bounds = wildcardType.getLowerBounds();
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = null;
        } else {
            typeArray = bounds;
        }
        return typeArray;
    }

    public static boolean typesSatisfyVariables(Map<TypeVariable<?>, Type> typeVarAssigns) {
        Validate.notNull(typeVarAssigns, (String)"typeVarAssigns is null", (Object[])new Object[0]);
        for (Map.Entry<TypeVariable<?>, Type> entry : typeVarAssigns.entrySet()) {
            TypeVariable<?> typeVar = entry.getKey();
            Type type = entry.getValue();
            for (Type bound : TypeUtils.getImplicitBounds(typeVar)) {
                if (TypeUtils.isAssignable((Type)type, (Type)TypeUtils.substituteTypeVariables((Type)bound, typeVarAssigns), typeVarAssigns)) continue;
                return false;
            }
        }
        return true;
    }

    private static Class<?> getRawType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class)) {
            throw new IllegalStateException("Wait... What!? Type of rawType: " + rawType);
        }
        return (Class)rawType;
    }

    public static Class<?> getRawType(Type type, Type assigningType) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getRawType((ParameterizedType)((ParameterizedType)type));
        }
        if (type instanceof TypeVariable) {
            if (assigningType == null) {
                return null;
            }
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (!(genericDeclaration instanceof Class)) {
                return null;
            }
            Map typeVarAssigns = TypeUtils.getTypeArguments((Type)assigningType, (Class)((Class)genericDeclaration));
            if (typeVarAssigns == null) {
                return null;
            }
            Type typeArgument = (Type)typeVarAssigns.get(type);
            if (typeArgument == null) {
                return null;
            }
            return TypeUtils.getRawType((Type)typeArgument, (Type)assigningType);
        }
        if (type instanceof GenericArrayType) {
            Class rawComponentType = TypeUtils.getRawType((Type)((GenericArrayType)type).getGenericComponentType(), (Type)assigningType);
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        if (type instanceof WildcardType) {
            return null;
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    public static boolean isArrayType(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    public static Type getArrayComponentType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() ? clazz.getComponentType() : null;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return null;
    }

    public static Type unrollVariables(Map<TypeVariable<?>, Type> typeArguments, Type type) {
        if (typeArguments == null) {
            typeArguments = Collections.emptyMap();
        }
        if (TypeUtils.containsTypeVariables((Type)type)) {
            if (type instanceof TypeVariable) {
                return TypeUtils.unrollVariables(typeArguments, (Type)typeArguments.get(type));
            }
            if (type instanceof ParameterizedType) {
                Map<TypeVariable<Object>, Type> parameterizedTypeArguments;
                ParameterizedType p = (ParameterizedType)type;
                if (p.getOwnerType() == null) {
                    parameterizedTypeArguments = typeArguments;
                } else {
                    parameterizedTypeArguments = new HashMap<TypeVariable<Object>, Type>(typeArguments);
                    parameterizedTypeArguments.putAll(TypeUtils.getTypeArguments((ParameterizedType)p));
                }
                Type[] args = p.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type unrolled = TypeUtils.unrollVariables(parameterizedTypeArguments, (Type)args[i]);
                    if (unrolled == null) continue;
                    args[i] = unrolled;
                }
                return TypeUtils.parameterizeWithOwner((Type)p.getOwnerType(), (Class)((Class)p.getRawType()), (Type[])args);
            }
            if (type instanceof WildcardType) {
                WildcardType wild = (WildcardType)type;
                return TypeUtils.wildcardType().withUpperBounds(TypeUtils.unrollBounds(typeArguments, (Type[])wild.getUpperBounds())).withLowerBounds(TypeUtils.unrollBounds(typeArguments, (Type[])wild.getLowerBounds())).build();
            }
        }
        return type;
    }

    private static Type[] unrollBounds(Map<TypeVariable<?>, Type> typeArguments, Type[] bounds) {
        Object[] result = bounds;
        for (int i = 0; i < result.length; ++i) {
            Type unrolled = TypeUtils.unrollVariables(typeArguments, (Type)result[i]);
            if (unrolled == null) {
                result = (Type[])ArrayUtils.remove((Object[])result, (int)i--);
                continue;
            }
            result[i] = unrolled;
        }
        return result;
    }

    public static boolean containsTypeVariables(Type type) {
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof Class) {
            return ((Class)type).getTypeParameters().length > 0;
        }
        if (type instanceof ParameterizedType) {
            for (Type arg : ((ParameterizedType)type).getActualTypeArguments()) {
                if (!TypeUtils.containsTypeVariables((Type)arg)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof WildcardType) {
            WildcardType wild = (WildcardType)type;
            return TypeUtils.containsTypeVariables((Type)TypeUtils.getImplicitLowerBounds((WildcardType)wild)[0]) || TypeUtils.containsTypeVariables((Type)TypeUtils.getImplicitUpperBounds((WildcardType)wild)[0]);
        }
        return false;
    }

    public static final ParameterizedType parameterize(Class<?> raw, Type ... typeArguments) {
        return TypeUtils.parameterizeWithOwner(null, raw, (Type[])typeArguments);
    }

    public static final ParameterizedType parameterize(Class<?> raw, Map<TypeVariable<?>, Type> typeArgMappings) {
        Validate.notNull(raw, (String)"raw class is null", (Object[])new Object[0]);
        Validate.notNull(typeArgMappings, (String)"typeArgMappings is null", (Object[])new Object[0]);
        return TypeUtils.parameterizeWithOwner(null, raw, (Type[])TypeUtils.extractTypeArgumentsFrom(typeArgMappings, (TypeVariable[])raw.getTypeParameters()));
    }

    public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> raw, Type ... typeArguments) {
        Type useOwner;
        Validate.notNull(raw, (String)"raw class is null", (Object[])new Object[0]);
        if (raw.getEnclosingClass() == null) {
            Validate.isTrue((owner == null ? 1 : 0) != 0, (String)"no owner allowed for top-level %s", (Object[])new Object[]{raw});
            useOwner = null;
        } else if (owner == null) {
            useOwner = raw.getEnclosingClass();
        } else {
            Validate.isTrue((boolean)TypeUtils.isAssignable((Type)owner, raw.getEnclosingClass()), (String)"%s is invalid owner type for parameterized %s", (Object[])new Object[]{owner, raw});
            useOwner = owner;
        }
        Validate.noNullElements((Object[])typeArguments, (String)"null type argument at index %s", (Object[])new Object[0]);
        Validate.isTrue((raw.getTypeParameters().length == typeArguments.length ? 1 : 0) != 0, (String)"invalid number of type parameters specified: expected %d, got %d", (Object[])new Object[]{raw.getTypeParameters().length, typeArguments.length});
        return new ParameterizedTypeImpl(raw, useOwner, typeArguments, null);
    }

    public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> raw, Map<TypeVariable<?>, Type> typeArgMappings) {
        Validate.notNull(raw, (String)"raw class is null", (Object[])new Object[0]);
        Validate.notNull(typeArgMappings, (String)"typeArgMappings is null", (Object[])new Object[0]);
        return TypeUtils.parameterizeWithOwner((Type)owner, raw, (Type[])TypeUtils.extractTypeArgumentsFrom(typeArgMappings, (TypeVariable[])raw.getTypeParameters()));
    }

    private static Type[] extractTypeArgumentsFrom(Map<TypeVariable<?>, Type> mappings, TypeVariable<?>[] variables) {
        Type[] result = new Type[variables.length];
        int index = 0;
        for (TypeVariable<?> var : variables) {
            Validate.isTrue((boolean)mappings.containsKey(var), (String)"missing argument mapping for %s", (Object[])new Object[]{TypeUtils.toString(var)});
            result[index++] = mappings.get(var);
        }
        return result;
    }

    public static WildcardTypeBuilder wildcardType() {
        return new WildcardTypeBuilder(null);
    }

    public static GenericArrayType genericArrayType(Type componentType) {
        return new GenericArrayTypeImpl((Type)Validate.notNull((Object)componentType, (String)"componentType is null", (Object[])new Object[0]), null);
    }

    public static boolean equals(Type t1, Type t2) {
        if (ObjectUtils.equals((Object)t1, (Object)t2)) {
            return true;
        }
        if (t1 instanceof ParameterizedType) {
            return TypeUtils.equals((ParameterizedType)((ParameterizedType)t1), (Type)t2);
        }
        if (t1 instanceof GenericArrayType) {
            return TypeUtils.equals((GenericArrayType)((GenericArrayType)t1), (Type)t2);
        }
        if (t1 instanceof WildcardType) {
            return TypeUtils.equals((WildcardType)((WildcardType)t1), (Type)t2);
        }
        return false;
    }

    private static boolean equals(ParameterizedType p, Type t) {
        if (t instanceof ParameterizedType) {
            ParameterizedType other = (ParameterizedType)t;
            if (TypeUtils.equals((Type)p.getRawType(), (Type)other.getRawType()) && TypeUtils.equals((Type)p.getOwnerType(), (Type)other.getOwnerType())) {
                return TypeUtils.equals((Type[])p.getActualTypeArguments(), (Type[])other.getActualTypeArguments());
            }
        }
        return false;
    }

    private static boolean equals(GenericArrayType a, Type t) {
        return t instanceof GenericArrayType && TypeUtils.equals((Type)a.getGenericComponentType(), (Type)((GenericArrayType)t).getGenericComponentType());
    }

    private static boolean equals(WildcardType w, Type t) {
        if (t instanceof WildcardType) {
            WildcardType other = (WildcardType)t;
            return TypeUtils.equals((Type[])TypeUtils.getImplicitLowerBounds((WildcardType)w), (Type[])TypeUtils.getImplicitLowerBounds((WildcardType)other)) && TypeUtils.equals((Type[])TypeUtils.getImplicitUpperBounds((WildcardType)w), (Type[])TypeUtils.getImplicitUpperBounds((WildcardType)other));
        }
        return false;
    }

    private static boolean equals(Type[] t1, Type[] t2) {
        if (t1.length == t2.length) {
            for (int i = 0; i < t1.length; ++i) {
                if (TypeUtils.equals((Type)t1[i], (Type)t2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String toString(Type type) {
        Validate.notNull((Object)type);
        if (type instanceof Class) {
            return TypeUtils.classToString((Class)((Class)type));
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.parameterizedTypeToString((ParameterizedType)((ParameterizedType)type));
        }
        if (type instanceof WildcardType) {
            return TypeUtils.wildcardTypeToString((WildcardType)((WildcardType)type));
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.typeVariableToString((TypeVariable)((TypeVariable)type));
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.genericArrayTypeToString((GenericArrayType)((GenericArrayType)type));
        }
        throw new IllegalArgumentException(ObjectUtils.identityToString((Object)type));
    }

    public static String toLongString(TypeVariable<?> var) {
        StringBuilder buf;
        block5: {
            Validate.notNull(var, (String)"var is null", (Object[])new Object[0]);
            buf = new StringBuilder();
            Object d = var.getGenericDeclaration();
            if (d instanceof Class) {
                Class<?> c = (Class<?>)d;
                while (true) {
                    if (c.getEnclosingClass() == null) {
                        buf.insert(0, c.getName());
                        break block5;
                    }
                    buf.insert(0, c.getSimpleName()).insert(0, '.');
                    c = c.getEnclosingClass();
                }
            }
            if (d instanceof Type) {
                buf.append(TypeUtils.toString((Type)((Type)d)));
            } else {
                buf.append(d);
            }
        }
        return buf.append(':').append(TypeUtils.typeVariableToString(var)).toString();
    }

    public static <T> Typed<T> wrap(Type type) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <T> Typed<T> wrap(Class<T> type) {
        return TypeUtils.wrap(type);
    }

    private static String classToString(Class<?> c) {
        StringBuilder buf = new StringBuilder();
        if (c.getEnclosingClass() != null) {
            buf.append(TypeUtils.classToString(c.getEnclosingClass())).append('.').append(c.getSimpleName());
        } else {
            buf.append(c.getName());
        }
        if (c.getTypeParameters().length > 0) {
            buf.append('<');
            TypeUtils.appendAllTo((StringBuilder)buf, (String)", ", (Type[])c.getTypeParameters());
            buf.append('>');
        }
        return buf.toString();
    }

    private static String typeVariableToString(TypeVariable<?> v) {
        StringBuilder buf = new StringBuilder(v.getName());
        Type[] bounds = v.getBounds();
        if (!(bounds.length <= 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]))) {
            buf.append(" extends ");
            TypeUtils.appendAllTo((StringBuilder)buf, (String)" & ", (Type[])v.getBounds());
        }
        return buf.toString();
    }

    private static String parameterizedTypeToString(ParameterizedType p) {
        StringBuilder buf = new StringBuilder();
        Type useOwner = p.getOwnerType();
        Class raw = (Class)p.getRawType();
        Type[] typeArguments = p.getActualTypeArguments();
        if (useOwner == null) {
            buf.append(raw.getName());
        } else {
            if (useOwner instanceof Class) {
                buf.append(((Class)useOwner).getName());
            } else {
                buf.append(useOwner.toString());
            }
            buf.append('.').append(raw.getSimpleName());
        }
        TypeUtils.appendAllTo((StringBuilder)buf.append('<'), (String)", ", (Type[])typeArguments).append('>');
        return buf.toString();
    }

    private static String wildcardTypeToString(WildcardType w) {
        StringBuilder buf = new StringBuilder().append('?');
        Type[] lowerBounds = w.getLowerBounds();
        Type[] upperBounds = w.getUpperBounds();
        if (lowerBounds.length > 1 || lowerBounds.length == 1 && lowerBounds[0] != null) {
            TypeUtils.appendAllTo((StringBuilder)buf.append(" super "), (String)" & ", (Type[])lowerBounds);
        } else if (upperBounds.length > 1 || upperBounds.length == 1 && !Object.class.equals((Object)upperBounds[0])) {
            TypeUtils.appendAllTo((StringBuilder)buf.append(" extends "), (String)" & ", (Type[])upperBounds);
        }
        return buf.toString();
    }

    private static String genericArrayTypeToString(GenericArrayType g) {
        return String.format("%s[]", TypeUtils.toString((Type)g.getGenericComponentType()));
    }

    private static StringBuilder appendAllTo(StringBuilder buf, String sep, Type ... types) {
        Validate.notEmpty((Object[])Validate.noNullElements((Object[])types));
        if (types.length > 0) {
            buf.append(TypeUtils.toString((Type)types[0]));
            for (int i = 1; i < types.length; ++i) {
                buf.append(sep).append(TypeUtils.toString((Type)types[i]));
            }
        }
        return buf;
    }

    static /* synthetic */ boolean access$100(GenericArrayType x0, Type x1) {
        return TypeUtils.equals((GenericArrayType)x0, (Type)x1);
    }

    static /* synthetic */ boolean access$200(ParameterizedType x0, Type x1) {
        return TypeUtils.equals((ParameterizedType)x0, (Type)x1);
    }

    static /* synthetic */ boolean access$300(WildcardType x0, Type x1) {
        return TypeUtils.equals((WildcardType)x0, (Type)x1);
    }
}

