/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.exception.ExceptionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
class CalendarReflection {
    private static final Method IS_WEEK_DATE_SUPPORTED = CalendarReflection.getCalendarMethod((String)"isWeekDateSupported", (Class[])new Class[0]);
    private static final Method GET_WEEK_YEAR = CalendarReflection.getCalendarMethod((String)"getWeekYear", (Class[])new Class[0]);

    CalendarReflection() {
    }

    private static Method getCalendarMethod(String methodName, Class<?> ... argTypes) {
        try {
            Method m = Calendar.class.getMethod(methodName, argTypes);
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    static boolean isWeekDateSupported(Calendar calendar) {
        try {
            return IS_WEEK_DATE_SUPPORTED != null && (Boolean)IS_WEEK_DATE_SUPPORTED.invoke((Object)calendar, new Object[0]) != false;
        }
        catch (Exception e) {
            return (Boolean)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static int getWeekYear(Calendar calendar) {
        try {
            if (CalendarReflection.isWeekDateSupported((Calendar)calendar)) {
                return (Integer)GET_WEEK_YEAR.invoke((Object)calendar, new Object[0]);
            }
        }
        catch (Exception e) {
            return (Integer)ExceptionUtils.rethrow((Throwable)e);
        }
        int year = calendar.get(1);
        if (IS_WEEK_DATE_SUPPORTED == null && calendar instanceof GregorianCalendar) {
            switch (calendar.get(2)) {
                case 0: {
                    if (calendar.get(3) < 52) break;
                    --year;
                    break;
                }
                case 11: {
                    if (calendar.get(3) != 1) break;
                    ++year;
                }
            }
        }
        return year;
    }
}

