/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.client;

import com.alibaba.cloudapi.sdk.client.BaseApiClient;
import com.alibaba.cloudapi.sdk.enums.HttpConnectionModel;
import com.alibaba.cloudapi.sdk.exception.SdkException;
import com.alibaba.cloudapi.sdk.model.ApiCallback;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.model.ApiResponse;
import com.alibaba.cloudapi.sdk.model.HttpClientBuilderParams;
import com.alibaba.cloudapi.sdk.util.ApiRequestMaker;
import com.alibaba.cloudapi.sdk.util.HttpCommonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttp3Client
extends BaseApiClient {
    OkHttpClient client;

    protected OkHttp3Client() {
    }

    public void init(HttpClientBuilderParams buildParam) {
        if (null == buildParam) {
            throw new SdkException("buildParam must not be null");
        }
        buildParam.check();
        this.appKey = buildParam.getAppKey();
        this.appSecret = buildParam.getAppSecret();
        this.host = buildParam.getHost();
        this.scheme = buildParam.getScheme();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (null != buildParam.getX509TrustManager() && null != buildParam.getSslSocketFactory()) {
            builder.sslSocketFactory(buildParam.getSslSocketFactory(), buildParam.getX509TrustManager());
        }
        if (null != buildParam.getHostnameVerifier()) {
            builder.hostnameVerifier(buildParam.getHostnameVerifier());
        }
        ConnectionPool connectionPool = new ConnectionPool(buildParam.getMaxIdleConnections(), buildParam.getMaxIdleTimeMillis(), TimeUnit.MILLISECONDS);
        Dispatcher dispatcher = null != buildParam.getExecutorService() ? new Dispatcher(buildParam.getExecutorService()) : new Dispatcher();
        if (null != buildParam.getIdleCallback()) {
            dispatcher.setIdleCallback(buildParam.getIdleCallback());
        }
        dispatcher.setMaxRequests(buildParam.getDispatchMaxRequests());
        dispatcher.setMaxRequestsPerHost(buildParam.getDispatchMaxRequestsPerHost());
        this.client = builder.connectionPool(connectionPool).dispatcher(dispatcher).readTimeout(buildParam.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout(buildParam.getWriteTimeout(), TimeUnit.MILLISECONDS).connectTimeout(buildParam.getConnectionTimeout(), TimeUnit.MILLISECONDS).build();
    }

    @Override
    public ApiResponse sendSyncRequest(ApiRequest apiRequest) {
        Request request = this.buildRequest(apiRequest);
        Call call = this.client.newCall(request);
        try {
            return this.getApiResponse(apiRequest, call.execute());
        }
        catch (IOException ex) {
            return new ApiResponse(500, "Read response occur error", ex);
        }
    }

    @Override
    public void sendAsyncRequest(final ApiRequest apiRequest, final ApiCallback apiCallback) {
        Request request = this.buildRequest(apiRequest);
        final long start = System.currentTimeMillis();
        Call call = this.client.newCall(request);
        Callback callback = new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                apiCallback.onFailure(apiRequest, e);
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                long latency = System.currentTimeMillis() - start;
                ApiResponse apiResponse = OkHttp3Client.this.getApiResponse(apiRequest, response);
                apiResponse.addHeader("X-CA-LATENCY", String.valueOf(latency));
                apiCallback.onResponse(apiRequest, apiResponse);
            }
        };
        call.enqueue(callback);
    }

    private Request buildRequest(ApiRequest request) {
        if (request.getHttpConnectionMode() == HttpConnectionModel.SINGER_CONNECTION) {
            request.setHost(this.host);
            request.setScheme(this.scheme);
        }
        ApiRequestMaker.make(request, this.appKey, this.appSecret);
        RequestBody requestBody = null;
        if (null != request.getFormParams() && request.getFormParams().size() > 0) {
            requestBody = RequestBody.create(MediaType.parse(request.getFirstHeaderValue("content-type")), HttpCommonUtil.buildParamString(request.getFormParams()));
        } else if (null != request.getBody() && request.getBody().length > 0) {
            requestBody = RequestBody.create(MediaType.parse(request.getFirstHeaderValue("content-type")), request.getBody());
        }
        return new Request.Builder().method(request.getMethod().getValue(), requestBody).url(request.getUrl()).headers(this.getHeadersFromMap(request.getHeaders())).build();
    }

    private Headers getHeadersFromMap(Map<String, List<String>> map) {
        ArrayList<String> nameAndValues = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            for (String value : entry.getValue()) {
                nameAndValues.add(entry.getKey());
                nameAndValues.add(value);
            }
        }
        return Headers.of(nameAndValues.toArray(new String[nameAndValues.size()]));
    }

    private ApiResponse getApiResponse(ApiRequest request, Response response) throws IOException {
        ApiResponse apiResponse = new ApiResponse(response.code());
        apiResponse.setHeaders(response.headers().toMultimap());
        apiResponse.setBody(response.body().bytes());
        apiResponse.setContentType(response.header("content-type", ""));
        return apiResponse;
    }

    private Map<String, String> getSimpleMapFromRequest(Headers headers) {
        Map<String, List<String>> complexMap = headers.toMultimap();
        HashMap<String, String> simpleMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : complexMap.entrySet()) {
            simpleMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return simpleMap;
    }
}

