/*
 * Decompiled with CFR 0.152.
 */
package com.dataphin.jdbc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dataphin.jdbc.dto.OsResult;
import com.dataphin.jdbc.dto.ResultDTO;
import com.google.common.collect.Lists;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class Utils {
    private static final String CONTROLLER_PREFIX = "/os/api";
    private static final String JDBC_PREFIX = "jdcb:";
    static final String URL_PREFIX = "jdbc:dataphin://";
    static final String CONNECTION_PATH_PREFIX = "/connection";
    static final String CLOSE_SESSION_PATH_PREFIX = "/closeConnect";
    static final String QUERY_PATH_PREFIX = "/query";
    static final String STATE_PATH_PREFIX = "/state";
    static final String NEXT_PATH_PREFIX = "/next";
    static final String CLOSE_STATEMENT_PATH_PREFIX = "/closeStatement";
    public static final String USERNAME_KEY = "user";
    public static final String PASSWORD_KEY = "password";
    public static final String ACCOUNT_KEY = "user_id";
    public static final String DATABASE_KEY = "database";
    public static final String SESSION_ID_KEY = "sessionId";
    public static final String CATALOG_KEY = "catalog";
    public static final String ALLOW_FULL_SCAN = "allowFullScan";
    public static final int DEFAULT_PORT = 80;
    private static final List<String> TABLE_RESULT_FIELDS = Lists.newArrayList("TABLE_CAL", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION");
    private static final List<String> TABLE_RESULT_TYPES = Lists.newArrayList("String", "String", "String", "String", "String", "String", "String", "String", "String", "String");
    private static final List<String> COLUMN_RESULT_FIELDS = Lists.newArrayList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN");
    private static final List<String> COLUMN_RESULT_TYPES = Lists.newArrayList("String", "String", "String", "String", "int", "String", "int", "String", "int", "int", "int", "String", "String", "int", "int", "int", "int", "String", "String", "String", "String", "short", "String", "String");

    private static URI getURI(String url) {
        String cleanURI = url.substring(JDBC_PREFIX.length());
        return URI.create(cleanURI);
    }

    public static String getHost(String url) {
        return Utils.getURI(url).getHost();
    }

    public static String getDB(String url) {
        String path = Utils.getURI(url).getPath();
        return path.substring(1);
    }

    public static String buildPath(String ... subPath) {
        StringBuilder path = new StringBuilder(CONTROLLER_PREFIX);
        for (String sub : subPath) {
            if (sub.charAt(0) != '/') {
                path.append('/');
            }
            path.append(sub);
        }
        return path.toString();
    }

    public static Object getPort(String url) {
        return Utils.getURI(url).getPort() == -1 ? 80 : Utils.getURI(url).getPort();
    }

    public static int getJdbcType(String type) {
        switch (type) {
            case "integer": 
            case "int": {
                return 4;
            }
            case "date": {
                return 91;
            }
        }
        return 12;
    }

    public static Object evaluate(String type, Object value) throws SQLException {
        if (value == null) {
            return value;
        }
        switch (type) {
            case "java.lang.String": {
                return String.valueOf(value);
            }
            case "java.lang.Integer": {
                return Integer.valueOf(String.valueOf(value));
            }
            case "java.lang.Double": {
                return Double.valueOf(String.valueOf(value));
            }
            case "com.aliyun.odps.data.Varchar": {
                return JSON.parseObject(String.valueOf(value), Map.class).get("value");
            }
        }
        return value;
    }

    public static <T> boolean checkResult(ResultDTO<T> result, String action) throws SQLException {
        if (!result.isSuccess()) {
            throw new SQLException(action + " error: " + result.getMessage());
        }
        return true;
    }

    public static Properties getURLProperties(String url) {
        Properties properties = new Properties();
        List parameters = URLEncodedUtils.parse((URI)Utils.getURI(url), (String)"UTF-8");
        for (NameValuePair pair : parameters) {
            properties.put(pair.getName(), pair.getValue());
        }
        return properties;
    }

    public static OsResult convertTableResult(OsResult osResult, String catalog, String schemaPattern) {
        ArrayList<Object[]> records = Lists.newArrayList();
        for (Object[] record : osResult.getRecords()) {
            Object[] objects = Lists.newArrayList(catalog, schemaPattern, record[0], "", record[1], "", "", "", "", "", "").toArray();
            records.add(objects);
        }
        return OsResult.builder().columns(TABLE_RESULT_FIELDS).columnType(TABLE_RESULT_TYPES).records(records).type("sync").build();
    }

    public static OsResult convertSchemaResult(OsResult osResult, String catalog) {
        ArrayList<Object[]> records = Lists.newArrayList();
        for (Object[] record : osResult.getRecords()) {
            Object[] objects = Lists.newArrayList(record[0], catalog).toArray();
            records.add(objects);
        }
        return OsResult.builder().columns(Lists.newArrayList("TABLE_SCHEM", "TABLE_CATALOG")).columnType(Lists.newArrayList("string", "string")).records(records).type("sync").build();
    }

    public static OsResult convertColumnResult(OsResult osResult, String catalog, String schema, String table) {
        ArrayList<String> columns = Lists.newArrayList(COLUMN_RESULT_FIELDS);
        ArrayList<String> columnTypes = Lists.newArrayList(COLUMN_RESULT_TYPES);
        ArrayList<Object[]> records = Lists.newArrayList();
        for (Object[] record : osResult.getRecords()) {
            Object[] objects = Lists.newArrayList(catalog, schema, table, Utils.convertColumnName((String)record[0]), Utils.getJdbcType((String)((JSONObject)record[5]).get("type")), (String)((JSONObject)record[5]).get("type"), 0, "", 0, 0, 0, "", "", 0, 0, 0, 0, "", "", "", "", 0, "", "").toArray();
            records.add(objects);
        }
        return OsResult.builder().columns(columns).columnType(columnTypes).records(records).type("sync").build();
    }

    public static String convertColumnName(String columnName) {
        String[] split = columnName.split("\\.");
        if (split.length == 1) {
            return split[0];
        }
        StringBuilder name = new StringBuilder();
        for (int i = 1; i < split.length; ++i) {
            name.append(split[i]).append(".");
        }
        name.deleteCharAt(name.length() - 1);
        return name.toString();
    }

    public static String convertColumnNameAlias(String columnName) {
        return columnName.replaceAll("\\.", "_");
    }

    public static String convertLikeToRegex(String like) {
        return like.replace("%", ".*").replace("?", ".");
    }
}

