/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kernel.util;

import com.alipay.easysdk.kernel.AlipayConstants;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Base64;

public class AES {
    private static final String AES_ALG = "AES";
    private static final String AES_CBC_PCK_ALG = "AES/CBC/PKCS5Padding";
    private static final byte[] AES_IV = AES.initIV();

    public static String encrypt(String plainText, String key) {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AES_IV);
            cipher.init(1, (Key)new SecretKeySpec(Base64.decode(key.getBytes()), AES_ALG), iv);
            byte[] encryptBytes = cipher.doFinal(plainText.getBytes(AlipayConstants.DEFAULT_CHARSET));
            return new String(Base64.encode(encryptBytes));
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u52a0\u5bc6\u5931\u8d25\uff0cplainText=" + plainText + "\uff0ckeySize=" + key.length() + "\u3002" + e.getMessage(), e);
        }
    }

    public static String decrypt(String cipherText, String key) {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AES_IV);
            cipher.init(2, (Key)new SecretKeySpec(Base64.decode(key.getBytes()), AES_ALG), iv);
            byte[] cleanBytes = cipher.doFinal(Base64.decode(cipherText.getBytes()));
            return new String(cleanBytes, AlipayConstants.DEFAULT_CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException("AES\u89e3\u5bc6\u5931\u8d25\uff0ccipherText=" + cipherText + "\uff0ckeySize=" + key.length() + "\u3002" + e.getMessage(), e);
        }
    }

    private static byte[] initIV() {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            int blockSize = cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }
}

