/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.marketing.openlife;

import com.alipay.easysdk.marketing.openlife.models.AlipayOpenPublicLifeMsgRecallResponse;
import com.alipay.easysdk.marketing.openlife.models.AlipayOpenPublicMessageContentCreateResponse;
import com.alipay.easysdk.marketing.openlife.models.AlipayOpenPublicMessageContentModifyResponse;
import com.alipay.easysdk.marketing.openlife.models.AlipayOpenPublicMessageSingleSendResponse;
import com.alipay.easysdk.marketing.openlife.models.AlipayOpenPublicMessageTotalSendResponse;
import com.alipay.easysdk.marketing.openlife.models.AlipayOpenPublicSettingCategoryQueryResponse;
import com.alipay.easysdk.marketing.openlife.models.AlipayOpenPublicTemplateMessageIndustryModifyResponse;
import com.alipay.easysdk.marketing.openlife.models.Article;
import com.alipay.easysdk.marketing.openlife.models.Template;
import com.alipay.easysdk.marketing.openlife.models.Text;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Client {
    public com.alipay.easysdk.kernel.Client _kernel;

    public Client(com.alipay.easysdk.kernel.Client kernel) throws Exception {
        this._kernel = kernel;
    }

    public AlipayOpenPublicMessageContentCreateResponse createImageTextContent(String title, String cover, String content, String contentComment, String ctype, String benefit, String extTags, String loginIds) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.open.public.message.content.create"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("title", title), new TeaPair("cover", cover), new TeaPair("content", content), new TeaPair("could_comment", contentComment), new TeaPair("ctype", ctype), new TeaPair("benefit", benefit), new TeaPair("ext_tags", extTags), new TeaPair("login_ids", loginIds));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.open.public.message.content.create");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayOpenPublicMessageContentCreateResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayOpenPublicMessageContentModifyResponse modifyImageTextContent(String contentId, String title, String cover, String content, String couldComment, String ctype, String benefit, String extTags, String loginIds) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.open.public.message.content.modify"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("content_id", contentId), new TeaPair("title", title), new TeaPair("cover", cover), new TeaPair("content", content), new TeaPair("could_comment", couldComment), new TeaPair("ctype", ctype), new TeaPair("benefit", benefit), new TeaPair("ext_tags", extTags), new TeaPair("login_ids", loginIds));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.open.public.message.content.modify");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayOpenPublicMessageContentModifyResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayOpenPublicMessageTotalSendResponse sendText(String text) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.open.public.message.total.send"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Text textObj = Text.build(TeaConverter.buildMap(new TeaPair("title", ""), new TeaPair("content", text)));
                Map bizParams = TeaConverter.buildMap(new TeaPair("msg_type", "text"), new TeaPair("text", textObj));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.open.public.message.total.send");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayOpenPublicMessageTotalSendResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayOpenPublicMessageTotalSendResponse sendImageText(List<Article> articles) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.open.public.message.total.send"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("msg_type", "image-text"), new TeaPair("articles", articles));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.open.public.message.total.send");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayOpenPublicMessageTotalSendResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayOpenPublicMessageSingleSendResponse sendSingleMessage(String toUserId, Template template) throws Exception {
        TeaModel.validateParams(template, "template");
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.open.public.message.single.send"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("to_user_id", toUserId), new TeaPair("template", template));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.open.public.message.single.send");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayOpenPublicMessageSingleSendResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayOpenPublicLifeMsgRecallResponse recallMessage(String messageId) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.open.public.life.msg.recall"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("message_id", messageId));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.open.public.life.msg.recall");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayOpenPublicLifeMsgRecallResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayOpenPublicTemplateMessageIndustryModifyResponse setIndustry(String primaryIndustryCode, String primaryIndustryName, String secondaryIndustryCode, String secondaryIndustryName) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.open.public.template.message.industry.modify"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("primary_industry_code", primaryIndustryCode), new TeaPair("primary_industry_name", primaryIndustryName), new TeaPair("secondary_industry_code", secondaryIndustryCode), new TeaPair("secondary_industry_name", secondaryIndustryName));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.open.public.template.message.industry.modify");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayOpenPublicTemplateMessageIndustryModifyResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayOpenPublicSettingCategoryQueryResponse getIndustry() throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.open.public.setting.category.query"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                HashMap bizParams = new HashMap();
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.open.public.setting.category.query");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayOpenPublicSettingCategoryQueryResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public Client agent(String appAuthToken) {
        this._kernel.injectTextParam("app_auth_token", appAuthToken);
        return this;
    }

    public Client auth(String authToken) {
        this._kernel.injectTextParam("auth_token", authToken);
        return this;
    }

    public Client asyncNotify(String url) {
        this._kernel.injectTextParam("notify_url", url);
        return this;
    }

    public Client route(String testUrl) {
        this._kernel.injectTextParam("ws_service_url", testUrl);
        return this;
    }

    public Client optional(String key, Object value) {
        this._kernel.injectBizParam(key, value);
        return this;
    }

    public Client batchOptional(Map<String, Object> optionalArgs) {
        for (Map.Entry<String, Object> pair : optionalArgs.entrySet()) {
            this._kernel.injectBizParam(pair.getKey(), pair.getValue());
        }
        return this;
    }
}

