/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.marketing.pass;

import com.alipay.easysdk.marketing.pass.models.AlipayPassInstanceAddResponse;
import com.alipay.easysdk.marketing.pass.models.AlipayPassInstanceUpdateResponse;
import com.alipay.easysdk.marketing.pass.models.AlipayPassTemplateAddResponse;
import com.alipay.easysdk.marketing.pass.models.AlipayPassTemplateUpdateResponse;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import java.util.HashMap;
import java.util.Map;

public class Client {
    public com.alipay.easysdk.kernel.Client _kernel;

    public Client(com.alipay.easysdk.kernel.Client kernel) throws Exception {
        this._kernel = kernel;
    }

    public AlipayPassTemplateAddResponse createTemplate(String uniqueId, String tplContent) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.pass.template.add"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("unique_id", uniqueId), new TeaPair("tpl_content", tplContent));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.pass.template.add");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayPassTemplateAddResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayPassTemplateUpdateResponse updateTemplate(String tplId, String tplContent) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.pass.template.update"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("tpl_id", tplId), new TeaPair("tpl_content", tplContent));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.pass.template.update");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayPassTemplateUpdateResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayPassInstanceAddResponse addInstance(String tplId, String tplParams, String recognitionType, String recognitionInfo) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.pass.instance.add"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("tpl_id", tplId), new TeaPair("tpl_params", tplParams), new TeaPair("recognition_type", recognitionType), new TeaPair("recognition_info", recognitionInfo));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.pass.instance.add");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayPassInstanceAddResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayPassInstanceUpdateResponse updateInstance(String serialNumber, String channelId, String tplParams, String status, String verifyCode, String verifyType) throws Exception {
        Map<String, Object> runtime_ = TeaConverter.buildMap(new TeaPair("connectTimeout", 15000), new TeaPair("readTimeout", 15000), new TeaPair("retry", TeaConverter.buildMap(new TeaPair("maxAttempts", 0))));
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)runtime_.get("retry"), _retryTimes, _now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), _retryTimes)) > 0) {
                Tea.sleep(backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map<String, String> systemParams = TeaConverter.buildMap(new TeaPair("method", "alipay.pass.instance.update"), new TeaPair("app_id", this._kernel.getConfig("appId")), new TeaPair("timestamp", this._kernel.getTimestamp()), new TeaPair("format", "json"), new TeaPair("version", "1.0"), new TeaPair("alipay_sdk", this._kernel.getSdkVersion()), new TeaPair("charset", "UTF-8"), new TeaPair("sign_type", this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", this._kernel.getAlipayRootCertSN()));
                Map bizParams = TeaConverter.buildMap(new TeaPair("serial_number", serialNumber), new TeaPair("channel_id", channelId), new TeaPair("tpl_params", tplParams), new TeaPair("status", status), new TeaPair("verify_code", verifyCode), new TeaPair("verify_type", verifyType));
                HashMap<String, String> textParams = new HashMap<String, String>();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap(new TeaPair("host", this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", "application/x-www-form-urlencoded;charset=utf-8"));
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, TeaConverter.buildMap(new TeaPair("sign", this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))), systemParams, textParams));
                request_.body = Tea.toReadable(this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction(request_, runtime_);
                Map<String, Object> respMap = this._kernel.readAsJson(response_, "alipay.pass.instance.update");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return TeaModel.toModel(this._kernel.toRespModel(respMap), new AlipayPassInstanceUpdateResponse());
                }
                throw new TeaException(TeaConverter.buildMap(new TeaPair("message", "\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")));
            }
            catch (Exception e) {
                if (Tea.isRetryable(e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public Client agent(String appAuthToken) {
        this._kernel.injectTextParam("app_auth_token", appAuthToken);
        return this;
    }

    public Client auth(String authToken) {
        this._kernel.injectTextParam("auth_token", authToken);
        return this;
    }

    public Client asyncNotify(String url) {
        this._kernel.injectTextParam("notify_url", url);
        return this;
    }

    public Client route(String testUrl) {
        this._kernel.injectTextParam("ws_service_url", testUrl);
        return this;
    }

    public Client optional(String key, Object value) {
        this._kernel.injectBizParam(key, value);
        return this;
    }

    public Client batchOptional(Map<String, Object> optionalArgs) {
        for (Map.Entry<String, Object> pair : optionalArgs.entrySet()) {
            this._kernel.injectBizParam(pair.getKey(), pair.getValue());
        }
        return this;
    }
}

