/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.member.identification;

import com.alipay.easysdk.member.identification.models.AlipayUserCertifyOpenCertifyResponse;
import com.alipay.easysdk.member.identification.models.AlipayUserCertifyOpenInitializeResponse;
import com.alipay.easysdk.member.identification.models.AlipayUserCertifyOpenQueryResponse;
import com.alipay.easysdk.member.identification.models.IdentityParam;
import com.alipay.easysdk.member.identification.models.MerchantConfig;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import java.util.HashMap;
import java.util.Map;

public class Client {
    public com.alipay.easysdk.kernel.Client _kernel;

    public Client(com.alipay.easysdk.kernel.Client kernel) throws Exception {
        this._kernel = kernel;
    }

    public AlipayUserCertifyOpenInitializeResponse init(String outerOrderNo, String bizCode, IdentityParam identityParam, MerchantConfig merchantConfig) throws Exception {
        TeaModel.validateParams((TeaModel)identityParam, (String)"identityParam");
        TeaModel.validateParams((TeaModel)merchantConfig, (String)"merchantConfig");
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("ignoreSSL", (Object)this._kernel.getConfig("ignoreSSL")), new TeaPair("httpProxy", (Object)this._kernel.getConfig("httpProxy")), new TeaPair("connectTimeout", (Object)15000), new TeaPair("readTimeout", (Object)15000), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("maxAttempts", (Object)0)}))});
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map systemParams = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("method", (Object)"alipay.user.certify.open.initialize"), new TeaPair("app_id", (Object)this._kernel.getConfig("appId")), new TeaPair("timestamp", (Object)this._kernel.getTimestamp()), new TeaPair("format", (Object)"json"), new TeaPair("version", (Object)"1.0"), new TeaPair("alipay_sdk", (Object)this._kernel.getSdkVersion()), new TeaPair("charset", (Object)"UTF-8"), new TeaPair("sign_type", (Object)this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", (Object)this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", (Object)this._kernel.getAlipayRootCertSN())});
                Map bizParams = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("outer_order_no", (Object)outerOrderNo), new TeaPair("biz_code", (Object)bizCode), new TeaPair("identity_param", (Object)identityParam), new TeaPair("merchant_config", (Object)merchantConfig)});
                HashMap textParams = new HashMap();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", (Object)"application/x-www-form-urlencoded;charset=utf-8")});
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("sign", (Object)this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))}), systemParams, textParams}));
                request_.body = Tea.toReadable((byte[])this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                Map respMap = this._kernel.readAsJson(response_, "alipay.user.certify.open.initialize");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return (AlipayUserCertifyOpenInitializeResponse)TeaModel.toModel((Map)this._kernel.toRespModel(respMap), (TeaModel)new AlipayUserCertifyOpenInitializeResponse());
                }
                throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", (Object)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")}));
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) continue;
                throw new RuntimeException(e);
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayUserCertifyOpenQueryResponse query(String certifyId) throws Exception {
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("ignoreSSL", (Object)this._kernel.getConfig("ignoreSSL")), new TeaPair("httpProxy", (Object)this._kernel.getConfig("httpProxy")), new TeaPair("connectTimeout", (Object)15000), new TeaPair("readTimeout", (Object)15000), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("maxAttempts", (Object)0)}))});
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                Map systemParams = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("method", (Object)"alipay.user.certify.open.query"), new TeaPair("app_id", (Object)this._kernel.getConfig("appId")), new TeaPair("timestamp", (Object)this._kernel.getTimestamp()), new TeaPair("format", (Object)"json"), new TeaPair("version", (Object)"1.0"), new TeaPair("alipay_sdk", (Object)this._kernel.getSdkVersion()), new TeaPair("charset", (Object)"UTF-8"), new TeaPair("sign_type", (Object)this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", (Object)this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", (Object)this._kernel.getAlipayRootCertSN())});
                Map bizParams = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("certify_id", (Object)certifyId)});
                HashMap textParams = new HashMap();
                request_.protocol = this._kernel.getConfig("protocol");
                request_.method = "POST";
                request_.pathname = "/gateway.do";
                request_.headers = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)this._kernel.getConfig("gatewayHost")), new TeaPair("content-type", (Object)"application/x-www-form-urlencoded;charset=utf-8")});
                request_.query = this._kernel.sortMap(TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("sign", (Object)this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey")))}), systemParams, textParams}));
                request_.body = Tea.toReadable((byte[])this._kernel.toUrlEncodedRequestBody(bizParams));
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                Map respMap = this._kernel.readAsJson(response_, "alipay.user.certify.open.query");
                if (this._kernel.isCertMode() != false ? this._kernel.verify(respMap, this._kernel.extractAlipayPublicKey(this._kernel.getAlipayCertSN(respMap))) != false : this._kernel.verify(respMap, this._kernel.getConfig("alipayPublicKey")) != false) {
                    return (AlipayUserCertifyOpenQueryResponse)TeaModel.toModel((Map)this._kernel.toRespModel(respMap), (TeaModel)new AlipayUserCertifyOpenQueryResponse());
                }
                throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("message", (Object)"\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u5b9d\u516c\u94a5\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002")}));
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) continue;
                throw new RuntimeException(e);
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public AlipayUserCertifyOpenCertifyResponse certify(String certifyId) throws Exception {
        Map systemParams = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("method", (Object)"alipay.user.certify.open.certify"), new TeaPair("app_id", (Object)this._kernel.getConfig("appId")), new TeaPair("timestamp", (Object)this._kernel.getTimestamp()), new TeaPair("format", (Object)"json"), new TeaPair("version", (Object)"1.0"), new TeaPair("alipay_sdk", (Object)this._kernel.getSdkVersion()), new TeaPair("charset", (Object)"UTF-8"), new TeaPair("sign_type", (Object)this._kernel.getConfig("signType")), new TeaPair("app_cert_sn", (Object)this._kernel.getMerchantCertSN()), new TeaPair("alipay_root_cert_sn", (Object)this._kernel.getAlipayRootCertSN())});
        Map bizParams = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("certify_id", (Object)certifyId)});
        HashMap textParams = new HashMap();
        String sign = this._kernel.sign(systemParams, bizParams, textParams, this._kernel.getConfig("merchantPrivateKey"));
        Map response = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("body", (Object)this._kernel.generatePage("GET", systemParams, bizParams, textParams, sign))});
        return (AlipayUserCertifyOpenCertifyResponse)TeaModel.toModel((Map)response, (TeaModel)new AlipayUserCertifyOpenCertifyResponse());
    }

    public Client agent(String appAuthToken) {
        this._kernel.injectTextParam("app_auth_token", appAuthToken);
        return this;
    }

    public Client auth(String authToken) {
        this._kernel.injectTextParam("auth_token", authToken);
        return this;
    }

    public Client asyncNotify(String url) {
        this._kernel.injectTextParam("notify_url", url);
        return this;
    }

    public Client route(String testUrl) {
        this._kernel.injectTextParam("ws_service_url", testUrl);
        return this;
    }

    public Client optional(String key, Object value) {
        this._kernel.injectBizParam(key, value);
        return this;
    }

    public Client batchOptional(Map<String, Object> optionalArgs) {
        for (Map.Entry<String, Object> pair : optionalArgs.entrySet()) {
            this._kernel.injectBizParam(pair.getKey(), pair.getValue());
        }
        return this;
    }
}

