/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayFundAccountbookCreateDefaultResponse;
import com.alipay.v3.model.AlipayFundAccountbookCreateModel;
import com.alipay.v3.model.AlipayFundAccountbookCreateResponseModel;
import com.alipay.v3.model.AlipayFundAccountbookQueryDefaultResponse;
import com.alipay.v3.model.AlipayFundAccountbookQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayFundAccountbookApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayFundAccountbookApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayFundAccountbookApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCall(AlipayFundAccountbookCreateModel alipayFundAccountbookCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayFundAccountbookCreateModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayFundAccountbookCreateModel;
        String localVarPath = "/v3/alipay/fund/accountbook/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(AlipayFundAccountbookCreateModel alipayFundAccountbookCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createCall(alipayFundAccountbookCreateModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayFundAccountbookCreateResponseModel create(AlipayFundAccountbookCreateModel alipayFundAccountbookCreateModel) throws ApiException {
        ApiResponse<AlipayFundAccountbookCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayFundAccountbookCreateModel, null);
        return localVarResp.getData();
    }

    public AlipayFundAccountbookCreateResponseModel create(AlipayFundAccountbookCreateModel alipayFundAccountbookCreateModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayFundAccountbookCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayFundAccountbookCreateModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayFundAccountbookCreateResponseModel> createWithHttpInfo(AlipayFundAccountbookCreateModel alipayFundAccountbookCreateModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayFundAccountbookCreateModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayFundAccountbookCreateResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayFundAccountbookCreateDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call createAsync(AlipayFundAccountbookCreateModel alipayFundAccountbookCreateModel, ApiCallback<AlipayFundAccountbookCreateResponseModel> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayFundAccountbookCreateModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayFundAccountbookCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createAsync(AlipayFundAccountbookCreateModel alipayFundAccountbookCreateModel, ApiCallback<AlipayFundAccountbookCreateResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayFundAccountbookCreateModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayFundAccountbookCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String accountBookId, String merchantUserId, String sceneCode, String extInfo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/fund/accountbook/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountBookId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account_book_id", accountBookId));
        }
        if (merchantUserId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("merchant_user_id", merchantUserId));
        }
        if (sceneCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("scene_code", sceneCode));
        }
        if (extInfo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ext_info", extInfo));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String accountBookId, String merchantUserId, String sceneCode, String extInfo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(accountBookId, merchantUserId, sceneCode, extInfo, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayFundAccountbookQueryResponseModel query(String accountBookId, String merchantUserId, String sceneCode, String extInfo) throws ApiException {
        ApiResponse<AlipayFundAccountbookQueryResponseModel> localVarResp = this.queryWithHttpInfo(accountBookId, merchantUserId, sceneCode, extInfo, null);
        return localVarResp.getData();
    }

    public AlipayFundAccountbookQueryResponseModel query(String accountBookId, String merchantUserId, String sceneCode, String extInfo, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayFundAccountbookQueryResponseModel> localVarResp = this.queryWithHttpInfo(accountBookId, merchantUserId, sceneCode, extInfo, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayFundAccountbookQueryResponseModel> queryWithHttpInfo(String accountBookId, String merchantUserId, String sceneCode, String extInfo, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(accountBookId, merchantUserId, sceneCode, extInfo, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayFundAccountbookQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayFundAccountbookQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(String accountBookId, String merchantUserId, String sceneCode, String extInfo, ApiCallback<AlipayFundAccountbookQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(accountBookId, merchantUserId, sceneCode, extInfo, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayFundAccountbookQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(String accountBookId, String merchantUserId, String sceneCode, String extInfo, ApiCallback<AlipayFundAccountbookQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(accountBookId, merchantUserId, sceneCode, extInfo, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayFundAccountbookQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

