/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayMarketingCardDeleteDefaultResponse;
import com.alipay.v3.model.AlipayMarketingCardDeleteResponseModel;
import com.alipay.v3.model.AlipayMarketingCardOpenDefaultResponse;
import com.alipay.v3.model.AlipayMarketingCardOpenModel;
import com.alipay.v3.model.AlipayMarketingCardOpenResponseModel;
import com.alipay.v3.model.AlipayMarketingCardQueryDefaultResponse;
import com.alipay.v3.model.AlipayMarketingCardQueryModel;
import com.alipay.v3.model.AlipayMarketingCardQueryResponseModel;
import com.alipay.v3.model.AlipayMarketingCardUpdateDefaultResponse;
import com.alipay.v3.model.AlipayMarketingCardUpdateModel;
import com.alipay.v3.model.AlipayMarketingCardUpdateResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayMarketingCardApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayMarketingCardApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayMarketingCardApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteCall(String outSerialNo, String targetCardNo, String targetCardNoType, String reasonCode, String extInfo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/marketing/card/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (outSerialNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("out_serial_no", outSerialNo));
        }
        if (targetCardNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("target_card_no", targetCardNo));
        }
        if (targetCardNoType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("target_card_no_type", targetCardNoType));
        }
        if (reasonCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reason_code", reasonCode));
        }
        if (extInfo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ext_info", extInfo));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(String outSerialNo, String targetCardNo, String targetCardNoType, String reasonCode, String extInfo, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteCall(outSerialNo, targetCardNo, targetCardNoType, reasonCode, extInfo, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingCardDeleteResponseModel delete(String outSerialNo, String targetCardNo, String targetCardNoType, String reasonCode, String extInfo) throws ApiException {
        ApiResponse<AlipayMarketingCardDeleteResponseModel> localVarResp = this.deleteWithHttpInfo(outSerialNo, targetCardNo, targetCardNoType, reasonCode, extInfo, null);
        return localVarResp.getData();
    }

    public AlipayMarketingCardDeleteResponseModel delete(String outSerialNo, String targetCardNo, String targetCardNoType, String reasonCode, String extInfo, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingCardDeleteResponseModel> localVarResp = this.deleteWithHttpInfo(outSerialNo, targetCardNo, targetCardNoType, reasonCode, extInfo, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingCardDeleteResponseModel> deleteWithHttpInfo(String outSerialNo, String targetCardNo, String targetCardNoType, String reasonCode, String extInfo, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(outSerialNo, targetCardNo, targetCardNoType, reasonCode, extInfo, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingCardDeleteResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingCardDeleteDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call deleteAsync(String outSerialNo, String targetCardNo, String targetCardNoType, String reasonCode, String extInfo, ApiCallback<AlipayMarketingCardDeleteResponseModel> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(outSerialNo, targetCardNo, targetCardNoType, reasonCode, extInfo, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardDeleteResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAsync(String outSerialNo, String targetCardNo, String targetCardNoType, String reasonCode, String extInfo, ApiCallback<AlipayMarketingCardDeleteResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(outSerialNo, targetCardNo, targetCardNoType, reasonCode, extInfo, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardDeleteResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call openCall(String authToken, AlipayMarketingCardOpenModel alipayMarketingCardOpenModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayMarketingCardOpenModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayMarketingCardOpenModel;
        String localVarPath = "/v3/alipay/marketing/card/open";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (authToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("auth_token", authToken));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call openValidateBeforeCall(String authToken, AlipayMarketingCardOpenModel alipayMarketingCardOpenModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.openCall(authToken, alipayMarketingCardOpenModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingCardOpenResponseModel open(String authToken, AlipayMarketingCardOpenModel alipayMarketingCardOpenModel) throws ApiException {
        ApiResponse<AlipayMarketingCardOpenResponseModel> localVarResp = this.openWithHttpInfo(authToken, alipayMarketingCardOpenModel, null);
        return localVarResp.getData();
    }

    public AlipayMarketingCardOpenResponseModel open(String authToken, AlipayMarketingCardOpenModel alipayMarketingCardOpenModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingCardOpenResponseModel> localVarResp = this.openWithHttpInfo(authToken, alipayMarketingCardOpenModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingCardOpenResponseModel> openWithHttpInfo(String authToken, AlipayMarketingCardOpenModel alipayMarketingCardOpenModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.openValidateBeforeCall(authToken, alipayMarketingCardOpenModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingCardOpenResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingCardOpenDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call openAsync(String authToken, AlipayMarketingCardOpenModel alipayMarketingCardOpenModel, ApiCallback<AlipayMarketingCardOpenResponseModel> _callback) throws ApiException {
        Call localVarCall = this.openValidateBeforeCall(authToken, alipayMarketingCardOpenModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardOpenResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call openAsync(String authToken, AlipayMarketingCardOpenModel alipayMarketingCardOpenModel, ApiCallback<AlipayMarketingCardOpenResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.openValidateBeforeCall(authToken, alipayMarketingCardOpenModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardOpenResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(AlipayMarketingCardQueryModel alipayMarketingCardQueryModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayMarketingCardQueryModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayMarketingCardQueryModel;
        String localVarPath = "/v3/alipay/marketing/card/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(AlipayMarketingCardQueryModel alipayMarketingCardQueryModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(alipayMarketingCardQueryModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingCardQueryResponseModel query(AlipayMarketingCardQueryModel alipayMarketingCardQueryModel) throws ApiException {
        ApiResponse<AlipayMarketingCardQueryResponseModel> localVarResp = this.queryWithHttpInfo(alipayMarketingCardQueryModel, null);
        return localVarResp.getData();
    }

    public AlipayMarketingCardQueryResponseModel query(AlipayMarketingCardQueryModel alipayMarketingCardQueryModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingCardQueryResponseModel> localVarResp = this.queryWithHttpInfo(alipayMarketingCardQueryModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingCardQueryResponseModel> queryWithHttpInfo(AlipayMarketingCardQueryModel alipayMarketingCardQueryModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(alipayMarketingCardQueryModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingCardQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingCardQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(AlipayMarketingCardQueryModel alipayMarketingCardQueryModel, ApiCallback<AlipayMarketingCardQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(alipayMarketingCardQueryModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(AlipayMarketingCardQueryModel alipayMarketingCardQueryModel, ApiCallback<AlipayMarketingCardQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(alipayMarketingCardQueryModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateCall(AlipayMarketingCardUpdateModel alipayMarketingCardUpdateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayMarketingCardUpdateModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayMarketingCardUpdateModel;
        String localVarPath = "/v3/alipay/marketing/card/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateValidateBeforeCall(AlipayMarketingCardUpdateModel alipayMarketingCardUpdateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.updateCall(alipayMarketingCardUpdateModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayMarketingCardUpdateResponseModel update(AlipayMarketingCardUpdateModel alipayMarketingCardUpdateModel) throws ApiException {
        ApiResponse<AlipayMarketingCardUpdateResponseModel> localVarResp = this.updateWithHttpInfo(alipayMarketingCardUpdateModel, null);
        return localVarResp.getData();
    }

    public AlipayMarketingCardUpdateResponseModel update(AlipayMarketingCardUpdateModel alipayMarketingCardUpdateModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayMarketingCardUpdateResponseModel> localVarResp = this.updateWithHttpInfo(alipayMarketingCardUpdateModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayMarketingCardUpdateResponseModel> updateWithHttpInfo(AlipayMarketingCardUpdateModel alipayMarketingCardUpdateModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(alipayMarketingCardUpdateModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayMarketingCardUpdateResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayMarketingCardUpdateDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call updateAsync(AlipayMarketingCardUpdateModel alipayMarketingCardUpdateModel, ApiCallback<AlipayMarketingCardUpdateResponseModel> _callback) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(alipayMarketingCardUpdateModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardUpdateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAsync(AlipayMarketingCardUpdateModel alipayMarketingCardUpdateModel, ApiCallback<AlipayMarketingCardUpdateResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(alipayMarketingCardUpdateModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayMarketingCardUpdateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

