/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenAppServiceApplyDefaultResponse;
import com.alipay.v3.model.AlipayOpenAppServiceApplyModel;
import com.alipay.v3.model.AlipayOpenAppServiceApplyResponseModel;
import com.alipay.v3.model.AlipayOpenAppServiceDeleteDefaultResponse;
import com.alipay.v3.model.AlipayOpenAppServiceQueryDefaultResponse;
import com.alipay.v3.model.AlipayOpenAppServiceQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenAppServiceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenAppServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenAppServiceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call applyCall(AlipayOpenAppServiceApplyModel alipayOpenAppServiceApplyModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenAppServiceApplyModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenAppServiceApplyModel;
        String localVarPath = "/v3/alipay/open/app/service/apply";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyValidateBeforeCall(AlipayOpenAppServiceApplyModel alipayOpenAppServiceApplyModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyCall(alipayOpenAppServiceApplyModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenAppServiceApplyResponseModel apply(AlipayOpenAppServiceApplyModel alipayOpenAppServiceApplyModel) throws ApiException {
        ApiResponse<AlipayOpenAppServiceApplyResponseModel> localVarResp = this.applyWithHttpInfo(alipayOpenAppServiceApplyModel, null);
        return localVarResp.getData();
    }

    public AlipayOpenAppServiceApplyResponseModel apply(AlipayOpenAppServiceApplyModel alipayOpenAppServiceApplyModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenAppServiceApplyResponseModel> localVarResp = this.applyWithHttpInfo(alipayOpenAppServiceApplyModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenAppServiceApplyResponseModel> applyWithHttpInfo(AlipayOpenAppServiceApplyModel alipayOpenAppServiceApplyModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(alipayOpenAppServiceApplyModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenAppServiceApplyResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenAppServiceApplyDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call applyAsync(AlipayOpenAppServiceApplyModel alipayOpenAppServiceApplyModel, ApiCallback<AlipayOpenAppServiceApplyResponseModel> _callback) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(alipayOpenAppServiceApplyModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenAppServiceApplyResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call applyAsync(AlipayOpenAppServiceApplyModel alipayOpenAppServiceApplyModel, ApiCallback<AlipayOpenAppServiceApplyResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(alipayOpenAppServiceApplyModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenAppServiceApplyResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCall(String serviceCode, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/app/service/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (serviceCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("service_code", serviceCode));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(String serviceCode, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteCall(serviceCode, _callback, customizedParams);
        return localVarCall;
    }

    public Object delete(String serviceCode) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteWithHttpInfo(serviceCode, null);
        return localVarResp.getData();
    }

    public Object delete(String serviceCode, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteWithHttpInfo(serviceCode, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> deleteWithHttpInfo(String serviceCode, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(serviceCode, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenAppServiceDeleteDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call deleteAsync(String serviceCode, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(serviceCode, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAsync(String serviceCode, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(serviceCode, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String serviceCode, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/app/service/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (serviceCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("service_code", serviceCode));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String serviceCode, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(serviceCode, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenAppServiceQueryResponseModel query(String serviceCode) throws ApiException {
        ApiResponse<AlipayOpenAppServiceQueryResponseModel> localVarResp = this.queryWithHttpInfo(serviceCode, null);
        return localVarResp.getData();
    }

    public AlipayOpenAppServiceQueryResponseModel query(String serviceCode, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenAppServiceQueryResponseModel> localVarResp = this.queryWithHttpInfo(serviceCode, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenAppServiceQueryResponseModel> queryWithHttpInfo(String serviceCode, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(serviceCode, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenAppServiceQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenAppServiceQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(String serviceCode, ApiCallback<AlipayOpenAppServiceQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(serviceCode, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenAppServiceQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(String serviceCode, ApiCallback<AlipayOpenAppServiceQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(serviceCode, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenAppServiceQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

