/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenFeeAdjustApplyDefaultResponse;
import com.alipay.v3.model.AlipayOpenFeeAdjustApplyModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenFeeAdjustApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenFeeAdjustApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenFeeAdjustApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call applyCall(File attachment, File certPic, AlipayOpenFeeAdjustApplyModel data, File shopScenePic, File shopSignPic, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/fee/adjust/apply";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (attachment != null) {
            localVarFormParams.put("attachment", attachment);
        }
        if (certPic != null) {
            localVarFormParams.put("cert_pic", certPic);
        }
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        if (customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent())) {
            localVarFormParams.put("data", customizedParams.getBodyContent());
        }
        if (shopScenePic != null) {
            localVarFormParams.put("shop_scene_pic", shopScenePic);
        }
        if (shopSignPic != null) {
            localVarFormParams.put("shop_sign_pic", shopSignPic);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyValidateBeforeCall(File attachment, File certPic, AlipayOpenFeeAdjustApplyModel data, File shopScenePic, File shopSignPic, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyCall(attachment, certPic, data, shopScenePic, shopSignPic, _callback, customizedParams);
        return localVarCall;
    }

    public Object apply(File attachment, File certPic, AlipayOpenFeeAdjustApplyModel data, File shopScenePic, File shopSignPic) throws ApiException {
        ApiResponse<Object> localVarResp = this.applyWithHttpInfo(attachment, certPic, data, shopScenePic, shopSignPic, null);
        return localVarResp.getData();
    }

    public Object apply(File attachment, File certPic, AlipayOpenFeeAdjustApplyModel data, File shopScenePic, File shopSignPic, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.applyWithHttpInfo(attachment, certPic, data, shopScenePic, shopSignPic, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> applyWithHttpInfo(File attachment, File certPic, AlipayOpenFeeAdjustApplyModel data, File shopScenePic, File shopSignPic, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(attachment, certPic, data, shopScenePic, shopSignPic, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenFeeAdjustApplyDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call applyAsync(File attachment, File certPic, AlipayOpenFeeAdjustApplyModel data, File shopScenePic, File shopSignPic, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(attachment, certPic, data, shopScenePic, shopSignPic, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call applyAsync(File attachment, File certPic, AlipayOpenFeeAdjustApplyModel data, File shopScenePic, File shopSignPic, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(attachment, certPic, data, shopScenePic, shopSignPic, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

