/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenMiniInnerappServicePublishDefaultResponse;
import com.alipay.v3.model.AlipayOpenMiniInnerappServicePublishModel;
import com.alipay.v3.model.AlipayOpenMiniInnerappServicePublishResponseModel;
import com.alipay.v3.model.AlipayOpenMiniInnerappServiceQueryDefaultResponse;
import com.alipay.v3.model.AlipayOpenMiniInnerappServiceQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenMiniInnerappServiceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenMiniInnerappServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenMiniInnerappServiceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call publishCall(AlipayOpenMiniInnerappServicePublishModel alipayOpenMiniInnerappServicePublishModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenMiniInnerappServicePublishModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenMiniInnerappServicePublishModel;
        String localVarPath = "/v3/alipay/open/mini/innerapp/service/publish";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call publishValidateBeforeCall(AlipayOpenMiniInnerappServicePublishModel alipayOpenMiniInnerappServicePublishModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.publishCall(alipayOpenMiniInnerappServicePublishModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenMiniInnerappServicePublishResponseModel publish(AlipayOpenMiniInnerappServicePublishModel alipayOpenMiniInnerappServicePublishModel) throws ApiException {
        ApiResponse<AlipayOpenMiniInnerappServicePublishResponseModel> localVarResp = this.publishWithHttpInfo(alipayOpenMiniInnerappServicePublishModel, null);
        return localVarResp.getData();
    }

    public AlipayOpenMiniInnerappServicePublishResponseModel publish(AlipayOpenMiniInnerappServicePublishModel alipayOpenMiniInnerappServicePublishModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenMiniInnerappServicePublishResponseModel> localVarResp = this.publishWithHttpInfo(alipayOpenMiniInnerappServicePublishModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenMiniInnerappServicePublishResponseModel> publishWithHttpInfo(AlipayOpenMiniInnerappServicePublishModel alipayOpenMiniInnerappServicePublishModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.publishValidateBeforeCall(alipayOpenMiniInnerappServicePublishModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenMiniInnerappServicePublishResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenMiniInnerappServicePublishDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call publishAsync(AlipayOpenMiniInnerappServicePublishModel alipayOpenMiniInnerappServicePublishModel, ApiCallback<AlipayOpenMiniInnerappServicePublishResponseModel> _callback) throws ApiException {
        Call localVarCall = this.publishValidateBeforeCall(alipayOpenMiniInnerappServicePublishModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenMiniInnerappServicePublishResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call publishAsync(AlipayOpenMiniInnerappServicePublishModel alipayOpenMiniInnerappServicePublishModel, ApiCallback<AlipayOpenMiniInnerappServicePublishResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.publishValidateBeforeCall(alipayOpenMiniInnerappServicePublishModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenMiniInnerappServicePublishResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String miniAppId, String appSubType, String showType, String keyword, String pageNum, String pageSize, String appOrigin, Boolean includeOffline, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/mini/innerapp/service/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (miniAppId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("mini_app_id", miniAppId));
        }
        if (appSubType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("app_sub_type", appSubType));
        }
        if (showType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("show_type", showType));
        }
        if (keyword != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("keyword", keyword));
        }
        if (pageNum != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_num", pageNum));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (appOrigin != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("app_origin", appOrigin));
        }
        if (includeOffline != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("include_offline", includeOffline));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String miniAppId, String appSubType, String showType, String keyword, String pageNum, String pageSize, String appOrigin, Boolean includeOffline, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(miniAppId, appSubType, showType, keyword, pageNum, pageSize, appOrigin, includeOffline, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenMiniInnerappServiceQueryResponseModel query(String miniAppId, String appSubType, String showType, String keyword, String pageNum, String pageSize, String appOrigin, Boolean includeOffline) throws ApiException {
        ApiResponse<AlipayOpenMiniInnerappServiceQueryResponseModel> localVarResp = this.queryWithHttpInfo(miniAppId, appSubType, showType, keyword, pageNum, pageSize, appOrigin, includeOffline, null);
        return localVarResp.getData();
    }

    public AlipayOpenMiniInnerappServiceQueryResponseModel query(String miniAppId, String appSubType, String showType, String keyword, String pageNum, String pageSize, String appOrigin, Boolean includeOffline, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenMiniInnerappServiceQueryResponseModel> localVarResp = this.queryWithHttpInfo(miniAppId, appSubType, showType, keyword, pageNum, pageSize, appOrigin, includeOffline, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenMiniInnerappServiceQueryResponseModel> queryWithHttpInfo(String miniAppId, String appSubType, String showType, String keyword, String pageNum, String pageSize, String appOrigin, Boolean includeOffline, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(miniAppId, appSubType, showType, keyword, pageNum, pageSize, appOrigin, includeOffline, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenMiniInnerappServiceQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenMiniInnerappServiceQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(String miniAppId, String appSubType, String showType, String keyword, String pageNum, String pageSize, String appOrigin, Boolean includeOffline, ApiCallback<AlipayOpenMiniInnerappServiceQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(miniAppId, appSubType, showType, keyword, pageNum, pageSize, appOrigin, includeOffline, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenMiniInnerappServiceQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(String miniAppId, String appSubType, String showType, String keyword, String pageNum, String pageSize, String appOrigin, Boolean includeOffline, ApiCallback<AlipayOpenMiniInnerappServiceQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(miniAppId, appSubType, showType, keyword, pageNum, pageSize, appOrigin, includeOffline, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenMiniInnerappServiceQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

