package com.alipay.api.response;

import java.util.List;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;
import com.alipay.api.domain.HotelRoomFaceInfoRes;

import com.alipay.api.AlipayResponse;

/**
 * ALIPAY API: alipay.open.iotmbs.hoteldevice.query response.
 * 
 * @author auto create
 * @since 1.0, 2022-06-08 14:31:41
 */
public class AlipayOpenIotmbsHoteldeviceQueryResponse extends AlipayResponse {

	private static final long serialVersionUID = 6386844518568386333L;

	/** 
	 * 设备绑定的人脸数据列表
	 */
	@ApiListField("face_list")
	@ApiField("hotel_room_face_info_res")
	private List<HotelRoomFaceInfoRes> faceList;

	/** 
	 * 刷脸组ID
	 */
	@ApiField("group_id")
	private String groupId;

	/** 
	 * 设备绑定的酒店名称
	 */
	@ApiField("hotel_name")
	private String hotelName;

	/** 
	 * 设备绑定的房间号
	 */
	@ApiField("room_no")
	private String roomNo;

	/** 
	 * 0:未入住，1:入住
	 */
	@ApiField("room_status")
	private String roomStatus;

	public void setFaceList(List<HotelRoomFaceInfoRes> faceList) {
		this.faceList = faceList;
	}
	public List<HotelRoomFaceInfoRes> getFaceList( ) {
		return this.faceList;
	}

	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}
	public String getGroupId( ) {
		return this.groupId;
	}

	public void setHotelName(String hotelName) {
		this.hotelName = hotelName;
	}
	public String getHotelName( ) {
		return this.hotelName;
	}

	public void setRoomNo(String roomNo) {
		this.roomNo = roomNo;
	}
	public String getRoomNo( ) {
		return this.roomNo;
	}

	public void setRoomStatus(String roomStatus) {
		this.roomStatus = roomStatus;
	}
	public String getRoomStatus( ) {
		return this.roomStatus;
	}

}
