package com.alipay.api.domain;

import java.util.List;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;
import com.alipay.api.internal.mapping.ApiListField;

/**
 * 钱包动账明细
 *
 * @author auto create
 * @since 1.0, 2024-04-15 11:33:43
 */
public class AlipayCloudFundWalletOperationQueryModel extends AlipayObject {

	private static final long serialVersionUID = 4115728822146744336L;

	/**
	 * 业务类型
【枚举值】
核销: PAYMENT
核销退: REFUND
充值: DEPOSIT
提现: WITHDRAW
充退: RETURN
	 */
	@ApiListField("biz_types")
	@ApiField("string")
	private List<String> bizTypes;

	/**
	 * 当前页
	 */
	@ApiField("current_page")
	private String currentPage;

	/**
	 * 业务结束时间
	 */
	@ApiField("end_biz_dt")
	private String endBizDt;

	/**
	 * 分页大小
	 */
	@ApiField("page_size")
	private String pageSize;

	/**
	 * 业务开始时间
	 */
	@ApiField("start_biz_dt")
	private String startBizDt;

	/**
	 * 钱包id
	 */
	@ApiField("user_wallet_id")
	private String userWalletId;

	public List<String> getBizTypes() {
		return this.bizTypes;
	}
	public void setBizTypes(List<String> bizTypes) {
		this.bizTypes = bizTypes;
	}

	public String getCurrentPage() {
		return this.currentPage;
	}
	public void setCurrentPage(String currentPage) {
		this.currentPage = currentPage;
	}

	public String getEndBizDt() {
		return this.endBizDt;
	}
	public void setEndBizDt(String endBizDt) {
		this.endBizDt = endBizDt;
	}

	public String getPageSize() {
		return this.pageSize;
	}
	public void setPageSize(String pageSize) {
		this.pageSize = pageSize;
	}

	public String getStartBizDt() {
		return this.startBizDt;
	}
	public void setStartBizDt(String startBizDt) {
		this.startBizDt = startBizDt;
	}

	public String getUserWalletId() {
		return this.userWalletId;
	}
	public void setUserWalletId(String userWalletId) {
		this.userWalletId = userWalletId;
	}

}
