/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.msg;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.internal.util.AlipayLogger;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.internal.util.AntCertificationUtil;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.WebUtils;
import com.alipay.api.internal.util.file.FileUtils;
import com.alipay.api.internal.util.json.JSONWriter;
import com.alipay.api.msg.Message;
import com.alipay.api.msg.MsgConnector;
import com.alipay.api.msg.MsgHandler;
import com.alipay.api.msg.MsgStatusEnum;
import com.alipay.api.msg.ProduceMsgAck;
import com.alipay.api.msg.ProtocolData;
import com.alipay.api.msg.ProtocolDataContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.channels.NotYetConnectedException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AlipayMsgClient {
    private static Map<String, AlipayMsgClient> clientMap = new HashMap<String, AlipayMsgClient>();
    private String serverHost;
    private boolean isSSL = true;
    private MsgHandler messageHandler;
    private String appId;
    private String signType;
    private String appPrivateKey;
    private String alipayPublicKey;
    private String charset = "UTF-8";
    private int bizThreadPoolCoreSize = 5;
    private int bizThreadPoolMaxSize = 10;
    private boolean loadTest = false;
    private String appCertSN;
    private String alipayCertSN;
    private String alipayRootCertSN;
    private String rootCertContent;
    private ThreadPoolExecutor bizThreadPoolExecutor;
    private ScheduledThreadPoolExecutor heartBeatExecutor;
    private int reConnectTimes = 0;
    private long waitTime = 0L;
    private MsgConnector webSocketConnector;
    private LinkedBlockingQueue<String> sendingQueue = new LinkedBlockingQueue(200);
    private ConcurrentHashMap<String, ProtocolDataContext> sendingContexts = new ConcurrentHashMap(256);

    private AlipayMsgClient() {
    }

    public static synchronized AlipayMsgClient getInstance(String appId) {
        AlipayMsgClient client = clientMap.get(appId);
        if (client != null) {
            return client;
        }
        client = new AlipayMsgClient();
        clientMap.put(appId, client);
        client.appId = appId;
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws InterruptedException {
        if (this.appId == null || this.appPrivateKey == null || this.alipayPublicKey == null || this.serverHost == null || this.messageHandler == null) {
            throw new RuntimeException("Please set securityConfig, connector and messageHandler before connect");
        }
        if (this.bizThreadPoolExecutor == null || this.heartBeatExecutor == null) {
            AlipayMsgClient alipayMsgClient = this;
            synchronized (alipayMsgClient) {
                if (this.bizThreadPoolExecutor == null) {
                    this.bizThreadPoolExecutor = new ThreadPoolExecutor(this.bizThreadPoolCoreSize, this.bizThreadPoolMaxSize, 15000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(400), new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            return new Thread(r, "Alipay-Msg-Thread");
                        }
                    }, new ThreadPoolExecutor.AbortPolicy());
                }
                if (this.heartBeatExecutor == null) {
                    this.heartBeatExecutor = new ScheduledThreadPoolExecutor(1);
                    this.heartBeatExecutor.scheduleWithFixedDelay(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (AlipayMsgClient.this.isConnected()) {
                                    AlipayMsgClient.this.webSocketConnector.sendPing();
                                    AlipayMsgClient.this.reConnectTimes = 0;
                                } else {
                                    ReconnectStrategy[] strategies = ReconnectStrategy.values();
                                    while (!AlipayMsgClient.this.isConnected() && System.currentTimeMillis() - AlipayMsgClient.this.waitTime >= (long)strategies[AlipayMsgClient.this.reConnectTimes].getWatiTime()) {
                                        AlipayMsgClient.this.doConnect();
                                        AlipayMsgClient.this.waitTime = System.currentTimeMillis();
                                        AlipayMsgClient.this.reConnectTimes = ++AlipayMsgClient.this.reConnectTimes % strategies.length;
                                    }
                                }
                            }
                            catch (Throwable t) {
                                AlipayLogger.logBizError(t);
                            }
                        }
                    }, 0L, 2000L, TimeUnit.MILLISECONDS);
                }
            }
        }
        while (!this.isConnected()) {
            Thread.sleep(1000L);
        }
    }

    public boolean isConnected() {
        return this.webSocketConnector != null && this.webSocketConnector.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() throws Exception {
        if (this.isConnected()) {
            return;
        }
        AlipayMsgClient alipayMsgClient = this;
        synchronized (alipayMsgClient) {
            if (this.isConnected()) {
                return;
            }
            RegisterResponse regResp = this.register();
            HashMap<String, String> httpHeaders = new HashMap<String, String>(1);
            if (regResp.getZone() != null && regResp.getZone().length() > 0) {
                httpHeaders.put("cookie", "zone=" + regResp.getZone() + ";");
            }
            if (this.loadTest) {
                httpHeaders.put("LoadTest", "true");
            }
            httpHeaders.put("Content-Type", "application/x-www-form-urlencoded;charset=" + this.charset);
            HashMap<String, String> params = new HashMap<String, String>(5);
            params.put("app_id", this.appId);
            params.put("charset", this.charset);
            params.put("link_token", regResp.getLinkToken());
            params.put("timestamp", String.valueOf(System.currentTimeMillis()));
            params.put("sign_type", this.signType);
            params.put("sdk_version", "alipay-sdk-java-4.39.70.ALL");
            if (!StringUtils.isEmpty(this.alipayCertSN)) {
                params.put("app_cert_sn", this.appCertSN);
                params.put("alipay_root_cert_sn", this.alipayRootCertSN);
            }
            String signContent = AlipaySignature.getSignCheckContentV2(params);
            String sign = AlipaySignature.rsaSign(signContent, this.appPrivateKey, this.charset, this.signType);
            params.put("sign", sign);
            String query = WebUtils.buildQuery(params, this.charset);
            String urlStr = "ws" + (this.isSSL ? "s" : "") + "://" + this.serverHost + "/websocket?" + query;
            this.webSocketConnector = new MsgConnector(new URI(urlStr), httpHeaders, this, this.charset);
            if (!this.webSocketConnector.connectBlocking(10L, TimeUnit.SECONDS)) {
                throw new RuntimeException("connect timeout(10s)!");
            }
            if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
                AlipayLogger.logBizDebug("connected");
            }
        }
    }

    public ProduceMsgAck sendMessage(AlipayRequest msgReq) throws InterruptedException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        Message message = new Message();
        message.setxCmd("PRODUCE");
        message.setxSignType(this.signType);
        message.setxCharset(this.charset);
        message.setAppId(this.appId);
        message.setMsgApi(msgReq.getApiMethodName());
        message.setxTimestamp(System.currentTimeMillis());
        message.setBizContent(new JSONWriter().write(msgReq.getBizModel(), true));
        if (!StringUtils.isEmpty(this.appCertSN)) {
            message.setAppCertSN(this.appCertSN);
            message.setAlipayRootCertSN(this.alipayRootCertSN);
        }
        Message.addSign(message, this.appPrivateKey);
        ProtocolData protocolData = new ProtocolData();
        protocolData.setMessage(message);
        CountDownLatch signal = new CountDownLatch(1);
        ProtocolDataContext protocolDataContext = new ProtocolDataContext();
        protocolDataContext.setSendData(protocolData);
        protocolDataContext.setSendSignal(signal);
        if (!this.sendingQueue.offer(protocolData.getStreamId(), 200L, TimeUnit.MILLISECONDS)) {
            throw new RuntimeException("too many message not receive ack, refuse new send. streamId:" + protocolData.getStreamId());
        }
        this.sendingContexts.put(protocolData.getStreamId(), protocolDataContext);
        String protocolDataStr = ProtocolData.toStr(protocolData);
        if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
            AlipayLogger.logBizDebug("send msg:" + protocolDataStr.replaceAll("[\r\n]", " "));
        }
        this.webSocketConnector.send(ProtocolData.toStr(protocolData));
        boolean signalNotify = signal.await(10000L, TimeUnit.MILLISECONDS);
        this.sendingQueue.remove(protocolData.getStreamId());
        this.sendingContexts.remove(protocolData.getStreamId());
        if (!signalNotify) {
            AlipayLogger.logBizError("wait ack timeout(10s). streamId:" + protocolData.getStreamId());
            throw new RuntimeException("wait ack timeout(10s). streamId:" + protocolData.getStreamId());
        }
        ProtocolData ackData = protocolDataContext.getAckData();
        if (ackData == null) {
            throw new RuntimeException("ack protocol data null. streamId:" + protocolData.getStreamId());
        }
        Message ackMsg = ackData.getMessage();
        if (ackMsg == null) {
            throw new RuntimeException("ack msg null. streamId:" + protocolData.getStreamId());
        }
        ProduceMsgAck produceMsgAck = new ProduceMsgAck();
        produceMsgAck.setxStatus(MsgStatusEnum.fromStr(ackMsg.getxStatus()));
        produceMsgAck.setxCode(ackMsg.getxCode());
        produceMsgAck.setxError(ackMsg.getxError());
        produceMsgAck.setxMessageId(ackMsg.getxMessageId());
        return produceMsgAck;
    }

    @Deprecated
    public void close() throws InterruptedException {
        this.bizThreadPoolExecutor.shutdown();
        this.heartBeatExecutor.shutdown();
        Thread.sleep(1000L);
        this.webSocketConnector.closeBlocking();
    }

    public void destroy() throws InterruptedException {
        this.close();
        this.bizThreadPoolExecutor = null;
        this.heartBeatExecutor = null;
        this.reConnectTimes = 0;
        this.waitTime = 0L;
    }

    void onMessage(final String str) {
        try {
            this.bizThreadPoolExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProtocolData protocolData;
                    if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
                        AlipayLogger.logBizDebug("receive msg:" + str.replaceAll("[\r\n]", " "));
                    }
                    if ((protocolData = ProtocolData.fromStr(str)) == null) {
                        return;
                    }
                    Message message = protocolData.getMessage();
                    if (message == null) {
                        return;
                    }
                    if ("PRODUCE_ACK".equals(message.getxCmd())) {
                        ProtocolDataContext context = (ProtocolDataContext)AlipayMsgClient.this.sendingContexts.get(protocolData.getStreamId());
                        if (context == null) {
                            AlipayLogger.logBizError("sendingContexts not found. streamId:" + protocolData.getStreamId());
                            return;
                        }
                        context.setAckData(protocolData);
                        context.getSendSignal().countDown();
                    } else if ("CONSUME".equals(message.getxCmd())) {
                        boolean checkSign = false;
                        try {
                            checkSign = Message.checkSign(message, AlipayMsgClient.this.alipayPublicKey);
                        }
                        catch (Throwable t) {
                            AlipayLogger.logBizError("check message sign exception. str:" + str + " exception:" + t.getMessage());
                        }
                        if (!checkSign) {
                            AlipayLogger.logBizError("check message sign fail. str:" + str);
                        }
                        Message consumeAckMsg = new Message();
                        consumeAckMsg.setxCmd("CONSUME_ACK");
                        consumeAckMsg.setxMessageId(message.getxMessageId());
                        consumeAckMsg.setxStatus("SUCCESS");
                        ProtocolData consumeAckData = new ProtocolData();
                        consumeAckData.setFromSys(protocolData.getFromSys());
                        consumeAckData.setFromSysIp(protocolData.getFromSysIp());
                        consumeAckData.setStreamId(protocolData.getStreamId());
                        consumeAckData.setMessage(consumeAckMsg);
                        try {
                            AlipayMsgClient.this.messageHandler.onMessage(message.getMsgApi(), message.getxMessageId(), message.getBizContent());
                        }
                        catch (Throwable t) {
                            AlipayLogger.logBizError("consume message exception. str:" + str + " exception:" + t.getMessage());
                            consumeAckMsg.setxStatus("FAIL");
                        }
                        finally {
                            AlipayMsgClient.this.webSocketConnector.send(ProtocolData.toStr(consumeAckData));
                        }
                    } else {
                        AlipayLogger.logBizError("unknown message cmd. str:" + str);
                    }
                }
            });
        }
        catch (Throwable e) {
            AlipayLogger.logBizError(e);
        }
    }

    public void setBizThreadPoolCoreSize(int coreSize) {
        this.bizThreadPoolCoreSize = coreSize;
        if (this.bizThreadPoolExecutor != null) {
            this.bizThreadPoolExecutor.setCorePoolSize(coreSize);
        }
    }

    public void setBizThreadPoolMaxSize(int maxSize) {
        this.bizThreadPoolMaxSize = maxSize;
        if (this.bizThreadPoolExecutor != null) {
            this.bizThreadPoolExecutor.setMaximumPoolSize(maxSize);
        }
    }

    public void setConnector(String serverHost) throws Exception {
        this.setConnector(serverHost, true);
    }

    public void setConnector(String serverHost, boolean isSSL) throws Exception {
        this.serverHost = serverHost;
        this.isSSL = isSSL;
    }

    public void setMessageHandler(MsgHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void setSecurityConfig(String signType, String appPrivateKey, String alipayPublicKey) {
        this.signType = signType;
        this.appPrivateKey = appPrivateKey;
        this.alipayPublicKey = alipayPublicKey;
    }

    public void setSecurityCertConfig(String signType, String appPrivateKey, String certPath, String alipayPublicCertPath, String rootCertPath) throws AlipayApiException {
        this.signType = signType;
        this.appPrivateKey = appPrivateKey;
        this.alipayPublicKey = AntCertificationUtil.getAlipayPublicKey(alipayPublicCertPath);
        this.alipayCertSN = AntCertificationUtil.getCertSN(AntCertificationUtil.getCertFromPath(alipayPublicCertPath));
        this.appCertSN = AntCertificationUtil.getCertSN(AntCertificationUtil.getCertFromPath(certPath));
        this.rootCertContent = this.readFileToString(rootCertPath);
        this.alipayRootCertSN = AntCertificationUtil.getRootCertSN(this.rootCertContent, signType);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setLoadTest(boolean loadTest) {
        this.loadTest = loadTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterResponse register() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        params.put("sign_type", this.signType);
        params.put("app_id", this.appId);
        params.put("charset", this.charset);
        params.put("sdk_version", "alipay-sdk-java-4.39.70.ALL");
        params.put("nonce", UUID.randomUUID().toString().replace("-", ""));
        if (!StringUtils.isEmpty(this.alipayCertSN)) {
            params.put("app_cert_sn", this.appCertSN);
            params.put("alipay_root_cert_sn", this.alipayRootCertSN);
        }
        String signContent = AlipaySignature.getSignCheckContentV2(params);
        String sign = AlipaySignature.rsaSign(signContent, this.appPrivateKey, this.charset, this.signType);
        params.put("sign", sign);
        String query = WebUtils.buildQuery(params, this.charset);
        String urlStr = "http" + (this.isSSL ? "s" : "") + "://" + this.serverHost + "/websocket/register.do?" + query;
        URL url = new URL(urlStr);
        HttpURLConnection conn = null;
        InputStream stream = null;
        String rsp = null;
        try {
            InputStream es;
            conn = WebUtils.getConnection(url, "GET", "application/x-www-form-urlencoded;charset=" + this.charset, null);
            if (this.loadTest) {
                conn.setRequestProperty("LoadTest", "true");
            }
            stream = (es = conn.getErrorStream()) == null ? conn.getInputStream() : es;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, this.charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            rsp = writer.toString();
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        RegisterResponse res = new RegisterResponse();
        res.setLinkToken(this.parseRegResp(rsp));
        res.setZone(this.parseRegRespHeader(conn.getHeaderFields()));
        return res;
    }

    private String parseRegResp(String rsp) throws Exception {
        int idx;
        String rspCode;
        int rIdx;
        int contentBegin;
        if (rsp == null || rsp.length() <= 0) {
            throw new RuntimeException("register response is empty! " + rsp);
        }
        if (!rsp.trim().startsWith("{")) {
            throw new RuntimeException("register response error! " + rsp);
        }
        int contentEnd = -1;
        for (contentBegin = rsp.indexOf("\"response\"") + "\"response\"".length(); contentBegin < rsp.length() && rsp.charAt(contentBegin) != ':'; ++contentBegin) {
        }
        while (contentBegin < rsp.length() && rsp.charAt(contentBegin) != '{') {
            ++contentBegin;
        }
        int signBegin = -1;
        String sign = null;
        String signContent = null;
        StringBuilder sb = new StringBuilder();
        if (rIdx > "\"sign\"".length()) {
            int snEnd;
            int snBegin;
            String sn;
            for (rIdx = rsp.lastIndexOf("\"sign\"") + "\"sign\"".length(); rIdx < rsp.length() && rsp.charAt(rIdx) != ':'; ++rIdx) {
            }
            while (rIdx < rsp.length() && rsp.charAt(rIdx) != '\"') {
                ++rIdx;
            }
            signBegin = ++rIdx;
            while (rsp.charAt(rIdx) != '\"' && sb.append(rsp.charAt(rIdx)) != null) {
                ++rIdx;
            }
            sign = sb.toString();
            for (rIdx = signBegin; rIdx > 0 && rsp.charAt(rIdx) != '}'; --rIdx) {
            }
            contentEnd = rIdx + 1;
            signContent = rsp.substring(contentBegin, contentEnd);
            if (rsp.indexOf("alipay_cert_sn") > 1 && !this.alipayCertSN.equals(sn = rsp.substring(snBegin = rsp.indexOf("\"alipay_cert_sn\"") + "\"alipay_cert_sn\"".length() + 2, snEnd = rsp.lastIndexOf("}") - 1))) {
                throw new RuntimeException("register response alipay_cert_sn check fail! " + rsp);
            }
            if (!AlipaySignature.rsaCheck(signContent, sign, this.alipayPublicKey, this.charset, this.signType)) {
                throw new RuntimeException("register response sign check fail! " + rsp);
            }
        } else {
            rIdx = rsp.lastIndexOf("}");
            --rIdx;
            while (rIdx > 0 && rsp.charAt(rIdx) != '}') {
                --rIdx;
            }
            contentEnd = rIdx + 1;
            signContent = rsp.substring(contentBegin, contentEnd);
        }
        if ("10000".equals(rspCode = (signContent = signContent.replaceAll("[ \t\n]", "")).substring(idx = signContent.indexOf("\"code\":\"") + "\"code\":\"".length(), signContent.indexOf(34, idx))) || "100000000".equals(rspCode)) {
            if (signBegin < 0) {
                throw new RuntimeException("register response code means success but sign is empty! " + rsp);
            }
        } else {
            throw new RuntimeException("register response code means fail! " + signContent);
        }
        idx = signContent.indexOf("\"link_token\":\"") + "\"link_token\":\"".length();
        return signContent.substring(idx, signContent.indexOf(34, idx));
    }

    private String parseRegRespHeader(Map<String, List<String>> respHeaders) {
        String zone = null;
        List<String> cookies = respHeaders.get("set-cookie");
        if ((cookies == null || cookies.isEmpty()) && ((cookies = respHeaders.get("Set-Cookie")) == null || cookies.isEmpty())) {
            cookies = respHeaders.get("Set-cookie");
        }
        if (cookies != null && !cookies.isEmpty()) {
            for (String cookie : cookies) {
                String[] kvs;
                if (cookie == null || cookie.length() <= 0) continue;
                for (String kv : kvs = cookie.split(";")) {
                    String[] pair;
                    if (!kv.contains("zone=") || !"zone".equals((pair = kv.split("="))[0].trim())) continue;
                    zone = pair[1].trim();
                }
            }
        }
        return zone;
    }

    private String readFileToString(String rootCertPath) throws AlipayApiException {
        try {
            return FileUtils.readFileToString(new File(rootCertPath));
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
    }

    private static class RegisterResponse {
        private String linkToken;
        private String zone;

        private RegisterResponse() {
        }

        String getLinkToken() {
            return this.linkToken;
        }

        void setLinkToken(String linkToken) {
            this.linkToken = linkToken;
        }

        String getZone() {
            return this.zone;
        }

        void setZone(String zone) {
            this.zone = zone;
        }
    }

    private static enum ReconnectStrategy {
        ONE(0),
        TWO(5000),
        THREE(10000);

        private int watiTime;

        private ReconnectStrategy(int watiTime) {
            this.watiTime = watiTime;
        }

        public int getWatiTime() {
            return this.watiTime;
        }
    }
}

