package com.alipay.api.internal.util;

import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.custom.gm.SM2P256V1Curve;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.*;
import java.security.cert.Certificate;
import java.security.cert.*;
import java.util.*;

/**
 * ֤ļУ
 * @author junying.wjy
 * @version $Id: AntCertificationUtil.java, v 0.1 2019-07-29 04:46 junying.wjy Exp $
 */
public class AntCertificationUtil {

    private static      BouncyCastleProvider provider;

    static {
        provider = new BouncyCastleProvider();
        Security.addProvider(provider);
    }

    /**
     * ֤֤Ƿ
     *
     * @param cert            Ҫ֤Ŀ֤֤
     * @param rootCertContent Ÿ֤б
     */
    public static boolean isTrusted(String cert, String rootCertContent) {
        X509Certificate[] certificates;
        try {
            certificates = readPemCertChain(cert);
        } catch (Exception e) {
            AlipayLogger.logBizError(("ȡ֤ʧ"));
            throw new RuntimeException(e);
        }

        List<X509Certificate> rootCerts = new ArrayList<X509Certificate>();
        try {
            X509Certificate[] certs = readPemCertChain(rootCertContent);
            for (X509Certificate c : certs) {
                rootCerts.add(c);
            }
        } catch (Exception e) {
            AlipayLogger.logBizError(("ȡ֤ʧ"));
            throw new RuntimeException(e);
        }

        boolean result = verifyCertChain(certificates, rootCerts.toArray(new X509Certificate[rootCerts.size()]));
        return result;
    }

    /**
     * ֤֤Ƿ֤֤ǩ
     *
     * @param cert      Ŀ֤֤
     * @param rootCerts Ÿ֤б
     * @return ֤
     */
    private static boolean verifyCert(X509Certificate cert, X509Certificate[] rootCerts) {
        try {
            cert.checkValidity();
        } catch (CertificateExpiredException e) {
            AlipayLogger.logBizError(("֤Ѿ"));
            return false;
        } catch (CertificateNotYetValidException e) {
            AlipayLogger.logBizError(("֤δ"));
            return false;
        }

        Map<Principal, X509Certificate> subjectMap = new HashMap<Principal, X509Certificate>();

        for (X509Certificate root : rootCerts) {
            subjectMap.put(root.getSubjectDN(), root);
        }

        Principal issuerDN = cert.getIssuerDN();
        X509Certificate issuer = subjectMap.get(issuerDN);
        if (issuer == null) {
            AlipayLogger.logBizError(("֤֤ʧ"));
            return false;
        }
        try {
            PublicKey publicKey = issuer.getPublicKey();
            verifySignature(publicKey, cert);
        } catch (Exception e) {
            AlipayLogger.logBizError(("֤֤ʧ"));
            return false;
        }
        return true;
    }

    /**
     * ֤֤Ƿ֤֤ǩ
     *
     * @param certs     Ŀ֤֤б
     * @param rootCerts Ÿ֤б
     * @return ֤
     */
    private static boolean verifyCertChain(X509Certificate[] certs, X509Certificate[] rootCerts) {
        boolean sorted = sortByDn(certs);
        if (!sorted) {
            AlipayLogger.logBizError(("֤֤ʧܣ֤"));
            return false;
        }

        //֤һ֤ǲο֤ǩ
        X509Certificate prev = certs[0];
        boolean firstOK = verifyCert(prev, rootCerts);
        if (!firstOK || certs.length == 1) {
            return firstOK;
        }

        //֤֤
        for (int i = 1; i < certs.length; i++) {
            try {
                X509Certificate cert = certs[i];
                try {
                    cert.checkValidity();
                } catch (CertificateExpiredException e) {
                    AlipayLogger.logBizError(("֤Ѿ"));
                    return false;
                } catch (CertificateNotYetValidException e) {
                    AlipayLogger.logBizError(("֤δ"));
                    return false;
                }
                verifySignature(prev.getPublicKey(), cert);
                prev = cert;
            } catch (Exception e) {
                AlipayLogger.logBizError(("֤֤ʧ"));
                return false;
            }
        }

        return true;
    }

    private static void verifySignature(PublicKey publicKey, X509Certificate cert)
            throws NoSuchProviderException, CertificateException, NoSuchAlgorithmException, InvalidKeyException,
            SignatureException {
        cert.verify(publicKey, provider.getName());
    }

    /**
     * ֤ǩ˳֤Ϊ[issuerA, subjectA]-[issuerA, subjectB]-[issuerB, subjectC]-[issuerC, subjectD]...
     *
     * @param certs ֤
     * @return trueɹfalse֤
     */
    private static boolean sortByDn(X509Certificate[] certs) {
        //֤ӳ
        Map<Principal, X509Certificate> subjectMap = new HashMap<Principal, X509Certificate>();
        //ǩߺ֤ӳ
        Map<Principal, X509Certificate> issuerMap = new HashMap<Principal, X509Certificate>();
        //Ƿǩ֤
        boolean hasSelfSignedCert = false;

        for (X509Certificate cert : certs) {
            if (isSelfSigned(cert)) {
                if (hasSelfSignedCert) {
                    return false;
                }
                hasSelfSignedCert = true;
            }

            Principal subjectDN = cert.getSubjectDN();
            Principal issuerDN = cert.getIssuerDN();

            subjectMap.put(subjectDN, cert);
            issuerMap.put(issuerDN, cert);
        }

        List<X509Certificate> certChain = new ArrayList<X509Certificate>();

        X509Certificate current = certs[0];
        addressingUp(subjectMap, certChain, current);
        addressingDown(issuerMap, certChain, current);

        //˵֤
        if (certs.length != certChain.size()) {
            return false;
        }

        //֤Ƶԭȵ
        for (int i = 0; i < certChain.size(); i++) {
            certs[i] = certChain.get(i);
        }
        return true;
    }

    /**
     * ֤֤Ƿǩ
     *
     * @param cert Ŀ֤
     * @return trueǩfalseǩ
     */
    private static boolean isSelfSigned(X509Certificate cert) {
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    /**
     * Ϲ֤
     *
     * @param subjectMap ֤ӳ
     * @param certChain  ֤
     * @param current    ǰҪ֤֤飬include
     */
    private static void addressingUp(final Map<Principal, X509Certificate> subjectMap, List<X509Certificate> certChain,
                                     final X509Certificate current) {
        certChain.add(0, current);
        if (isSelfSigned(current)) {
            return;
        }
        Principal issuerDN = current.getIssuerDN();
        X509Certificate issuer = subjectMap.get(issuerDN);
        if (issuer == null) {
            return;
        }
        addressingUp(subjectMap, certChain, issuer);
    }

    /**
     * ¹֤
     *
     * @param issuerMap ǩߺ֤ӳ
     * @param certChain ֤
     * @param current   ǰҪ֤֤飬exclude
     */
    private static void addressingDown(final Map<Principal, X509Certificate> issuerMap, List<X509Certificate> certChain,
                                       final X509Certificate current) {
        Principal subjectDN = current.getSubjectDN();
        X509Certificate subject = issuerMap.get(subjectDN);
        if (subject == null) {
            return;
        }
        if (isSelfSigned(subject)) {
            return;
        }
        certChain.add(subject);
        addressingDown(issuerMap, certChain, subject);
    }

    private static X509Certificate[] readPemCertChain(String cert) throws CertificateException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(cert.getBytes());
        CertificateFactory factory = CertificateFactory.getInstance("X.509", provider);
        Collection<? extends Certificate> certificates = factory.generateCertificates(inputStream);
        return (X509Certificate[]) certificates.toArray(new X509Certificate[certificates.size()]);
    }


    /**
     * ȡ֤к
     * @param rootCertContent
     * @return
     */
    public static String getRootCertSN(String rootCertContent){
        String rootCertSN = null;
        try {
            X509Certificate[] x509Certificates = readPemCertChain(rootCertContent);
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (X509Certificate c : x509Certificates) {
                if(c.getSigAlgOID().startsWith("1.2.840.113549.1.1")){
                    md.update((c.getIssuerX500Principal().getName() + c.getSerialNumber()).getBytes());
                    String certSN = new BigInteger(1,md.digest()).toString(16);
                    //BigInteger0ʡԵ貹ȫ32λ
                    certSN = fillMD5(certSN);
                    if(StringUtils.isEmpty(rootCertSN)){
                        rootCertSN = certSN;
                    }else {
                        rootCertSN = rootCertSN + "_" + certSN;
                    }
                }

            }
        }catch (Exception e){
            AlipayLogger.logBizError(("ȡ֤ʧ"));
        }
        return rootCertSN;

    }
    private static String fillMD5(String md5){
        return md5.length()==32?md5:fillMD5("0"+md5);
    }


}
